        list p=16F628
	#include<p16F628.inc>


	__CONFIG        _BODEN_ON & _CP_OFF & _DATA_CP_OFF & _PWRTE_ON & _WDT_OFF & _LVP_OFF & _MCLRE_OFF & _XT_OSC
	;_INTRC_OSC_NOCLKOUT

;==========================================================================
;       Variable Definition
;==========================================================================
SW1		EQU     H'00'		;SW1 is triggering RA0
SW2		EQU     H'01'		;SW2 is triggering RA1
SW3		EQU     H'02'		;SW3 is triggering RA2
SW4		EQU     H'03'		;SW4 is triggering RA3
TIMERTICK	EQU	H'20'		;Used in delay routine
mstick		EQU	H'21'		; "	"	"	
seconds		EQU	22h
minutes		EQU	23H
hours		EQU	24h	
days		EQU	25h
op_case		EQU	32H		;Flags for next operation
counter60	EQU	H'26'		;counter 60 sec
counter10	EQU	H'27'		;counter 10 sec
button		equ 	0
ac230_on	equ	1
generator_off	equ	2
count10		equ	3
count60		equ	4
ac230_off	equ	5
msec_flag	equ	6
sec_flag	equ	7

		ORG	0		;Reset vector address
		GOTO	RESET		;goto RESET routine when boot.


;		*********************************************
;		*  Example of a delay routine               *
;		*********************************************


initiate	movlw	0
		movwf	op_case		; clear all flags
		
		movwf	TIMERTICK	; compare with TMR0 =0
		movlw	.250		; 250 * 4ms = 1sec
		movwf	mstick
		movlw	.60
		movwf	seconds
		movwf	minutes
		movlw	.24
		movwf	days
		return
setcount10 	bsf	op_case,count10
		movlw	D'10'
		movwf	counter10
		return

button_pressed	bcf	op_case,button
		bcf	op_case,count10	; abort countdown start
		bsf	op_case,count60
		movlw	D'60'
		movwf	counter60
		bsf	op_case,ac230_off
		bsf	PORTB,5		;testing ack
		return
off_ac		bcf 	PORTB,1		;relay 1 off
		bcf	op_case,ac230_off
		return
on_ac		bsf 	PORTB,1		;relay 1 on
		bcf	op_case,ac230_on
		bcf	op_case,count10
		return
off_gen		bsf	PORTB,2		;relay 2 on
		return			; wait for power to go down
ccount10	decfsz	counter10,F
		return
		bsf 	op_case,ac230_on
		return
ccount60	decfsz	counter60,F
		return
		bsf 	op_case,generator_off
		return
MSEC_event	movlw	.125		; 125* 32us = 4msec
		addwf	TIMERTICK,f
		bsf	op_case,msec_flag
		return

msecjob         bcf	op_case, msec_flag
		decfsz	mstick,f
		return
		movlw	.250		; 250 * 4ms = 1sec
		movwf	mstick
		bsf 	op_case,sec_flag
		return
onesecjob	bcf	op_case,sec_flag
		MOVLW	B'00000001'	;toggle LED1 (RB0)
		XORWF	PORTB,F
		BTFSC	PORTA,SW1
		BSF	op_case,button	; check INPUT
		btfsc	op_case,count10	; countdown 10sec
		call	ccount10
		btfsc	op_case,count60	;countdown 60sec
		call	ccount60
		decfsz	minutes
		return
		movlw	.60		;jobs every minute
		movwf	minutes
		decfsz	hours
		return
		movlw	.60		;jobs every hour
		movwf	hours
		decfsz	days
		return
		movlw	.24		; jobs every day
		movwf	days


		return

;	       **********************************
;              **  RESET :  main boot routine  **
;              **********************************

RESET		MOVLW	B'00000111'	;Disable Comparator module's
		MOVWF	CMCON
		;
		BSF	STATUS,RP0	;Switch to register bank 1
					;Disable pull-ups
					;INT on rising edge
					;TMR0 to CLKOUT
					;TMR0 Incr low2high trans.
					;Prescaler assign to Timer0
					;Prescaler rate is 1:32
		MOVLW	B'11010100'	;Set PIC options (See datasheet).
		MOVWF	OPTION_REG	;Write the OPTION register.
		;
		CLRF	INTCON		;Disable interrupts
		MOVLW	B'11000000'
		MOVWF	TRISB		;RB7 & RB6 are inputs.
					;RB5...RB0 are outputs.
		MOVLW	B'11111111'	;all RA ports are inputs
		MOVWF	TRISA
		BCF	STATUS,RP0	;Switch Back to reg. Bank 0
		CLRF	PORTB		
		;
		call	initiate	;initiate variables
		call	setcount10	;10 sec wait for ac230 on
main_loop	movfw	TIMERTICK	
		subwf	TMR0,w		;w=TIMERTICK-timr0
		andlw	0C0H		;slack 63*32 cycles
		SKPNZ
		call	MSEC_event	; 125 timerticks more
		BTFSC	op_case,msec_flag
		call	msecjob		;frequent jobs to be done in 4ms 
		BTFSC	op_case,sec_flag
		call	onesecjob	;occasional jobs to be done
		BTFSC	op_case,button	; from here on 
               	call	button_pressed	;permanent jobs 
		BTFSC	op_case,ac230_off
		call	off_ac
		btfsc	op_case,ac230_on
		call	on_ac
		btfsc	op_case,generator_off
		call	off_gen
		
		GOTO	main_loop


		END
