;**********************************************************************
;
;	CN003 - test try
;
; LED flasher using PRBS.Drivibg LED's on GP0,GP1,GP2. GP3  uses weak pull up to 
;
;**********************************************************************
;                                                                     *
;   This file is a basic code template for assembly code generation   *
;   on the PICmicro PIC10F204. This file contains the basic code      *
;   building blocks to build upon.                                    *
;                                                                     *
;   Refer to the MPASM User's Guide for additional information on     *
;   features of the assembler (Document DS33014).                     *
;                                                                     *
;   Refer to the respective PICmicro data sheet for additional        *
;   information on the instruction set.                               *
;                                                                     *
;	Use WDT and sleep to clock the code.                              *
;                                                                     *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Filename:	    	CN004.asm
;    Date:				May 2010	
;    File Version:           						  	              *
;                                                    			      *
;    Author:			Doug Rice
;    Company:                                                         *
;                                                                     * 
;                                                                     *
;**********************************************************************
;                                                                     *
;    Files required:                                                  *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************
;                													  *
;                                       				              *
;
;    Notes:                                                           *
;
;	PICkit2 Programming Header	10F204
;	1	Vpp,/MCLR				p8
;	2	Vdd						p2
;	3	Vss						p7
;	4	ICSPDAT,PGD				p5
;	5	ICSPCLK,PGC				p4
;	6	AUX				
;
; 				n/c		1[ 	]8 GP3,/MCLR,Vpp
; 				Vdd		2[ 	]7 Vss
; GP2,TOCKI,COUT,FOSC4	3[ 	]6 N/C
; clk		GP1/CIN-	4[ 	]5 GP0,CIN+	DAT
;
;LED's connected to GP1,GP0 to Vss									  *
;LED's connected to GP2     to Vdd                         			  *
;                                                                     *
;    Battery connected via 150 ohms to limit current.                 *
;                                                                     *
;**********************************************************************

	list      p=10F204            ; list directive to define processor
	#include <p10F204.inc>        ; processor specific variable definitions

;	__CONFIG   _MCLRE_OFF & _CP_OFF & _WDT_OFF
	__CONFIG   _MCLRE_OFF & _CP_OFF & _WDT_ON

; '__CONFIG' directive is used to embed configuration word within .asm file.
; The lables following the directive are located in the respective .inc file. 
; See respective data sheet for additional information on configuration word.


     cblock	0x10
		RN1
		RN2
		RN3
		RNconst
		Racc
      endc

;**********************************************************************
	org     0xFF             ; processor reset vector
	movlw	0x40


;****************************** START OF CODE *********************************
	org 	0x00


InitializeSFRs

    ; set up WDT and prescaler
	movlw	b'10001010' ; 1:32TMR0 prescaler: 1E-6 x 256 x 256, weak pullups disabled
	option

	movlw	b'01110000' ; turn off comparator
	movwf	CMCON0

	movlw	b'000001000'	; Outputs: LED 

	tris	GPIO


	; Skip if RESET
	; bit 4 TO: Time-out bit
	; 1 = After power-up, CLRWDT instruction or SLEEP instruction
	; 0 = A WDT time-out occurred 
	; Skip if RESET
	btfss	STATUS,NOT_TO
	goto	main

	; run this code for powerup init
	; flash LED's on power up
	movlw	b'000000011'	; Outputs: LED between GP0 and Vss,  GP1 and Vss , GP2 and Vdd
	movwf	GPIO		

	movlw	0xfe 	;****** REMOVE THIS LINE FOR PRODUCTION ****** 	
	movwf	OSCCAL		; load the factory oscillator calibration value
	
	clrf	RN1
	clrf	RN2
	clrf	RN3
	movlw	-1
	movwf	RNconst		
	movwf	RN1	

	btfss	GPIO,3
	movlw	b'000000100'	; Outputs: LED between GP0 and Vss,  GP1 and Vss , GP2 and Vdd
	movwf	GPIO		
	
	; c  =  x^0 + x^1  ; + means xor, x^0 means bit 0 
 
 	
;******************************************************************************
; InitializeSFRs - Initialize Special Function Registers
;
;******************************************************************************

main
	clrwdt

random
	; add constant with holes in to shift bits left to the holes
	rlf		RN1,w
	xorwf	RN1,w
	andlw	0x04
	addwf	RNconst,w
	rrf		RN3,f
	rrf		RN2,f
	rrf		RN1,f

	; now toggle LED
    rlf		RN3,w
	rlf		Racc,f

    rlf		RN2,w
	rlf		Racc,f

    rlf		RN1,w
	rlf		Racc,f
	
	btfss	GPIO,3
	goto	other
	
	movfw	Racc
	andwf	RN1,w
	andlw	0x07	
	xorwf	GPIO,f	   	; Outputs: LED between GP0 and Vss,  GP1 and Vss , GP2 and Vdd

  	sleep		  ; sleep and await WDT
  
  	nop
  	
  	
	; these do not seem to be used
  	nop	
	goto		main


other	
	movfw	Racc
	xorwf	RN1,w
	andlw	0x07	
	xorlw	0x04 ; Outputs: LED between GP0 and Vss,  GP1 and Vss , GP2 and Vdd
	movwf	GPIO

	;sleep and use wdt to reset chip.
  	sleep		  ; sleep and await WDT
  	nop

	; these do not seem to be used
  	nop	
	goto		main
		   
	END                       ; directive 'end of program'
