;
;			Software License Agreement
;
; The software supplied herewith by Michaels Prototype
; (the Company) for  PICmicro Microcontroller is intended and 
; supplied to you, the Companys customer, for use solely and 
; exclusively on Microchip PICmicro Microcontroller products. The 
; software is owned by the Company and/or its supplier, and is 
; protected under applicable copyright laws. All rights are reserved. 
;  Any use in violation of the foregoing restrictions may subject the 
; user to criminal sanctions under applicable laws, as well as to 
; civil liability for the breach of the terms and conditions of this 
; license.
;
; THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
; WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
; TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
; PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
; IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
; CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
;
;==============================================================================
;File name: dc-dc1.asm
;
;This program demonstrates how a PICmicro with comparator, ie: PIC16C620A,
;can be used to control voltage or current, such as in a switched mode dc/dc
;converter. This example employs the pulse skipping modulation (psm) technique
;to drive the external power converter circuit.
;
;==============================================================================
;author:	Gerhard Michael Drygas
;company:	Michaels Prototype
;date:		11-09-2006
;MPLAB version:	7.41
;
;==============================================================================
	LIST P = 16F627, F=INHX8M
	#INCLUDE <P16F627.INC>
	__config _WDT_OFF & _HS_OSC & _BODEN_ON & _PWRTE_ON

;Pin definition
#define	PULSE	PORTB,7		;pulse output to the power transistor

;Constants
VREF_HI	 equ b'10101100'	;high voltage setpoint, vref = vdd/2
VREF_MID equ b'10100110'	;mid voltage setpoint, vref = vdd/4
VREF_LO	 equ b'10100010'	;low voltage setpoint, vref = vdd/12
TMR0_RELOAD equ	.215		;reload value for tmr0

;RAM
;*** register bank limits
#define ram0_start 0x20
#define ram0_end 0x7f
#define ram0_length ram0_end - ram0_start + 1
#define ram1_start 0xa0
#define ram1_end 0xef
#define ram1_length ram1_end - ram1_start + 1
FLAG	equ 0x20		;flag register
	;bit0	1=feedback voltage is less than setpoint
W_TEMP	equ 0x24		;temporary w register
STATUS_TEMP equ 0x25		;temporary status register

;==============================================================================
        org	00
	goto	start
	;
;isr is the interrupt service routine.
;in this routine tmr0 is reloaded with the TMR0_RELOAD value. tmr0 operates as
;the time base for the psm modulator.
;the voltage on an0 pin is compared to the vref:
;	if an1 > vref, then skip the next psm pulse
;	if an1 < vref, then do not skip psm pulse
;
	org	04
isr:	movwf	W_TEMP		;save w and status
	swapf	STATUS,W
	bcf	STATUS,RP0
	movwf	STATUS_TEMP
	;
	movlw	TMR0_RELOAD	;reload tmr0
	movwf	TMR0
	bsf	FLAG,0
	btfss	CMCON,C2OUT	;if van1 > vsetpoint,
	bcf	FLAG,0		;	then skip next pulse
	bcf	PULSE		;turn off output pulse
	bcf	INTCON,T0IF	;clear tmr0 interrupt flag
	btfss	FLAG,0		;if skip pulse,
	goto	isr_done	;	then exit
	bsf	PULSE		;else begin a new output pulse
isr_done:
	swapf	STATUS_TEMP,W	;restore w and status, and exit
	movwf	STATUS
	swapf	W_TEMP,F
	swapf	W_TEMP,W
	retfie
	;
	;
;start is the main program of this firmware smps controller.
;i/o ports are initialized.
;tmr0 is configured to run from the internal oscillator with no prescalar. the
;tmr0 interrupt is also enabled.
;the comparators and vref modules are initialized.
;the rest of this main program is an infinite loop. if the microcontroller is
;used for other non timing critical functions, the code for these functions
;should reside within the main program.
;
start:	bcf	STATUS,RP0	;bank0
	clrf	PORTA
	clrf	PORTB
	bsf	STATUS,RP0	;bank1
	movlw	b'11111111'	;
	movwf	TRISA		;port a lines are all inputs
	movlw	b'00000000'
	movwf	TRISB		;port b lines are outputs
	movlw	b'11011111'	;tmr0 clock is internal, prescaler -> wdt
	movwf	OPTION_REG
	bcf	STATUS,RP0	;back to bank0
	;
	movlw	b'00000010'	;AN0 to C1, AN1 to C2, Internal Vref
	movwf	CMCON
	;
	movlw	VREF_HI		;setpoint is vref high
	bsf	STATUS,RP0	;bank1
	movwf	VRCON
	bcf	STATUS,RP0	;back to bank 0
	clrf	FLAG
	;
	movlw	TMR0_RELOAD	;initialize tmr0
	movwf	TMR0
	movlw	b'10100000'	;enable tmr0 interrupt
	movwf	INTCON
	;
loop:	goto $+1		;main program for other functions goes here
	goto	loop
	;
        END

