	list      p=12F629            ; list directive to define processor
	#include <p12F629.inc>        ; processor specific variable definitions
	
	__CONFIG  _CP_OFF & _CPD_OFF & _BODEN_ON & _MCLRE_OFF & _PWRTE_ON & _WDT_ON & _INTRC_OSC_NOCLKOUT  

eeq macro var, val
 movlw	val & 0xFF
 movwf	var
 movlw	val>>8
 movwf	var+1
 endm
eq macro var, val
 movlw	val
 movwf	var
  endm
endloop	macro var, label
	movfw	var	; L and Hi =0
	iorwf	var+1,W
	skpnz
	 goto $+6
	movlw	0x01
	subwf	var,F	; L  or H not zero		
	skpC
	 decf	var+1,F
	goto label
	endm


#include <12F629init.asm>
 cblock Ram0_Start
 PercentOn:2, MaxDim:2; //Global variables
 TestCheck:2, OutCount:2, TestCount:2;
 DelayCnt:2;
 LastBoth:2, FirstPass:2;
 Count:2
 endc

#define Brtbut GPIO,0; //Brighten button
#define Output GPIO,2 ;//Output to TRIAC
#define Dimbut GPIO,3 ;//Dim button
#define Line_Input GPIO,4 ;//AC line zero crossing sense
#define Maxbrt 0xFD
#define NotInTest 3;

	eeq PercentOn, 0xD0; //On Period
	eeq MaxDim , 0x70; //Value of Maximum dimming
	eeq TestCheck , 0; //Test mode check counter
	eeq OutCount , 0; //Counter for test mode exit
	eeq TestCount , 0; //Test mode counter
	eeq DelayCnt , NotInTest; //Delay count
	eeq LastBoth , 0; //Both buttons pressed last time flag
	eeq FirstPass , 1; //Indicate power-up
	eeq Count , 0; //General counter
	
	eeq Count, 60
countloop	btfss	Line_Input
	 goto	$-1
	btfsc	Line_Input
	 goto	$-1
	clrwdt
	endloop	Count, countloop	; 60 cycles high/low

 	movlw	0x85
	OPTION
	movlw	0x1D
	TRIS	GPIO
	eq	GPIO, 0x04
	clrwdt
	btfsc	Line_Input
	 goto $-2
	eq	TMR0, PercentOn
	clrwdt
	btfss	Line_Input
	 goto $-2
mainloop	eq 	Count, 0
adjustloop	incf	Count,F
		







	eq TMR0, PercentOn
	clrwdt
	btfss	Line_Input
	 goto $-2
	eq GPIO, 0x04
	movlw	0x19
	TRIS	GPIO
	NOP; //Delay for TRIAC fire pulse
	NOP;
	NOP;
	NOP;
	NOP;
	NOP;
	NOP;
	movlw 0x1D;
	TRIS	GPIO
	


	eq TMR0, PercentOn
	clrwdt
	btfsc	Line_Input
	 goto $-2
	eq GPIO, 0x04
	movlw	0x19
	TRIS	GPIO
	NOP; //Delay for TRIAC fire pulse
	NOP;
	NOP;
	NOP;
	NOP;
	NOP;
	NOP;
	movlw 0x1D;
	TRIS	GPIO




	END
