;***********************************************************************
;*   This file is the firmware to implement a                          *
;*                                                                     *
;*    binary display of a register as short low (0)                    *
;*                                and long high (1) pulses             *
;*                       while omitting leading zeros                 *
;*                                                                     *
;*   at GPIO 2 Transistor output driver                                *
;*                                                                     *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       G MICHAEL DRYGAS                                   *
;*                                    				       *
;*    Company:    MICHAELS Unternehmergesellschaft (haftungsbeschrnkt)*
;*                 reg DE                                             *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=10F222	; list directive to define processor
	#include  ..\macros3b.asm
	config222
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************


	cblock _MINRAM
	 SystemStatus,TimerVector,TimeCounter:2
	 x	 

	endc

#define	TMR07Bit	SystemStatus,7
#define STACK	_MAXRAM

#define GPIOinit	b'00000110'	; all OUTPUT initiate as HIGH
#define TRISIOinit	b'11111001'	; configure GP1,2 as output 
#define	OPTIONinit	b'11000001'	; no wakup, no pullup, Clock 1:4
#define	ADCON0init	b'01000001'	; gP0 analog, chanel 00,enable
;#define	ADCON0init	b'10000101'	; gP1 analog, chanel 01,enable



black	macro
	movlw	TRISIOinit | b'00000100'	; port 2 input = black
	TRIS	TRISGPIO
	endm
red	macro
	bcf	GPIO,2
	movlw	TRISIOinit & b'11111011'	; port 2 output,LOW = red
	TRIS	TRISGPIO
	endm
blue	macro
	bsf	GPIO,2
	movlw	TRISIOinit & b'11111011'	; port 2 output,HIGH = blue
	TRIS	TRISGPIO
	endm
	

	init206					

afterwdt 
	
MAIN	
	
cycle	black
	settrap206B .6,sec,ADC,TimeCounter,TimerVector


ploop	if_bit	TMR0,7			; software emulation of
	 goto	set7			; timer 0 overflow
	if_not	TMR07Bit		;
	 goto	clred
	bcf	TMR07Bit		; timer 0 has overflown within
	decfsz	TimeCounter,F		;	127 timerticks
	 goto	clred
	decfsz	TimeCounter+1,F
	 goto    clred			
	 
	movfw	TimerVector		; timer trap has sprung
	movwf	PCL			; jump to destination

set7	bsf	TMR07Bit


clred					; timer loop
	goto	ploop			; code max for 127 timerticks


ADC	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1

#define	AL	ADRES

	eq_	x,=,b'10000000', lit8	; bit 7

frstbit	movfw	x			; omit leading zeros
	andwf	AL,W
	bC	strtdis			; its a 1, start display
	rrf	x,F
	skpC				; underflow ?
	 goto	frstbit
	rlf	x,F			; send bit 0 anyway
	
strtdis	movfw	x
	andwf	AL,W
	skpNC	
	 goto	long
	settrap206B .200,msec,pause,TimeCounter,TimerVector
	red
 	goto ploop
long	settrap206B .800,msec,pause,TimeCounter,TimerVector
 	blue
 	goto ploop	

pause	settrap206B .200,msec,rsmedis,TimeCounter,TimerVector
	black
 	goto ploop
 	
rsmedis	rrf	x,F	;	next bit?
	bC	cycle	;	done, wait for next measurement
	goto	strtdis	

	
	

	end