
;Software License Agreement                                         
;                                                                    
                                                                   
;THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  
;WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  
;TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A       
;PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  
;IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         
;CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.       
;************************************************************************

;***********************************************************************
;*   This file is the firmware to implement a 10Hz Signal on all Output*
;*   GPIO Ports                                                        *
;*    File Version: A                                                  *
;*                                                                     *
;*    Author:       G M DRYGAS                                         *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3d2                                       *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
        list      p=12F683        ; list directive to define processor
        #include  m0.asm
        config683              ; reasonable configuration bits

#define OPTIONinit	B'11000100';	; clock 1:32 , WDT 1:1 ,	

#define TRISIOinit b'00111011'    ; all ports input bar GP2       

#define PR2init		.255
#define CCPR1Linit      .17
#define CCP1CONinit	b'00001100'	; enable pwm
#define T2CONinit       b'00000100'	; switch on TMR2

		nointr683

        init683                   ; reasonable initiation of special function registers 

	cblock _MINRAM
	 Sys1, HiCount
	endc

#define	GPis_on		Sys1,0
#define	GPwas_on	Sys1,1

	eq_	HiCount,=,.128,lit8

afterwdt
loop        
	if_m	GPIO,3,is_on,		singlebit

	 if_m	HiCount,>,.128+5,	lit8
	  bsf	GPis_on
	 else_m
	  incf	HiCount,F
	 end_m
	  
	else_m
	  
	 if_m	HiCount,<,.128-5,	lit8
	  bcf	GPis_on
	 else_m
	  decf	HiCount,F
	 end_m

	end_m

	if__ GPis_on,not_but,GPwas_on
	  bcf	GPwas_on

	if__m GPwas_on,not_but,GPis_on
      do_	PR2,=,PR2,-,.64,	lit8
	 bsf	GPwas_on
	end_m 
	delay .60000				; 300msec for successful push button action
        goto loop                                        
        
        end