
;Software License Agreement                                         
;                                                                    
                                                                   
;THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  
;WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  
;TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A       
;PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  
;IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         
;CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.       
;************************************************************************

;***********************************************************************
;*   This file is the firmware to implement a 10Hz Signal on all Output*
;*   GPIO Ports                                                        *
;*    File Version: A                                                  *
;*                                                                     *
;*    Author:       G M DRYGAS                                         *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3d2                                       *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
        list      p=10F200        ; list directive to define processor
        #include  macros3d2.asm
        config200                 ; reasonable configuration bits

#define TRISIOinit b'00001000'    ; all ports output bar GP3        


        init2xx                   ; reasonable initiation of special function registers 
	cblock _MINRAM
	 Sys1, HiCount
	endc
#define	GPis_on	Sys1,0
#define	GPwas_on	Sys1,1

	eq_	HiCount,=,.128,lit8

loop        
	if_m	GPIO,3,is_on,		singlebit
         if_m	HiCount,>,.128+5,	lit8
	  bsf	GPis_on
	  movlw	ilabcount
	  movlw	elabcount
	  movlw	level
	 else_m
	  incf	HiCount,F
	 end_m
	  movlw	ilabcount
	  movlw	elabcount
	  movlw	level
	else_m
	  movlw	ilabcount
	  movlw	elabcount
	  movlw	level

	 if_m	HiCount,<,.128-5,	lit8
	  bcf	GPis_on
	  movlw	ilabcount
	  movlw	elabcount
	  movlw	level
;
	 else_m
	  decf	HiCount,F
	  movlw	ilabcount
	  movlw	elabcount
	  movlw	level
	 end_m
	  movlw	ilabcount
	  movlw	elabcount
	  movlw	level

	end_m
	  movlw	ilabcount
	  movlw	elabcount
	  movlw	level

	if__ GPis_on,not_but,GPwas_on
	  bcf	GPwas_on

	if__m GPwas_on,not_but,GPis_on
         do_        GPIO,=,GPIO,XOR,b'00000111',     (lit8)        ; flip every port bar GP3
	 bsf	GPwas_on
	end_m 
;	
;        delay      .100000                                        ; wait 100 milli seconds
        goto loop                                        
        
        end