
;Software License Agreement                                         
;                                                                    
                                                                   
;THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  
;WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  
;TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A       
;PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  
;IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         
;CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.       
;************************************************************************

;***********************************************************************
;*   This file is the firmware to implement a 1kHz Signal on          *
;*   GPIO2 Port2, increased by each pushbutton action                  *
;*    File Version: A                                                  *
;*                                                                     *
;*    Author:       G M DRYGAS                                         *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   m0.asm (macros)                                *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=10F206				; list directive to define processor
	#include  m0-1.asm
	config206						; reasonable configuration bits

#define TRISIOinit b'00001001'		; all ports  GP1,2 out, GP0,3 input	
#define CMCON0init b'01111011'  	; no COUTpin,not invert,not source
									; ON,int ref,GP0,no wkup 		
	cblock	_MINRAM
     vdel:2,vdif
	endc
	init2xx		  ; reasonable initiation of special function registers 
	eq_		vdif,=,.1,lit8
	vardelay	vdel, .1000
		  
start
loop	

	if_m	CMCON0,7,is_off,singlebit
	 bsf	GPIO,2	
	 bcf	GPIO,1				;
	 delay  .1000					; minimal on time 1msec
	else_m
	 bcf	GPIO,2
	 bsf	GPIO,1			
	 exec_vardelay 	vdel			; minimal off time 10msec
	 do_	vdel,=,vdel,+,vdif,byte
	 if_m	STATUS,C,is_on,singlebit
	  incfsz vdif,F
	   incf	 vdif,F
	  decf	 vdif,F
	  incf	vdel+1,F	
	 end_m 
	 if_	vdel,==,0x0101,lit16
	  goto	$						; loop forever (stay off)
	end_m	
	

	goto loop					
	
	end