;************************************************************************
;      macros
; 
;
;	addC			add carry to var
;	add	c,a,b		addition		c=a+b
;	addd			addition 2bytes
;
;	decC	a	         decrement Carry	if C then a:=a-1
;
;	dec	a,b	decrement variable	a:=a-b
;	decc
;	deccc
;	decccc
;	
;	decl	a,k		decrement a by literal k
;	decll						a:=a-k
;
;       eeeeq   var, val   load 4 bytes with literal val (LSB,..MSB)       
;	eeeq
;	eeq
;	eq
;	
;	inc	var1, var2	increment variable	a=a+b
;	incc
;	inccc
;	incccc
;
;	incl	a,k		increment a by literal k
;	incll						a=a+k
;	inclll

; 
;	neeeq 	var, val   load 3 bytes with 2s complement of val

;	sub	Difference, SubtrahEnd, SubtracTor  -- c = a-b
;	subb    2byte subtraction
;
;	shl
;	shll			multiply 4
;	shlll			multiply 8
;	
;	shml	a,n,i		multiply a with 2^n using i
;	shmll
;
;	shmr	a,n,i
;
;	skplev	a,b		skip next instruction if a <= b
;	skpgrv	a,b   					 a > b
;	skpgev	a,b					 a >= b
;	skpeqv	a,b					 a = b
;	skpnev	a,b					 a <> b
;


;skpgel	     literal

;	SWAPWF	a		swap W with variable 	a=W , W=a
;	swapreg	a,b		swap variable a and b using W


clrff	macro	var
		clrf	var
		clrf	var+1
	endm	
clrfff	macro	var
		clrf	var
		clrf	var+1
		clrf	var+2
	endm	

clrffff	macro	var
		clrf	var
		clrf	var+1
		clrf	var+2
		clrf	var+3
	endm
	


neq 	    macro var, val
		if (val & 0xFF) == 0xFF
		clrf	var
		else
 		movlw	0xFF - (val & 0xFF)
 		movwf	var
		endif
	endm


neqq 	    macro var, val
		if (val & 0xFF) == 0xFF
		clrf	var
		else
 		movlw	0xFF - (val & 0xFF)
 		movwf	var
		endif
		if ((val>>.8) & 0xFF) == 0xFF
		clrf	var+1
		else
		movlw	0xFF - ((val>>.8) & 0xFF)
 		movwf	var+1
		endif
	    endm

neqqq	    macro var, val
		neqq var, val
		if ((val>>.16) & 0xFF) == 0xFF
		clrf	var+2
		else
		movlw	0xFF - ((val>>.16) & 0xFF)
 		movwf	var+2
		endif
	    endm



neqqqq 	    macro var, val
		neqqq var,val

		if ((val>>.24) & 0xFF) == 0xFF
		clrf	var+3
		else
		movlw	0xFF - ((val>>.24) & 0xFF)
 		movwf	var+3

		endif
 	    endm

eeeeq 	    macro var, val
	if val & 0xFF
 		movlw	val & 0xFF
 		movwf	var
		else
		clrf	var
		endif
		if (val>>.8) & 0xFF
		movlw	(val>>.8) & 0xFF
 		movwf	var+1
		else
		clrf	var+1
		endif
		if	(val>>.16) & 0xFF
		movlw	(val>>.16) & 0xFF
		movwf	var+2
		else
		clrf	var+2
		endif
		if	val>>.24
		movlw	val>>.24
		movwf	var+3
		else
		clrf	var+3
		endif
		
 	    endm

eeeq 	    macro var, val
 		if val & 0xFF
 		movlw	val & 0xFF
 		movwf	var
		else
		clrf	var
		endif
		if (val>>.8) & 0xFF
		movlw	(val>>.8) & 0xFF
 		movwf	var+1
		else
		clrf	var+1
		endif
		if	val>>.16
		movlw	val>>.16
		movwf	var+2
		else
		clrf	var+2
		endif
		
 	    endm

eeq 	    macro var, val
		if val & 0xFF
 		movlw	val & 0xFF
 		movwf	var
		else
		clrf	var
		endif
		if	val>>8
 		movlw	val>>8
 		movwf	var+1
		else
		clrf	var+1
		endif
 	    endm
eq 	    macro var, val
		if val
 		movlw	val
 		movwf	var
		else
		clrf	var
		endif
  	    endm

sub	macro	Diff, SubEnd, SubTor
		movfw	SubTor
		subwf	SubEnd,W
		movwf	Diff
	
	endm

subb	macro	Diff, SubEnd, SubTor
		movfw	SubTor
		subwf	SubEnd,W
		movwf	Diff
		
		movfw	SubTor+1
		skpC	
		 incfsz	SubTor+1,W
		subwf	SubEnd+1,W
		movwf	Diff+1
	endm

subbb	macro	Diff, SubEnd, SubTor
		subb	Diff,SubEnd,SubTor
		movfw	SubTor+2
		skpC	
		 incfsz	SubTor+2,W
		subwf	SubEnd+2,W
		movwf	Diff+2
	endm

subbbb	macro	Diff, SubEnd, SubTor
		subbb	Diff,SubEnd,SubTor
		movfw	SubTor+3
		skpC	
		 incfsz	SubTor+3,W
		subwf	SubEnd+3,W
		movwf	Diff+3
	endm




decC	    macro	Target
		skpC
		 decf	Target,F
	    endm

addv	    macro result, var1, var2
		movfw	var1
		addwf	var2,W
		movwf	result
	    endm

addvv	    macro result, var1, var2
		movfw	var1
		addwf	var2,W
		movwf	result
		movfw	var1+1
		skpnC
		 incfsz	var1+1,W
		addwf	var2+1,W
		movwf	result+1
	    endm

addvvv	    macro result, var1, var2
		addvv result, var1, var2
	
		movfw	var1+2
		skpnC
		 incfsz	var1+2,W
		addwf	var2+2,W
		movwf	result+2
	    endm

addvvvv	    macro result, var1, var2
		addvvv result, var1, var2
	
		movfw	var1+3
		skpnC
		 incfsz	var1+3,W
		addwf	var2+3,W
		movwf	result+3
	    endm



addC	    macro	Target
		skpnC
		 incf	Target,F
	    endm

inc	    macro result, var1
		movfw	var1
		addwf	result,F
	    endm
incc	    macro result, var1
		movfw	var1
		addwf	result,F
		movfw	var1+1
		skpnC
		 incfsz	var1+1,W
		addwf	result+1,F
	    endm
inccc	    macro result, var1
		movfw	var1
		addwf	result,F
		movfw	var1+1
		skpnC
		 incfsz	var1+1,W
		addwf	result+1,F
		movfw	var1+2
		skpnC
		 incfsz	var1+2,W
		addwf	result+2,F
	    endm
incccc	    macro result, var1
		movfw	var1
		addwf	result,F
		movfw	var1+1
		skpnC
		 incfsz	var1+1,W
		addwf	result+1,F
		movfw	var1+2
		skpnC
		 incfsz	var1+2,W
		addwf	result+2,F
		movfw	var1+3
		skpnC
		 incfsz	var1+3,W
		addwf	result+3,F
	    endm

dec	    macro result, var1
		movfw	var1
		subwf	result,F
	    endm
decc	    macro result, var1
		movfw	var1
		subwf	result,F
		movfw	var1+1
		skpC
		 incfsz	var1+1,W	;overflow
		subwf	result+1,F
	    endm			;overflow on NC

deccc	    macro result, var1
		movfw	var1
		subwf	result,F
		movfw	var1+1
		skpC
		 incfsz	var1+1,W	;overflow
		subwf	result+1,F
		movfw	var1+2
		skpC
		 incfsz	var1+2,W
		subwf	result+2,F
	    endm			;overflow on NC
decccc	    macro result, var1
		deccc	    macro result, var1
		movfw	var1+3
		skpC
		 incfsz	var1+3,W
		subwf	result+3,F
	   endm



incl	    macro result, val
		movlw	val
		addwf	result,F
	    endm

incll	    macro	var1, val
	    local	c0,c8,c8e
		goto c0

c8		if ((val >>.8)+1) & 0xFF
		 movlw 	((val >>.8)+1) & 0xFF
		 addwf	var1+1
		endif
		goto c8e

c0		movlw	val & 0xFF
		addwf	var1,F
		skpNC
		 goto c8
		if	(val >>.8) & 0xFF
		  movlw	(val >>.8) & 0xFF
		  addwf	var1+1,F
		endif
c8e
	endm


		
inclll	macro 	var1, val
		local	c0,c8,c8e,c16,c16e
		goto c0

c8		if ((val >>.8)+1) & 0xFF
		 movlw 	((val >>.8)+1) & 0xFF
		 addwf	var1+1
		endif
		goto c8e

c16		if ((val >>.16)+1) & 0xFF
		 movlw 	((val >>.8)+1) & 0xFF
		 addwf	var1+1
		endif
		goto c16e


		
		;
c0		movlw	val & 0xFF
		addwf	var1,F

	
		skpNC
		 goto c8
		if	(val >>.8) & 0xFF
		  movlw	(val >>.8) & 0xFF
		  addwf	var1+1,F
		endif

c8e		skpNC
		 goto c16
		if	(val >>.16) & 0xFF
		  movlw	(val >>.16) & 0xFF
		  addwf	var1+1,F
		endif
c16e
		endm	
incllll	    macro 	var1, val
		inclll var1, val

		movlw	((val >>.24) & 0xFF)
		skpC
		 goto	$+2
		if ((val >>.24)+1) & 0xFF
		  movlw	((val >>.24)+1) & 0xFF
		else
		  goto $+2
		endif
		addwf	var1+3,F
	    endm		
	

decl	    macro result, val
		incl	result, -val
	    endm

decll	    macro	var1, val
	 	incll	var1, -val
	    endm		
declll	    macro	var1, val
		inclll	var1, -val
	    endm	
decllll	    macro	var1, val
		incllll var1, -val
	    endm		

swapwf      MACRO  REG
            	XORWF  REG,F
        	XORWF  REG,W
        	XORWF  REG,F
            ENDM
swapv macro	var1,var2
		movfw	var1
		xorwf	var2,F
		xorwf	var2,w
		xorwf	var2,F
		movwf	var1
	endm

shml	macro	Target, shifts, Counter
		movlw	shifts
		movwf	Counter
		clrC
		rlf	Target,F
		decfsz	Counter,F
		 goto	$-3

shmll	macro	Target, shifts, Counter
		movlw	shifts
		movwf	Counter
		clrC
		rlf	Target,F
		rlf	Target+1,F
		decfsz	Counter,F
		 goto	$-4

shmlll	macro	Target, shifts, Counter
		movlw	shifts
		movwf	Counter
		clrC
		rlf	Target,F
		rlf	Target+1,F
		rlf	Target+2,F
		decfsz	Counter,F
		 goto	$-5

shmllll	macro	Target, shifts, Counter
		movlw	shifts
		movwf	Counter
		clrC
		rlf	Target,F
		rlf	Target+1,F
		rlf	Target+2,F
		rlf	Target+3,F
		decfsz	Counter,F
		 goto	$-6

pwrof2 macro	Target, shifts,Counter
	  shml	 Target, shifts,Counter
	endm

shmr	macro	Target, shifts, Counter
		movlw	shifts
		movwf	Counter
		clrC
		rrf	Target,F
		decfsz	Counter,F
		 goto	$-3
	endm



shmrr	macro	Target, shifts, Counter
		movlw	shifts
		movwf	Counter
		clrC
		rrf	Target+1,F
		rrf	Target,F
		decfsz	Counter,F
		 goto	$-4
	endm


	
shmrrr	macro	Target, shifts, Counter
		movlw	shifts
		movwf	Counter
		clrC
		rrf	Target+2,F
		rrf	Target+1,F
		rrf	Target,F
		decfsz	Counter,F
		 goto	$-5
	endm

shr	macro	Target
		clrC
		rrf	Target,F
	endm
shrr	macro	Target
		clrC
		rrf	Target+1,F
		rrf	Target,F
	endm


shrrr	macro	Target
		clrC
		rrf	Target+2,F
		rrf	Target+1,F
		rrf	Target,F
	endm

divby2  macro   Target
 	 	shr 	Target
	endm

shl	macro	Target
		clrC
		rlf	Target,F
	endm

mult2	macro   Target
 	 	shl 	Target
	endm

shll	macro	Target
		clrC
		rlf	Target,F
		rlf	Target+1,F
	endm

shlll	macro	Target
		clrC
		rlf	Target,F
		rlf	Target+1,F
		rlf	Target+2,F
	
	endm

shllll	macro	Target
		clrC
		rlf	Target,F
		rlf	Target+1,F
		rlf	Target+2,F
		rlf	Target+3,F

	endm


skpge	    macro var1, var2	;skip next instr if var1 greater equal var2
		movfw	var2
		subwf	var1,W
		skpC
	    endm

exels	    macro var1, var2	;execute next instr if var1 less var2
             	skpge var1,var2
	    endm


skpgev	    macro var1, var2	;skip next instr if var1 greater equal var2
		movfw	var2
		subwf	var1,W
		skpC
	    endm

skpgevv	    macro var1, var2	;skip next instr if var1 greater equal var2 (16bit LSB-MSB)
		movfw	var2+1
		subwf	var1+1,w
		skpZ
		 goto $+3
		movfw	var2
		subwf	var1,w
		skpC
;		 conditional code
	    endm
skpgevvv    macro var1, var2	;skip next instr if var1 greater equal var2 (24bit LSB,..,MSB)
		movfw	var2+2
		subwf	var1+2,w
		skpZ
		 goto $+7
		movfw	var2+1
		subwf	var1+1,w
		skpZ
		 goto $+3
		movfw	var2
		subwf	var1,w
		skpC
;		 conditional code
	    endm
skpgevvvv    macro var1, var2	;skip next instr if var1 greater equal var2 (32bit LSB,..,MSB)
		movfw	var2+3
		subwf	var1+3,w
		skpZ
		 goto $+11
		movfw	var2+2
		subwf	var1+2,w
		skpZ
		 goto $+7
		movfw	var2+1
		subwf	var1+1,w
		skpZ
		 goto $+3
		movfw	var2
		subwf	var1,w
		skpC
;		 conditional code
	    endm
exelsv	    macro var1, var2
		skpgev	var1,var2
	    endm
exelsvv	    macro var1, var2
		skpgevv	var1,var2
	    endm
exelsvvv    macro var1, var2
		skpgevvv	var1,var2
	    endm
exelsvvvv    macro var1, var2
		skpgevvv	var1,var2
	    endm


skple	    macro var1,var2
	     skpge var2,var1
	    endm	
skplev	    macro var1,var2
	     skpgev var2,var1
	    endm	
skplevv	    macro var1,var2
	     skpgevv var2,var1
	    endm	
skplevvv	    macro var1,var2
	     skpgevvv var2,var1
	    endm	

exegr	    macro var1,var2
		skple	var1,var2
	    endm
exegrv	    macro var1, var2
		skplev	var1,var2
	    endm
exegrvv	    macro var1, var2
		skplevv	var1,var2
	    endm
exegrvvv    macro var1, var2
		skplevvv	var1,var2
	    endm
exegrvvvv    macro var1, var2
		skplevvvv	var1,var2
	    endm


skpgr	    macro var1, var2
		movfw	var1
		subwf	var2,W
		skpNC
	    endm

skpgrv	    macro var1,var2	;skip next instr if var1 greater  var2
		movfw	var1
		subwf	var2,W
		skpNC
	    endm

skpgrvv	    macro var2, var1	;skip next instr if var1 greater  var2 (16bit LSB-MSB)
		movfw	var2+1
		subwf	var1+1,w
		skpZ
		 goto $+3
		movfw	var2
		subwf	var1,w
		skpNC
;		 conditional code
	    endm
skpgrvvv    macro var2, var1	;skip next instr if var1 greater var2 (24bit LSB,..,MSB)
		movfw	var2+2
		subwf	var1+2,w
		skpZ
		 goto $+7
		movfw	var2+1
		subwf	var1+1,w
		skpZ
		 goto $+3
		movfw	var2
		subwf	var1,w
		skpNC
;		 conditional code
	    endm
skpgrvvvv    macro var2, var1	;skip next instr if var1 greater  var2 (32bit LSB,..,MSB)
		movfw	var2+3
		subwf	var1+3,w
		skpZ
		 goto $+11
		movfw	var2+2
		subwf	var1+2,w
		skpZ
		 goto $+7
		movfw	var2+1
		subwf	var1+1,w
		skpZ
		 goto $+3
		movfw	var2
		subwf	var1,w
		skpNC
;		 conditional code
	    endm




exele	    macro var1,var2
		skpgr	var1,var2
	    endm
exelev	    macro var1,var2
		skpgrv	var1,var2
	    endm
exelevv	    macro var1,var2
		skpgrvv	var1,var2
	    endm
exelevvv	    macro var1,var2
		skpgrvvv	var1,var2
	    endm

exege	    macro var1,var2
		skpgr	var2,var1
	    endm
exegev	    macro var1,var2
		skpgrv	var2,var1
	    endm
exegevv	    macro var1,var2
		skpgrvv	var2,var1
	    endm
exegevvv	    macro var1,var2
		skpgrvvv	var2,var1
	    endm

exegevvvv	    macro var1,var2
		skpgrvvvv	var2,var1
	    endm






skpeq	    macro var1, var2
		movfw	var1
		subwf	var2,W
		skpZ
	    endm

skpeqq	    macro var1, var2
		movfw	var1+1
		subwf	var2+1,W
		skpZ
		 goto $+4
		movfw	var1
		subwf	var2,W
		skpZ

	    endm
skpeqqq	    macro var1, var2
		movfw	var1+2
		subwf	var2+2,W
		skpZ
		 goto $+8
		movfw	var1+1
		subwf	var2+1,W
		skpZ
		 goto $+4
		movfw	var1
		subwf	var2,W
		skpZ

	    endm
exeneq      macro var1, var2	;execute next instr if var1 not equal var2
             	skpeq var1,var2
	    endm
exeneqq     macro var1, var2	;execute next instr if var1 not equal var2  (16bit)
             	skpeqq var1,var2
	    endm

exeneqqq    macro var1, var2	;execute next instr if var1 not equal var2 (24bit)
             	skpeqqq var1,var2
	    endm


skpneq	    macro var1, var2
		movfw	var1
		subwf	var2,W
		skpNZ
	    endm
skpneqq	    macro var1, var2
		movfw	var1+1
		subwf	var2+1,W
		skpNZ
		 goto $+4
		movfw	var1
		subwf	var2,W
		skpNZ

	    endm
skpneqqq	    macro var1, var2
		movfw	var1+2
		subwf	var2+2,W
		skpNZ
		 goto $+8
		movfw	var1+1
		subwf	var2+1,W
		skpNZ
		 goto $+4
		movfw	var1
		subwf	var2,W
		skpNZ

	    endm
exeeq      macro var1, var2	;execute next instr if var1 equal var2
             	skpneq var1,var2
	    endm
exeeqq     macro var1, var2	;execute next instr if var1 equal var2  (16bit)
             	skpneqq var1,var2
	    endm

exeeqqq    macro var1, var2	;execute next instr if var1 equal var2 (24bit)
             	skpneqqq var1,var2
	    endm

skpeql	    macro var1, val	;skip var1  equal literal
		movlw	val
		subwf	var1,W
		skpz
	    endm
	    

skpeqll    macro var1, val      ;skip var1  equal literal 16bit
		movfw	val >> .8
		subwf	var1+1,W
		skpZ
		 goto $+4
		movfw	val & 0xFF
		subwf	var2,W
		skpZ

	    endm
skpeqlll	    macro var1, val
		movfw	val >>.16
		subwf	var1+2,W
		skpZ
		 goto $+8
		movfw	(val>>.8) & 0xFF
		subwf	var2+1,W
		skpZ
		 goto $+4
		movfw	val & 0xFF
		subwf	var2,W
		skpZ

	    endm

exeneql      macro var1, val	;execute next instr if var1 not equal val
             	skpeql var1,val
	    endm
exeneqll     macro var1, val	;execute next instr if var1 not equal val  (16bit)
             	skpeqll var1,val
	    endm

exenelll    macro var1, val	;execute next instr if var1 not equal val (24bit)
             	skpeqlll var1,val
	    endm


skpneql	    macro var1, val		;skip var1  not equal literal
		movlw	val
		subwf	var1,W
		skpnz
	    endm
exeeql      macro var1, val	;execute next instr if var1 equal val
             	skpneql var1,val
	    endm
exeeqll     macro var1, val	;execute next instr if var1 equal val  (16bit)
             	skpneqll var1,val
	    endm

exeelll    macro var1, val	;execute next instr if var1 equal val (24bit)
             	skpneqlll var1,val
	    endm

skpgel	    macro var1, val		;skip var1 greater equal literal
		movlw	val
		subwf	var1,W
		skpC
	    endm

skpgell	    macro var1, val		;skip var1 greater equal literal 16bit
		movlw	val >> .8
		subwf	var1+1,w
		skpZ
		 goto $+3
		movlw	val & 0xFF	; +1 is equal
		subwf	var1,w
		skpC
;		 conditional code

	    endm

skpgelll    macro var1, val		;skip var1 greater equal literal 24bit
		movlw	(val >> .16)  & 0xFF
		subwf	var1+2,w
		skpZ
		 goto $+7
		movlw	(val >> .8) & 0xFF
		subwf	var1+1,w
		skpZ
		 goto $+3
		movlw	val & 0xFF	; 
		subwf	var1,w
		skpC
;		 conditional code
	endm
skpgellll    macro var1, val		;skip var1 greater equal literal 32bit
		movlw	(val >> .24) & 0xFF
		subwf	var1+2,w
		skpZ
		 goto $+11

		movlw	(val >> .16) & 0xFF
		subwf	var1+2,w
		skpZ
		 goto $+7
		movlw	(val >> .8) & 0xFF
		subwf	var1+1,w
		skpZ
		 goto $+3
		movlw	val & 0xFF	; 
		subwf	var1,w
		skpC
;		 conditional code
	endm

exelsl     macro var1, val	;execute var1 less  literal 
		skpgel var1,val
	   endm

exelsll     macro var1, val	;execute var1 less  literal 
		skpgell var1,val
	   endm
exelslll   macro var1, val	;execute var1 less  literal 
		skpgelll var1,val
	   endm

skpgrl	   macro var1,val
		skpgel var1, val+1
	   endm

skpgrll	   macro var1,val
		skpgell var1, val+1
	   endm
skpgrlll	   macro var1,val
		skpgelll var1, val+1
	   endm
skpgrllll	   macro var1,val
		skpgellll var1, val+1
	   endm


exelel     macro var1, val	;execute var1 less  literal 
		skpgel var1,val+1
	   endm

exelell     macro var1, val	;execute var1 less  literal 
		skpgell var1,val+1
	   endm
exelelll   macro var1, val	;execute var1 less  literal 
		skpgelll var1,val+1
	   endm


skplsl	    macro var1, val	;skip var1 less  literal
		movlw	val
		subwf	var1,W
		skpNC
	    endm
skplsll	    macro var1, val		;skip var1 less literal 16bit
		movlw	val >> .8
		subwf	var1+1,w
		skpZ
		 goto $+3
		movlw	val & 0xFF	; +1 is equal
		subwf	var1,w
		skpNC
;		 conditional code

	    endm

skplslll    macro var1, val		;skip var1 less literal 24bit
		movlw	val >> .16
		subwf	var1+2,w
		skpZ
		 goto $+7
		movlw	val >> .8
		subwf	var1+1,w
		skpZ
		 goto $+3
		movlw	val & 0xFF	; 
		subwf	var1,w
		skpNC
;		 conditional code
	endm

skplsllll    macro var1, val		;skip var1 less literal 32bit
		movlw	(val >> .24) & 0xFF
		subwf	var1+3,w
		skpZ
		 goto $+11
		movlw	(val >> .16) & 0xFF
		subwf	var1+2,w
		skpZ
		 goto $+7
		movlw	(val >> .8)& 0xFF
		subwf	var1+1,w
		skpZ
		 goto $+3
		movlw	val & 0xFF	; 
		subwf	var1,w
		skpNC
;		 conditional code
	endm

exegel	    macro var1, val
		skplsl var1, val
	    endm
exegell	    macro var1,val
		skplsll var1,val
	    endm
exegelll    macro
		skplslll var1,val
	    endm
exegellll    macro
		skplsllll var1,val
	    endm


skplel	    macro var1, val	;skip var1 less equal literal
                skplsl var1, val-1
	    endm

skplell	    macro var1, val		;skip var1 less literal 16bit
	        skplsll var1, val-1
	    endm

skplelll    macro var1, val		;skip var1 less literal 24bit
		skplslll var1, val-1
            endm

#define		grtr	1
#define		grtr_eql	2
#define		lss	3
#define		lss_eql	4
#define		eql	5
#define		not_eql	6


if_	    macro var1,oprtr,var2,bits
		if (oprtr == grtr) & (bits == 8)
		 exegrv	var1,var2
	    	endif
		if (oprtr == grtr) & (bits == 16)
		 exegrvv	var1,var2
	    	endif
		if (oprtr == grtr) & (bits == 24)
		 exegrvvv	var1,var2
	    	endif	
		if (oprtr == grtr) & (bits == 32)
		 exegrvvvv	var1,var2
	    	endif
		
		if (oprtr == grtr) & (bits == -8)
		 exegel	var1,var2+1
	    	endif
		if (oprtr == grtr) & (bits == -16)
		 exegell	var1,var2+1
	    	endif
		if (oprtr == grtr) & (bits == -24)
		 exegelll	var1,var2+1
	    	endif	
		if (oprtr == grtr) & (bits == -32)
		 exegellll	var1,var2+1
	    	endif



	if (oprtr == grtr_eql) & (bits == 8)
		 exegev	var1,var2
	    	endif
		if (oprtr == grtr_eql) & (bits == 16)
		 exegevv	var1,var2
	    	endif
		if (oprtr == grtr_eql) & (bits == 24)
		 exegevvv	var1,var2
	    	endif	
		if (oprtr == grtr_eql) & (bits == 32)
		 exegevvvv	var1,var2
	    	endif
		
		if (oprtr == grtr_eql) & (bits == -8)
		 exegel	var1,var2
	    	endif
		if (oprtr == grtr_eql) & (bits == -16)
		 exegell	var1,var2
	    	endif
		if (oprtr == grtr_eql) & (bits == -24)
		 exegelll	var1,var2
	    	endif	
		if (oprtr == grtr_eql) & (bits == -32)
		 exegellll	var1,var2
	    	endif

	if (oprtr == lss) & (bits == 8)
		 exelsv	var1,var2
	    	endif
		if (oprtr == lss) & (bits == 16)
		 exelsvv	var1,var2
	    	endif
		if (oprtr == lss) & (bits == 24)
		 exelsvvv	var1,var2
	    	endif	
		if (oprtr == lss) & (bits == 32)
		 exelsvvvv	var1,var2
	    	endif
		
		if (oprtr == lss) & (bits == -8)
		 exegel	var1,var2+1
	    	endif
		if (oprtr == lss) & (bits == -16)
		 exegell	var1,var2+1
	    	endif
		if (oprtr == lss) & (bits == -24)
		 exegelll	var1,var2+1
	    	endif	
		if (oprtr == lss) & (bits == -32)
		 exegellll	var1,var2+1
	    	endif



	if (oprtr == lss_eql) & (bits == 8)
		 exegev	var1,var2
	    	endif
		if (oprtr == lss_eql) & (bits == 16)
		 exegevv	var1,var2
	    	endif
		if (oprtr == lss_eql) & (bits == 24)
		 exegevvv	var1,var2
	    	endif	
		if (oprtr == lss_eql) & (bits == 32)
		 exegevvvv	var1,var2
	    	endif
		
		if (oprtr == lss_eql) & (bits == -8)
		 exegel	var1,var2
	    	endif
		if (oprtr == lss_eql) & (bits == -16)
		 exegell	var1,var2
	    	endif
		if (oprtr == lss_eql) & (bits == -24)
		 exegelll	var1,var2
	    	endif	
		if (oprtr == lss_eql) & (bits == -32)
		 exegellll	var1,var2
	    	endif



	    endm



;****************************************** now legal macros **********************



skp_ornot   macro	base1, bit1, base2, bit2;bit1	bit2 result
		btfss	base1, bit1		; 1      0     skp
		 btfss	base2, bit2		; 1      1     skp
		goto	$+2			; 0      0     skp
				;       	; 0      1     
				; execute not(bit1) and  bit2
	    endm
exe_but    macro base1, bit1, base2, bit2
		skp_ornot base1, bit1, base2, bit2
	   endm

skp_fault	macro	base1, bit1, base2, bit2	;bit1	bit2 result
		btfsc	base1, bit1		; 1      0     skp
		 btfss	base2, bit2		; 1      1
		goto	$+2			; 0      0     skp
				;       	; 0      1     skp
				; execute (bit1) and (bit2)
	endm
exe_both    macro base1, bit1, base2, bit2
		skp_fault base1, bit1, base2, bit2
	   endm


skp_any	macro	base1, bit1, base2, bit2	;base1, bit1	bit2 result
		btfss	base1, bit1		; 1      0   skp
		 btfsc	base2, bit2		; 1      1   skp	
		goto	$+2			; 0      0 
						; 0      1   skp
				;exeute not (bit1 or bit 2)
	endm
exe_none    macro base1, bit1, base2, bit2
		skp_any base1, bit1, base2, bit2
	   endm





;execaornotb
skp_but macro	base1, bit1, base2, bit2	;bit1	bit2 result
		btfss	base1, bit1		; 1      0     
		  				; 1      1     
		 btfss	base2, bit2		; 0      0     
		      				; 0      1     skp
				;
				; execute bit1 or not(bit2)
	endm
exe_ornot    macro base1, bit1, base2, bit2
		skp_but base1, bit1, base2, bit2
	   endm




;execaorb
skp_none	macro	base1, bit1, base2, bit2;bit1	bit2 result
		btfss	base1, bit1		; 1      0     
		 btfsc	base2, bit2		; 1      1     
						; 0      0     skp
				;       	; 0      1     
				; execute not(bit1) and  not(bit2)
	endm
exe_any    macro base1, bit1, base2, bit2
		skp_none base1, bit1, base2, bit2
	   endm
	
			
;execnandb
skp_both macro	base1, bit1, base2, bit2	;bit1	bit2 result
		btfsc	base1, bit1		; 1      0     
		     				; 1      1     skp     
		 btfss	base2, bit2		; 0      0     
		 				; 0      1     
				;
				;execute bit1 or bit2
	endm
exe_fault    macro base1, bit1, base2, bit2
		skp_both base1, bit1, base2, bit2
	   endm


;execxorb 
skp_equal macro	base1, bit1, base2, bit2	;bit1	bit2 result
		btfss	base1, bit1		; 1      0     
		 goto  	$+4			; 1      1    skp
		btfss	base2, bit2		; 0      0    skp
		 goto   $+3			; 0      1    
		goto	$+3
		btfsc   base2, bit2
					;execute    bit1 xor bit2
	endm

exe_either    macro base1, bit1, base2, bit2
		skp_equal base1, bit1, base2, bit2
	   endm


;execeqb 
skp_either macro	base1, bit1, base2, bit2	;bit1	bit2 result
		btfss	base1, bit1		; 1      0    skp 
		 goto  	$+4			; 1      1    
		btfsc	base2, bit2		; 0      0    
		 goto   $+3			; 0      1    skp
		goto	$+3
		btfss   base2, bit2
					;
				;execute    bit1 eq bit2
	endm
exe_equal    macro base1, bit1, base2, bit2
		skp_either base1, bit1, base2, bit2
	   endm


movbit	macro Source,Sbit, Target, Tbit
		btfss	Source,Sbit
		 bcf	Target,Tbit
                btfsc Source,Sbit
		 bsf	Target,Tbit
	endm
invbit	macro  Target, Tbit
	 movlw	1 << Tbit
	 xorwf	Target,F
	endm


;************************************************************* 

movEEAdl	macro	data1	
		
		movlw	data1
		banksel	EEADR	
		movwf	EEADR
	endm	
movEEDtl	macro	data1	

		movlw	data1
		banksel	EEDAT	
		movwf	EEDAT
	endm


movEEDt	macro	data1	
		banksel	data1
		movfw	data1
		banksel	EEDAT	
		movwf	EEDAT
	endm

movEEAD	macro	adr, data1
		banksel	adr
		movfw	adr
		banksel	EEADR	
		movwf	EEADR
		banksel	data1
		movfw	data1
		banksel	EEDAT	
		movwf	EEDAT
	endm
readEE	macro	adrl,var

		banksel	EEADR
		movlw	adrl
		movwf	EEADR
		bsf	EECON1,RD
		movfw	EEDAT
		banksel	var
		movwf	var
	endm


wrtEE	macro
		BSF	EECON1,WREN		; Bank1 is selected after MovEE macros
	;	banksel 0
	;	BCF	INTCON,GIE		;if fworking with interrupts
	;	BTFSC	INTCON,GIE
	;	 GOTO	$-2
	;	banksel 1
		MOVLW	55h
		MOVWF	EECON2
		MOVLW	0xAA
		MOVWF	EECON2
		BSF	EECON1,WR
		btfsc   EECON1,WR		;  write finished?
		 goto 	$-1

		bcf 	EECON1,WREN		;
	;	banksel	INTCON			; eneble interrupts
	;	BSF	INTCON,GIE
	endm	
	;return
	



mov	macro Source, Target
		movfw	Source
		movwf	Target
	endm

movv	macro Source, Target
		movfw	Source
		movwf	Target
		movfw	Source+1
		movwf	Target+1
	endm
movvv	macro Source, Target
		movfw	Source
		movwf	Target
		movfw	Source+1
		movwf	Target+1
		movfw	Source+2
		movwf	Target+2
	endm

endloop	    macro var, label
		movfw	var	; L and Hi =0
		iorwf	var+1,W
		skpnz
	 	 goto $+6
		movlw	0x01
		subwf	var,F	; L  or H not zero		
		skpC		; borrow
	 	 decf	var+1,F
		goto label	; e.g. 		 eeq count,600
	    endm		;      labl	 nop
				;		 endloop count, labl




div8by8mod     macro  DiviDend, DiviSor, DiviTemp ;:4
		;movlw	.10
		;movwf	DiviSor
		exele	Divsor,.1		
		 goto	exit		; minimal divison 255 div 2 = 127 /1

		clrf	DiviTemp+3	;result
		eq 	DiviTemp+2, B'10000000'		; adding bit
		mov	DiviSor, DiviTemp
		clrf	DiviTemp+1
		mshrr	DiviTemp,2	; 
nextbit		shr	DiviTemp+2	; adding bit /2
		movf	DiviTemp,F
		bC	rrTemp
		movfw	DiviTemp+1
		subwf	DiviDend,W
		skpC
		 goto	rrTemp
		movwf	DiviDend	;success
		inc	DiviTemp+3,DiviTemp+2	; increment result by adding bit

rrTemp	        
		shrr	DiviTemp,F    ; divisor /2
		btfss	DiviTemp+2,1
finish         mov	DiviTemp+3, DiviDend
		mov	DiviTemp+2, DiviSor		;decimal result in DiviDend(div), DiviSor (mod)	
exit	    
	    endm


div8by8frac     macro  DiviDend, DiviSor, DiviTemp ;:5
	
		exelev	Divsor,.1		
		 goto	exit		; minimal divison 255 div 2 = 127 /1

		clrff	DiviTemp+4		;result
		eeq 	DiviTemp+2, 0x0100	; adding bit
		mov	DiviSor, DiviTemp	;shifted divisor
		clrf	DiviTemp+1
moreshift	btfsc	DiviTemp,7		; Divisor shifted to left?
		 goto	nextbit
		shl	DiviTemp		; Divisor>>
		rlf	DiviTemp+2		; adding bit>>
		goto	moreshift
nextbit		
		exelsvv	DiviDend, DiviTemp
		 goto	rrTemp
		decc	DiviDend,Dividend	;success
		incc	DiviTemp+4,DiviTemp+2	; increment result by adding bit

rrTemp	        shrr	DiviTemp+2	; adding bit /2
		shrr	DiviTemp   	; divisor /2
		btfss	DiviTemp+3,1
		 goto	nextbit

finish         	mov	DiviTemp+4, DiviDend
		mov	DiviTemp+5, DiviSor		;decimal result in DiviDend(div), DiviSor (mod)	
exit	    
	    endm


div16by16mod     macro  DiviDend, DiviSor, DiviTemp ;2:2:5
	
		exelevv	Divsor,.1		
		 goto	exit		; minimal divison 255 div 2 = 127 /1

		clrff	DiviTemp+4		;result
		eeq 	DiviTemp+2, 0x0001	; adding bit
		movv	DiviSor, DiviTemp	;shifted divisor
		
moreshift	btfsc	DiviTemp,7		; Divisor shifted to left?
		 goto	nextbit
		shll	DiviTemp		; Divisor>>
		shll	DiviTemp+2		; adding bit>>
		goto	moreshift
nextbit		
		exelsvv	DiviDend, DiviTemp
		 goto	rrTemp
		decc	DiviDend,Dividend	;success
		incc	DiviTemp+4,DiviTemp+2	; increment result by adding bit

rrTemp	        shrr	DiviTemp+2	; adding bit /2
		shrr	DiviTemp   	; divisor /2
		btfss	DiviTemp+3,1
		 goto	nextbit

finish         	movv	DiviDend,DiviSor
		movv	DiviTemp+4, DiviDend		;decimal result in DiviDend(div), DiviSor (mod)	
exit	    
	    endm



;div16by16	DiviDend, DiviSor


;
;
;	eeeq	UrL,0x7FFF*.16
;		clrfff	UprampTime
;		clrfff	BL
;		call	I004		; realtime division
;		decf	PeriodReg,W
;		movwf	BH
;		addwf	BH,F
;		skpnC
;		 incf	BHH,F
;		addwf	BH,F
;		skpnC
;		 incf	BHH,F		;(PR-1)*3
;		call	timefactor
;		addwf	BH,F
;		skpnC
;		 incf	BHH,F
;		eeeq	AL,0x000100		;realtime division
;maxshift	skpnanotb	AHH,0,	BHH,7
;		 goto	testsub
;		shll	AH
;		shll	BH
;		call	I004
;		goto	maxshift
;	
;	
;testsub		skp24ge	UrL, BL
;		 goto	nosub		
;		inccc	UprampTime,AL
;		deccc	UrL,BL
; 		call	I004
;nosub		shrrr	AL
;		shrrr	BL
;		call	I004
;		
;		btfss	AL,0		;early break
;		 goto testsub		;unsuccessful subtract
;


mul8x8     macro ReSult, MultiplAnd, MultiKator ,MulTemp ; :3   
	   local	moreadd, noadd
		clrff	ReSult		; result 
		mov	MultiKator,MulTemp 
		clrf	MulTemp+1;
		mov	MultiplAnd,MulTemp+2
moreadd	        btfss	MulTemp+2,0
		 goto	noadd
		add2	MulTemp, ReSult	; R= A+R
noadd	       shl2	MulTemp		; A= A * 2
		clrc
		rrf	MulTemp+2,F	; more bits to work with?
		movf	MulTemp+2,F
		bnz	moreadd
	endm				; result in ReSult

mul16x16_16     macro MultiplAnd, MultiKator ,MulTemp ; :10  
	   local	moreadd, noadd
		clrffff	MulTemp+6		; result=0 
		movv	MultiKator,MulTemp 
		clrff	MulTemp+4;
		movv	MultiplAnd,MulTemp+2
moreadd	        btfss	MulTemp,0
		 goto	noadd
		incccc	MulTemp+6,MulTemp+2	; R= A+R
noadd	        shllll	MulTemp+2		; A= A * 2
		shrr	MulTemp         ; K=K/2
		movfw	MulTemp		; more bits to work with?
		iorwf	MulTemp+1,W
		bnz	moreadd
		movv	MulTemp+8,MultiplAnd

	endm				; result in MultiPland



mul8x8.8l macro MultiplAnd, MultConstInt,MultConstFrac,MulTemp ; :4
	  local	moreadd, noadd
		clrff	MulTemp+2			; result
		eq	MulTemp,MultConstFrac 		; e.g. 0x0064	; decimal .100 (frac / integer)
		eq	MulTemp+1,MultConstInt
moreadd	        btfss	MultiplAnd,0
		 goto	noadd
		incc	MulTemp+2, MulTemp		; B= A+B
noadd	       	shll	MulTemp				; A= A * 2
		clrc
		rrf	MultiplAnd,F			; more bits to work with?
		movf	MultiplAnd,F
		bnz	moreadd
	endm						; result in MulTemp+2 (:2)

 
mul16.8x8.8l macro MultiplAnd, val ,vfrac  ; Lo 8(fraction) /Hi 8(integer)	
		local	moreadd, noadd				; needs 
				;cblock 
				; 1 byte extra above and under Multipland,AL_1:4,BL:2
				;		DL
				;#define 	DH		DL+1
				; will leave factors intact
		movfff	MultiplAnd, AL_1 
		clrf	AH+1
		eq	BL, vfrac 			;
		eq	BH, val
		clrffff	MultiplAnd-1		; result in MultiplikAnd


moreadd	        btfss	BL,0		
		 goto	noadd
		add4	AL_1, MultiplAnd-1		; R= A+R
noadd	       shl4	AL_1		; A= A * 2
		clrc
		rrf	BH,F	
		rrf	BL,F		; B= B div 2 more bits to work with?
		movfw	BH
		iorwf	BL,W
		bnz	moreadd
	
	endm				;  
 	
 
mul8.8x8.8v macro Result,MultiplAnd, MultiKator, MulTemp:10
		local	moreadd, noadd				; needs 
			
				;Result:16.8
				; will leave factors intact
		clrffff	MulTemp		; result in BL
		movff	MultiKator, MulTemp+4 
		clrff	MulTemp+6
		movff	MultiplAnd, MulTemp+8
moreadd	        btfss	MulTemp+8,0	
		 goto	noadd
		incccc	MulTemp,MulTemp+4		; B= A+B
noadd	        shllll	MulTemp+4		; A= A * 2
		shrr	MulTemp+8	
					; D= D div 2 more bits to work with?
		movfw	DH
		iorwf	DL,W
		bnz	moreadd

;		mov	Result+1,Result		; Resolution reduction
;		mov	Result+2,Result+1; Resolution reduction
;		mov	Result+3,Result+2; Resolution reduction
;		clrf	Result+3	; Resolution reduction
	    endm				
 	
		
;TB040
;DS91040A-page 2 Preliminary ? 2000 Microchip Technology Inc.
;EXAMPLE 1: 8-BIT EXAMPLE
;A = v0xCF48
;A2 = 0xCF48
;or
;Step
;1	1000 0000 (0x80)	this squared is less than 0xCF48, start next cycle with a new bit

;2	1100 0000 (0xC0)this squared is less than 0xCF48, start next cycle with a new bit
;3	1110 0000 (0xE0)
;4	1111 0000 (0xF0)
;5	1110 1000 (0xE8)
;6	1110 0100 (0xE4)
;7	1110 0110 (0xE6)
;8	1110 0111 (0xE7)
;9	1110 0110 (0xE6)
;Aprocess is finished; otherwise, this could keep going for more accurate
;fractional approximation

;
;new bit
;1100 0000 (0xC0)
;new bit
;
;new bit
;
;shifted bit
;
;shifted bit
;
;new bit
;
;new bit
;
;bit shifted out
;
;Description
;;this squared is less than 0xCF48, start next cycle with a new bit
;this squared is less than 0xCF48, start next cycle with a new bit
;this is greater than 0xCF48, shift bit right
;this is greater than 0xCF48, shift bit right
;this squared is less than 0xCF48, start next cycle with a new bit
;this squared is less than 0xCF48, start next cycle with a new bit
;this is greater than 0xCF48, shift right
;right-most bit is thrown away for the integer approximation and the
;
