;************************************************************************
;      macros

#define Bank0		0x00
#define	Bank1		0x80
#define DUMMY 0
mov_w	macro Source
		if Source < Bank1
		 movfw	Source
		else
		 if Source < 0x1000
		  banksel	Bank1
		  movfw	Source
		  banksel	Bank0
		 else
		  banksel	EEADR
		  movlw	Source & 0xFF
		  movwf	EEADR
		  bsf	EECON1,RD
		  movfw	EEDAT
		  banksel Bank0	
		 endif
		endif
	endm


mov_f macro Target
		if Target < Bank1
		 movwf	Target
		else
		 if Target < 0x1000
		  banksel	Bank1
		  movwf	Target
		  banksel	Bank0
		 else
		  banksel	EEDAT	
		  movwf	EEDAT
		  movlw	Target & 0xFF
		  movwf EEADR
		  call	cwrtEE
		  banksel Bank0
		 endif
		endif
	endm


mov	macro Source, Target
	 mov_w Source
	 mov_f Target
	endm



#define	byte		.8;
#define	word		.16;
#define	wordbyte	.24;
#define	longint		.32;
#define	byteconst	-.8;
#define	wordconst	-.16;
#define	wordbyteconst	-.24;
#define	longintconst	-.32;

move	macro Source, Target, bits
	 variable	bitc
bitc = 0
	while bitc<bits
 	  mov	Source+(bitc / 8), Target + (bitc / 8)
bitc += 8
	endw
	endm

	
clearf	macro Target, bits
	 variable	bitc
	 if Target >= 0x1000 
 	  movlw	0

bitc = 0
	while bitc<bits
	  mov_f Target+ (bitc / 8)
bitc += 8
	endw
	 else
	  if Target >= Bank1 
	   banksel Bank1
          endif
bitc = 0
	while bitc<bits
	 clrf	Target+ (bitc / 8)
bitc += 8
	endw

	  if Target >= Bank1 
	   banksel Bank0 	
          endif
	 endif
	endm

eqte 	    macro var, val,bits
		variable	bitc

		if var >= 0x1000 
bitc = 0
	 while bitc<bits
          movlw (val >> bitc ) & 0xFF
	  mov_f var+ (bitc / 8)
bitc += 8
	 endw
	else
	 if var >= Bank1 
	   banksel Bank1
  	 endif
bitc = 0
	 while bitc<bits
 
	  if (val >>bitc) & 0xFF
 		movlw	(val >> bitc ) & 0xFF
 		movwf	var+ (bitc / 8)
		else
		clrf	var+ (bitc / 8)
	  endif
bitc += 8
	 endw
	 if var >= Bank1 
	   banksel Bank0
  	 endif
	endif
 	    endm

eq	macro	var, val
	    eqte var, val,byte
	endm


suball  macro	Diff, SubEnd
		if SubEnd < Bank1 
		 if Diff != SubEnd
		  subwf	SubEnd,W
		 else
		  subwf SubEnd,F
		 endif
		else
		 if SubEnd < 0x1000
		 Banksel Bank1
		 if Diff != SubEnd
		  subwf	SubEnd,W
		 else
		  subwf SubEnd,F
		 endif
		 Banksel Bank0
		 else
		  movwf	STACK
		  banksel	EEADR
		  movlw	SubEnd & 0xFF
		  movwf	EEADR
		  bsf	EECON1,RD
		  banksel	Bank0
		  movfw	STACK
		  Banksel Bank1
		  if Diff != SubEnd
		  subwf	EEDAT,W
		 else
		  subwf EEDAT,F
		  call	wrtEE
		 endif
		  banksel Bank0
		 endif
                endif
	endm

sub	macro	Diff, SubEnd, SubTor



		mov_w	SubTor
		suball	Diff,SubEnd
		if	Diff != SubEnd
		 mov_f	Diff
		endif
	endm

subb	macro	Diff, SubEnd, SubTor,bits
		variable	bitc	
		sub	Diff,SubEnd,SubTor
bitc	= 8
		while bitc < bits	
		if (SubEnd < Bank1) & (SubTor < Bank1)
		 movfw	SubTor+(bitc / 8)
		 skpC	
		  incfsz	SubTor+(bitc / 8),W
		 if Diff == SubEnd
		  subwf	SubEnd+(bitc / 8),F
		 else
		  subwf	SubEnd+(bitc / 8),W
		 endif
		else
		 if SubEnd < Bank1
 		  mov SubTor+(bitc / 8), STACK
		  skpC
		   incfsz STACK,W
		  if Diff == SubEnd
		  subwf	SubEnd+(bitc / 8),F
		 else
		  subwf	SubEnd+(bitc / 8),W
		 endif
		 else
                  mov SubEnd+(bitc / 8), STACK-1
		  mov SubTor+(bitc / 8), STACK
		  skpC
		   incfsz STACK,W
		  subwf STACK-1,W
		 endif
		endif
		if  (SubEnd >=Bank1) | (Diff != SubEnd)
		 mov_f	Diff+(bitc / 8)
		endif
bitc += 8
	 	endw
	endm


decC	    macro	Target
		skpC
		 decf	Target,F
	    endm


addall  macro	Sum,AddEnd

		if AddEnd <Bank1 
		 if Sum != AddEnd
		  addwf	AddEnd,W
		 else
		  addwf AddEnd,F
		 endif
		else
		 if AddEnd < 0x1000
		 Banksel Bank1
		if Sum != AddEnd
		  addwf	AddEnd,W
		 else
		  addwf AddEnd,F
		 endif
		 Banksel Bank0
		 else
		  movwf	STACK
		  banksel	EEADR
		  movlw	AddEnd & 0xFF
		  movwf	EEADR
		  bsf	EECON1,RD
		  banksel	Bank0
		  movfw	STACK
		  Banksel Bank1
		  if Sum != AddEnd
		  addwf	EEDAT,W
		 else
		  addwf EEDAT,F
		  call	wrtEE
		 endif
		  banksel Bank0
		 endif
                endif
	endm



add	    macro result, var1, var2
		mov_w	var2
		addall	result, var1
		if	result != var1
		 mov_f	result
		endif
	    endm

addvv	    macro Sum, AddEnd,AddTor,bits
		variable	bitc	
		add Sum,AddEnd,AddTor
bitc = 8
		while bitc < bits	
		if (AddEnd <Bank1) & (AddTor < Bank1)
		 movfw	AddTor+ (bitc /8)
		 skpNC	
		  incfsz	AddTor+(bitc /8),W
	 	if Sum == AddEnd
		  addwf	AddEnd+(bitc / 8),F
		 else
		  addwf	AddEnd+(bitc / 8),W
		 endif
		else
		 if AddEnd < Bank1
 		  mov AddTor+(bitc /8), STACK
		  skpNC
		   incfsz STACK,W
	 	if Sum == AddEnd
		  addwf	AddEnd+(bitc / 8),F
		 else
		  addwf	AddEnd+(bitc / 8),W
		 endif
		 else
                  mov AddEnd+(bitc / 8), STACK-1
		  mov AddTor+(bitc / 8), STACK
		  skpNC
		   incfsz STACK,W
		  addwf STACK-1,W
		 endif
		endif

		if  (AddEnd >=Bank1) | (Sum != AddEnd)
		 mov_f	Sum+(bitc / 8)
		endif
bitc += 8
	 	endw

	    endm

#define	plus	1
#define	minus	2

ar_	macro	result, fac1, oprtr, fac2, bits
		if oprtr	== plus
		  addvv result, fac1,fac2,bits
		 endif
	   	if oprtr	== minus
		  subb result, fac1,fac2,bits
		 endif
		
	endm
;
;
;
;
;
;
;incl	    macro result, val
;		movlw	val
;		addwf	result,F
;	    endm
;
;incll	    macro	var1, val
;	    local	c0,c8,c8e
;		goto c0
;
;c8		if ((val >>.8)+1) & 0xFF
;		 movlw 	((val >>.8)+1) & 0xFF
;		 addwf	var1+1
;		endif
;		goto c8e
;
;c0		movlw	val & 0xFF
;		addwf	var1,F
;		skpNC
;		 goto c8
;		if	(val >>.8) & 0xFF
;		  movlw	(val >>.8) & 0xFF
;		  addwf	var1+1,F
;		endif
;c8e
;	endm
;
;
;		
;inclll	macro 	var1, val
;		local	c0,c8,c8e,c16,c16e
;		goto c0
;
;c8		if ((val >>.8)+1) & 0xFF
;		 movlw 	((val >>.8)+1) & 0xFF
;		 addwf	var1+1
;		endif
;		goto c8e
;
;c16		if ((val >>.16)+1) & 0xFF
;		 movlw 	((val >>.8)+1) & 0xFF
;		 addwf	var1+1
;		endif
;		goto c16e
;
;
;		
;		;
;c0		movlw	val & 0xFF
;		addwf	var1,F
;
;	
;		skpNC
;		 goto c8
;		if	(val >>.8) & 0xFF
;		  movlw	(val >>.8) & 0xFF
;		  addwf	var1+1,F
;		endif
;
;c8e		skpNC
;		 goto c16
;		if	(val >>.16) & 0xFF
;		  movlw	(val >>.16) & 0xFF
;		  addwf	var1+1,F
;		endif
;c16e
;		endm	
;incllll	    macro 	var1, val
;		inclll var1, val
;
;		movlw	((val >>.24) & 0xFF)
;		skpC
;		 goto	$+2
;		if ((val >>.24)+1) & 0xFF
;		  movlw	((val >>.24)+1) & 0xFF
;		else
;		  goto $+2
;		endif
;		addwf	var1+3,F
;	    endm		
;	
;
;decl	    macro result, val
;		incl	result, -val
;	    endm
;
;decll	    macro	var1, val
;	 	incll	var1, -val
;	    endm		
;declll	    macro	var1, val
;		inclll	var1, -val
;	    endm	
;decllll	    macro	var1, val
;		incllll var1, -val
;	    endm		
;
;swapwf      MACRO  REG
;            	XORWF  REG,F
;        	XORWF  REG,W
;        	XORWF  REG,F
;            ENDM
;swapvv macro	var1,var2,bits
;	variable bitc
;bitc =0
;		while	bitc < bits
;	 if var1 >= Bank1 
;	   banksel Bank1
;  	 endif
;		movfw	var1 + (bitc / 8)
;	 if (var2 >= Bank1) & (var1 <Bank1) 
;	   banksel Bank1
;  	 endif
;		xorwf	var2+ (bitc / 8),F
;		xorwf	var2+ (bitc / 8),w
;		xorwf	var2+ (bitc / 8),F
;	 if (var2 >= Bank1) & (var1 <Bank1) 
;	   banksel Bank0
;  	 endif
;		movwf	var1+ (bitc / 8)
;	 if (var1 >= Bank1) 
;	   banksel Bank0
;  	 endif
;bitc +=8
;		endw
;	endm
;
;shml	macro	Target, shifts, Counter, bits
;	local	loop
;	variable bitc
;		movlw	shifts
;		movwf	Counter
;loop		clrC
;bitc =0		
;		while bitc < bits
;		rlf	Target+(bitc /8),F
;bitc +=8	
;		endw
;		decfsz	Counter,F
;		 goto	loop
;		endm
;
;
;
;pwrof2 macro	Target, shifts,Counter,bits
;	  shml	 Target, shifts,Counter,bits
;	endm
;
;shmr	macro	Target, shifts, Counter, bits
;	local	loop
;	variable bitc
;	
;		movlw	shifts
;		movwf	Counter
;loop		clrC
;		if (Target >= Bank1)  
;	   	 banksel Bank1
;  	 	endif
;bitc =0		
;		while bitc < bits
;		rrf	Target+(bitc /8),F
;bitc +=8	
;		endw
;		if (Target >= Bank1) 
;	   	 banksel Bank0
;  	 	endif
;		decfsz	Counter,F
;		 goto	loop
;
;
;		endm
;
;
;
;shr	macro	Target
;		clrC
;		rrf	Target,F
;	endm
;
;shrr	macro	Target,bits
;	 variable bitc
;		clrC
;		if (Target >= Bank1) 
;	   	 banksel Bank1
;  	 	endif
;bitc =0		
;		while bitc < bits
;		rrf	Target+(bitc /8),F
;bitc +=8	
;		endw
;		if (Target >= Bank1) 
;	   	 banksel Bank0
;  	 	endif
;	endm
;
;
;
;
;divby2  macro   Target,bits
; 	 	shrr 	Target
;	endm
;
;shl	macro	Target
;		clrC
;		rlf	Target,F
;	endm
;
;mult2	macro   Target
; 	 	shl 	Target
;	endm
;
;shll	macro	Target,bits
;	 variable bitc
;		clrC
;		if (Target >= Bank1) 
;	   	 banksel Bank1
;  	 	endif
;bitc =0		
;		while bitc < bits
;		rlf	Target+(bitc /8),F
;bitc +=8	
;		endw
;		if (Target >= Bank1) 
;	   	 banksel Bank0
;  	 	endif
;	endm
;
;
;
;
;skpge	    macro var1, var2	;skip next instr if var1 greater equal var2
;
;		mov_w	var2
;		suball	DUMMY,var1
;		skpC
;	    endm
;
;exels	    macro var1, var2	;execute next instr if var1 less var2
;             	skpge var1,var2
;	    endm
;
;
;
;skpgevv	    macro var1, var2,bits	;skip next instr if var1 greater equal var2 
;		variable bitc
;		local decide
;bitc = bits
;		while bitc > 0	
;		 mov_w	var2+((bitc-8) /8)
;		suball  DUMMY,	var1+((bitc-8) /8)
;		if bitc > 8
;		skpZ
;		 goto decide
;		endif
;bitc -=8
;		endw
;
;decide		skpC
;;		 conditional code
;	    endm
;
;exelsvv	    macro var1, var2,bits
;		skpgevv	var1,var2,bits
;
;
;skple	    macro var1,var2
;	     skpge var2,var1
;	    endm	
;skplev	    macro var1,var2
;	     skpgev var2,var1
;	    endm	
;skplevv	    macro var1,var2,bits
;	     skpgevv var2,var1,bits
;	    endm	
;
;exegr	    macro var1,var2
;		skple	var1,var2
;	    endm
;
;exegrvv	    macro var1, var2,bits
;		skplevv	var1,var2,bits
;	    endm
;
;skpgr	    macro var1, var2
;		movfw	var1
;		subwf	var2,W
;		skpNC
;	    endm
;
;skpgrv	    macro var1,var2	;skip next instr if var1 greater  var2
;		movfw	var1
;		subwf	var2,W
;		skpNC
;	    endm
;
;skpgrvv	    macro var2, var1,bits	;skip next instr if var1 greater  var2 (16bit LSB-MSB)
;		variable bitc
;		local decide
;
;bitc = bits
;		while bitc > 0	
;		 mov_w	var2+((bitc-8) /8)
;		suball	DUMMY,var1+((bitc-8) /8)
;		if bitc > 8
;		skpZ
;		 goto decide
;		endif
;bitc -=8
;		endw
;
;decide		skpNC
;;		 conditional code
;	    endm
;
;
;
;exele	    macro var1,var2
;		skpgr	var1,var2
;	    endm
;exelev	    macro var1,var2
;		skpgrv	var1,var2
;	    endm
;exelevv	    macro var1,var2,bits
;		skpgrvv	var1,var2,bits
;	    endm
;
;
;exege	    macro var1,var2
;		skpgr	var2,var1
;	    endm
;exegev	    macro var1,var2
;		skpgrv	var2,var1
;	    endm
;exegevv	    macro var1,var2,bits
;		skpgrvv	var2,var1,bits
;	    endm
;
;skpeq	    macro var1, var2
;		movf_w	var1
;		suball	DUMMY,var2
;		skpZ
;	    endm
;
;skpeqq	    macro var1, var2,bits
;		variable bitc
;		local decide
;bitc = bits
;		while bitc > 0	
;		 mov_w	var2+((bitc-8) /8)
;		suball	DUMMY, var1+((bitc-8) /8)
;		if bitc > 8
;		skpZ
;		 goto decide +1
;		endif
;bitc -=8
;		endw
;
;decide		skpZ
;;		 not equal cod
;	    endm
;
;exeneq      macro var1, var2	;execute next instr if var1 not equal var2
;             	skpeq var1,var2
;	    endm
;exeneqq     macro var1, var2,bits	;execute next instr if var1 not equal var2  (16bit)
;             	skpeqq var1,var2,bits
;	    endm
;
;skpneq	    macro var1, var2
;		movf_w	var1
;		suball	DUMMY,var2
;		skpNZ
;	    endm
;
;skpneqq	    macro var1, var2,bits
;		variable bitc
;		local decide
;bitc = bits
;		while bitc > 0	
;		 mov_w	var2+((bitc-8) /8)
;		suball	DUMMY,var1+((bitc-8) /8)
;		if bitc > 8
;		skpZ
;		 goto decide +2
;		endif
;bitc -=8
;		endw
;
;decide		skpNZ
;;		 is equal cod
;	    endm
;
;exeeq      macro var1, var2	;execute next instr if var1 equal var2
;             	skpneq var1,var2
;	    endm
;exeeqq     macro var1, var2,bits	;execute next instr if var1 equal var2  (16bit)
;             	skpneqq var1,var2,bits
;	    endm
;
;
;skpeql	    macro var1, val	;skip var1  equal literal
;		movlw	val
;		suball	DUMMY,var1
;		skpZ
;	    endm
;
;skpeqll	    macro var1, val, bits
;		variable bitc
;		local decide
;bitc = -bits
;		while bitc > 0	
;		 movlw	(val >> (bitc-8) ) & 0xFF
;		suball	DUMMY,var1+((bitc-8) /8)
;		if bitc > 8
;		skpZ
;		 goto decide +1
;		endif
;bitc -=8
;		endw
;
;decide		skpZ
;;		 not equal cod
;	    endm
;
;exeneql      macro var1, val	;execute next instr if var1 not equal val
;             	skpeql var1,val
;	    endm
;exeneqll     macro var1, val,bits	;execute next instr if var1 not equal val  (16bit)
;             	skpeqll var1,val,bits
;	    endm
;
;skpneql	    macro var1, val		;skip var1  not equal literal
;		movlw	val
;		suball	DUMMY,var1
;		skpNZ
;	    endm
;
;skpneqll	    macro var1, val, bits
;		variable bitc
;		local decide
;bitc = -bits
;		while bitc > 0	
;		 movlw	(val >> (bitc-8) ) & 0xFF
;		suball	var1+((bitc-8) /8)
;		if bitc > 8
;		skpZ
;		 goto decide +2
;		endif
;bitc -=8
;		endw
;
;decide		skpNZ
;;		 equal cod
;	    endm
;exeeql      macro var1, val	;execute next instr if var1 equal val
;             	skpneql var1,val
;	    endm
;exeeqll     macro var1, val,bits	;execute next instr if var1 equal val  (16bit)
;             	skpneqll var1,val
;	    endm
;
;exeelll    macro var1, val,bits	;execute next instr if var1 equal val (24bit)
;             	skpneqlll var1,val
;	    endm
;
;skpgel	    macro var1, val		;skip var1 greater equal literal
;		movlw	val
;		suball	DUMMY,var1
;		skpC
;	    endm
;
;skpgell	    macro var1, val, bits
;		variable bitc
;		local decide
;bitc = -bits
;		while bitc > 0	
;		 movlw	(val >> (bitc-8) ) & 0xFF
;		suball	DUMMY,var1+((bitc-8) /8)
;		if bitc > 8
;		skpZ
;		 goto decide 
;		endif
;bitc -=8
;		endw
;
;decide		skpC
;;		 less code
;	    endm
;
;exelsl     macro var1, val	;execute var1 less  literal 
;		skpgel var1,val
;	   endm
;
;exelsll     macro var1, val,bits	;execute var1 less  literal 
;		skpgell var1,val,bits
;	   endm
;
;skpgrl	   macro var1,val
;		skpgel var1, val+1
;	   endm
;
;skpgrll	   macro var1,val,bits
;		skpgell var1, val+1,bits
;	   endm
;
;
;exelel     macro var1, val	;execute var1 less  literal 
;		skpgel var1,val+1
;	   endm
;
;exelell     macro var1, val,bits	;execute var1 less  literal 
;		skpgell var1,val+1,bits
;	   endm
;
;skplsl	    macro var1, val	;skip var1 less  literal
;		movlw	val
;		suball	DUMMY,var1
;		skpNC
;	    endm
;
;skplsll	    macro var1, val, bits
;		variable bitc
;		local decide
;bitc = -bits
;		while bitc > 0	
;		 movlw	(val >> (bitc-8) ) & 0xFF
;		suball	DUMMY,var1+((bitc-8) /8)
;		if bitc > 8
;		skpZ
;		 goto decide 
;		endif
;bitc -=8
;		endw
;
;decide		skpNC
;;		 greater equal cod
;	    endm
;
;exegel	    macro var1, val
;		skplsl var1, val
;	    endm
;exegell	    macro var1,val,bits
;		skplsll var1,val,bits
;	    endm
;
;
;skplel	    macro var1, val	;skip var1 less equal literal
;                skplsl var1, val-1
;	    endm
;
;skplell	    macro var1, val,bits		;skip var1 less literal 16bit
;	        skplsll var1, val-1,bits
;	    endm
;
;#define		grtr	1
;#define		grtr_eql	2
;#define		lss	3
;#define		lss_eql	4
;#define		eql	5
;#define		not_eql	6
;
;
;if_	    macro var1,oprtr,var2,bits
;
;		if (oprtr == grtr) 
;		 if bits > 0 
;		   exegrvv var1,var2,bits
;		 else
;	 	   exegell var1,var2+1,bits
;	    	 endif
;	        endif
;	
;		if (oprtr == grtr_eql) 
;		 if bits > 0 
;		   exegevv var1,var2,bits
;		 else
;	 	   exegell var1,var2,bits
;	    	 endif
;		endif
;		if (oprtr == lss) 
;		 if bits > 0 
;		   exelsvv var1,var2,bits
;		 else
;	 	   exelell var1,var2+1,bits
;	    	 endif
;		endif
;		if (oprtr == lss_eql) 
;	 
;		 if bits > 0 
;		   exelevv var1,var2,bits
;		 else
;	 	   exelell var1,var2,bits
;	    	 endif
;		endif
;		if (oprtr == eql) 	 
;		 if bits > 0 
;		   exeeqvv var1,var2,bits
;		 else
;	 	   exeeqll var1,var2,bits
;	    	 endif
;		endif
;		if (oprtr == not_eql) 	 
;		 if bits > 0 
;		   exenevv var1,var2,bits
;		 else
;	 	   exenell var1,var2,bits
;	    	 endif
;		endif
;
;
;	    endm
;
;
;
;;****************************************** now legal macros **********************
;
;
;
;skp_ornot   macro	base1, bit1, base2, bit2;bit1	bit2 result
;		btfss	base1, bit1		; 1      0     skp
;		 btfss	base2, bit2		; 1      1     skp
;		goto	$+2			; 0      0     skp
;				;       	; 0      1     
;				; execute not(bit1) and  bit2
;	    endm
;if_but    macro base1, bit1, base2, bit2
;		skp_ornot base1, bit1, base2, bit2
;	   endm
;
;skp_fault	macro	base1, bit1, base2, bit2	;bit1	bit2 result
;		btfsc	base1, bit1		; 1      0     skp
;		 btfss	base2, bit2		; 1      1
;		goto	$+2			; 0      0     skp
;				;       	; 0      1     skp
;				; execute (bit1) and (bit2)
;	endm
;if_both    macro base1, bit1, base2, bit2
;		skp_fault base1, bit1, base2, bit2
;	   endm
;
;
;skp_any	macro	base1, bit1, base2, bit2	;base1, bit1	bit2 result
;		btfss	base1, bit1		; 1      0   skp
;		 btfsc	base2, bit2		; 1      1   skp	
;		goto	$+2			; 0      0 
;						; 0      1   skp
;				;exeute not (bit1 or bit 2)
;	endm
;if_none    macro base1, bit1, base2, bit2
;		skp_any base1, bit1, base2, bit2
;	   endm
;
;
;
;
;
;;execaornotb
;skp_but macro	base1, bit1, base2, bit2	;bit1	bit2 result
;		btfss	base1, bit1		; 1      0     
;		  				; 1      1     
;		 btfss	base2, bit2		; 0      0     
;		      				; 0      1     skp
;				;
;				; execute bit1 or not(bit2)
;	endm
;if_ornot    macro base1, bit1, base2, bit2
;		skp_but base1, bit1, base2, bit2
;	   endm
;
;
;
;
;;execaorb
;skp_none	macro	base1, bit1, base2, bit2;bit1	bit2 result
;		btfss	base1, bit1		; 1      0     
;		 btfsc	base2, bit2		; 1      1     
;						; 0      0     skp
;				;       	; 0      1     
;				; execute not(bit1) and  not(bit2)
;	endm
;if_any    macro base1, bit1, base2, bit2
;		skp_none base1, bit1, base2, bit2
;	   endm
;	
;			
;;execnandb
;skp_both macro	base1, bit1, base2, bit2	;bit1	bit2 result
;		btfsc	base1, bit1		; 1      0     
;		     				; 1      1     skp     
;		 btfss	base2, bit2		; 0      0     
;		 				; 0      1     
;				;
;				;execute bit1 or bit2
;	endm
;if_fault    macro base1, bit1, base2, bit2
;		skp_both base1, bit1, base2, bit2
;	   endm
;
;
;;execxorb 
;skp_equal macro	base1, bit1, base2, bit2	;bit1	bit2 result
;		btfss	base1, bit1		; 1      0     
;		 goto  	$+4			; 1      1    skp
;		btfss	base2, bit2		; 0      0    skp
;		 goto   $+3			; 0      1    
;		goto	$+3
;		btfsc   base2, bit2
;					;execute    bit1 xor bit2
;	endm
;
;if_either    macro base1, bit1, base2, bit2
;		skp_equal base1, bit1, base2, bit2
;	   endm
;
;
;;execeqb 
;skp_either macro	base1, bit1, base2, bit2	;bit1	bit2 result
;		btfss	base1, bit1		; 1      0    skp 
;		 goto  	$+4			; 1      1    
;		btfsc	base2, bit2		; 0      0    
;		 goto   $+3			; 0      1    skp
;		goto	$+3
;		btfss   base2, bit2
;					;
;				;execute    bit1 eq bit2
;	endm
;if_equal    macro base1, bit1, base2, bit2
;		skp_either base1, bit1, base2, bit2
;	   endm
;
;#define not_but 0
;#define and 1
;#define nor 2
;#define or_not 3
;#define or 4
;#define not_or_not 5
;#define either_or 6
;#define equal 7
;  
;
;
;if__	macro base1, bit1, oprtr, base2, bit2
;	  if oprtr == not_but
;		if_but base1, bit1, base2, bit2
;	  endif
;	  if oprtr == and
;		if_both base1, bit1, base2, bit2
;	  endif
;	  if oprtr == nor
;		if_none base1, bit1, base2, bit2
;	  endif
;	  if oprtr == or_not
;		if_ornot base1, bit1, base2, bit2
;	  endif
;	  if oprtr == or
;		if_any base1, bit1, base2, bit2
;	  endif
;	  if oprtr == not_or_not
;		if_fault base1, bit1, base2, bit2
;	  endif
;	  if oprtr == either_or
;		if_either base1, bit1, base2, bit2
;	  endif
;	  if oprtr == equal
;		if_equal base1, bit1, base2, bit2
;	  endif
;
;	
;	endm
;
;movbit	macro Source,Sbit, Target, Tbit
;		btfss	Source,Sbit
;		 bcf	Target,Tbit
;                btfsc Source,Sbit
;		 bsf	Target,Tbit
;	endm
;invbit	macro  Target, Tbit
;	 movlw	1 << Tbit
;	 xorwf	Target,F
;	endm
;
;
;;************************************************************* 
;
;movEEAdl	macro	data1	
;		
;		movlw	data1
;		banksel	EEADR	
;		movwf	EEADR
;	endm	
;movEEDtl	macro	data1	
;
;		movlw	data1
;		banksel	EEDAT	
;		movwf	EEDAT
;	endm
;
;
;movEEDt	macro	data1	
;		banksel	data1
;		movfw	data1
;		banksel	EEDAT	
;		movwf	EEDAT
;	endm
;
;movEEAD	macro	adr, data1
;		banksel	adr
;		movfw	adr
;		banksel	EEADR	
;		movwf	EEADR
;		banksel	data1
;		movfw	data1
;		banksel	EEDAT	
;		movwf	EEDAT
;	endm
;readEE	macro	adrl,var
;
;		banksel	EEADR
;		movlw	adrl
;		movwf	EEADR
;		bsf	EECON1,RD
;		movfw	EEDAT
;		banksel	var
;		movwf	var
;	endm
;
;
;wrtEE	macro
;		BSF	EECON1,WREN		; Bank1 is selected after MovEE macros
;	;	banksel 0
;	;	BCF	INTCON,GIE		;if fworking with interrupts
;	;	BTFSC	INTCON,GIE
;	;	 GOTO	$-2
;	;	banksel 1
;		MOVLW	55h
;		MOVWF	EECON2
;		MOVLW	0xAA
;		MOVWF	EECON2
;		BSF	EECON1,WR
;		btfsc   EECON1,WR		;  write finished?
;		 goto 	$-1
;
;		bcf 	EECON1,WREN		;
;	;	banksel	INTCON			; eneble interrupts
;	;	BSF	INTCON,GIE
;	endm	
;	;return
;	
;
;
;
;rzprg	macro	DiviDend, bits
;		local	exit,lloopp,do_div,morerot,moreadd
;		variable bitdc, v1 ,v2,v3
;v1 =   (bits-8)/8
;v2 =	v1 + (bits/8)
;v3 =	v2 + (bits/8)
;
;		 if_	DiviDend, lss_eql, .1, (-bits)
;		  goto	exit
;		move	DiviDend,STACK-v1,bits
;		eqte	STACK-v2,.1,bits
;lloopp		btfsc	STACK,7
;		 goto	do_div
;		shll	STACK-v1,bits
;		shll	STACK-v2,bits
;		goto lloopp
;do_div		clearf	DiviDend,bits
;		clearf	STACK-v3,bits
;moreadd		ar_	STACK-v3, STACK-v3,minus,STACK-v1,bits
;		ar_	DiviDend, DiviDend,plus,STACK-v2,bits
;morerot		btfsc	STACK-v2,0
;		 goto	exit
;		shrr	STACK-v1,bits
;		shrr	STACK-v2,bits
;		if_	STACK-v1,grtr,STACK-v3,bits
;		 goto morerot
;		goto moreadd
;exit
;		endm
;
;;
;;
;;div8by8mod     macro  DiviDend, DiviSor, DiviTemp ;:4
;;		;movlw	.10
;;		;movwf	DiviSor
;;		exele	Divsor,.1		
;;		 goto	exit		; minimal divison 255 div 2 = 127 /1
;;
;;		clrf	DiviTemp+3	;result
;;		eq 	DiviTemp+2, B'10000000'		; adding bit
;;		mov	DiviSor, DiviTemp
;;		clrf	DiviTemp+1
;;		mshrr	DiviTemp,2	; 
;;nextbit		shr	DiviTemp+2	; adding bit /2
;;		movf	DiviTemp,F
;;		bC	rrTemp
;;		movfw	DiviTemp+1
;;		subwf	DiviDend,W
;;		skpC
;;		 goto	rrTemp
;;		movwf	DiviDend	;success
;;		inc	DiviTemp+3,DiviTemp+2	; increment result by adding bit
;;
;;rrTemp	        
;;		shrr	DiviTemp,F    ; divisor /2
;;		btfss	DiviTemp+2,1
;;finish         mov	DiviTemp+3, DiviDend
;;		mov	DiviTemp+2, DiviSor		;decimal result in DiviDend(div), DiviSor (mod)	
;;exit	    
;;	    endm
;;
;;
;;div8by8frac     macro  DiviDend, DiviSor, DiviTemp ;:5
;;	
;;		exelev	Divsor,.1		
;;		 goto	exit		; minimal divison 255 div 2 = 127 /1
;;
;;		clrff	DiviTemp+4		;result
;;		eeq 	DiviTemp+2, 0x0100	; adding bit
;;		mov	DiviSor, DiviTemp	;shifted divisor
;;		clrf	DiviTemp+1
;;moreshift	btfsc	DiviTemp,7		; Divisor shifted to left?
;;		 goto	nextbit
;;		shl	DiviTemp		; Divisor>>
;;		rlf	DiviTemp+2		; adding bit>>
;;		goto	moreshift
;;nextbit		
;;		exelsvv	DiviDend, DiviTemp
;;		 goto	rrTemp
;;		decc	DiviDend,Dividend	;success
;;		incc	DiviTemp+4,DiviTemp+2	; increment result by adding bit
;;
;;rrTemp	        shrr	DiviTemp+2	; adding bit /2
;;		shrr	DiviTemp   	; divisor /2
;;		btfss	DiviTemp+3,1
;;		 goto	nextbit
;;
;;finish         	mov	DiviTemp+4, DiviDend
;;		mov	DiviTemp+5, DiviSor		;decimal result in DiviDend(div), DiviSor (mod)	
;;exit	    
;;	    endm
;;
;;
;;div16by16mod     macro  DiviDend, DiviSor, DiviTemp ;2:2:5
;;	
;;		exelevv	Divsor,.1		
;;		 goto	exit		; minimal divison 255 div 2 = 127 /1
;;
;;		clrff	DiviTemp+4		;result
;;		eeq 	DiviTemp+2, 0x0001	; adding bit
;;		movv	DiviSor, DiviTemp	;shifted divisor
;;		
;;moreshift	btfsc	DiviTemp,7		; Divisor shifted to left?
;;		 goto	nextbit
;;		shll	DiviTemp		; Divisor>>
;;		shll	DiviTemp+2		; adding bit>>
;;		goto	moreshift
;;nextbit		
;;		exelsvv	DiviDend, DiviTemp
;;		 goto	rrTemp
;;		decc	DiviDend,Dividend	;success
;;		incc	DiviTemp+4,DiviTemp+2	; increment result by adding bit
;;
;;rrTemp	        shrr	DiviTemp+2	; adding bit /2
;;		shrr	DiviTemp   	; divisor /2
;;		btfss	DiviTemp+3,1
;;		 goto	nextbit
;;
;;finish         	movv	DiviDend,DiviSor
;;		movv	DiviTemp+4, DiviDend		;decimal result in DiviDend(div), DiviSor (mod)	
;;exit	    
;;	    endm
;;
;;
;
;;div16by16	DiviDend, DiviSor
;
;
;;
;;
;;	eeeq	UrL,0x7FFF*.16
;;		clrfff	UprampTime
;;		clrfff	BL
;;		call	I004		; realtime division
;;		decf	PeriodReg,W
;;		movwf	BH
;;		addwf	BH,F
;;		skpnC
;;		 incf	BHH,F
;;		addwf	BH,F
;;		skpnC
;;		 incf	BHH,F		;(PR-1)*3
;;		call	timefactor
;;		addwf	BH,F
;;		skpnC
;;		 incf	BHH,F
;;		eeeq	AL,0x000100		;realtime division
;;maxshift	skpnanotb	AHH,0,	BHH,7
;;		 goto	testsub
;;		shll	AH
;;		shll	BH
;;		call	I004
;;		goto	maxshift
;;	
;;	
;;testsub		skp24ge	UrL, BL
;;		 goto	nosub		
;;		inccc	UprampTime,AL
;;		deccc	UrL,BL
;; 		call	I004
;;nosub		shrrr	AL
;;		shrrr	BL
;;		call	I004
;;		
;;		btfss	AL,0		;early break
;;		 goto testsub		;unsuccessful subtract
;;
;
;
;mul8x8     macro ReSult, MultiplAnd, MultiKator   
;	   local	moreadd, noadd
;		clrff	ReSult		; result 
;		mov	MultiKator,STACK
;		clrf	STACK-1;
;		mov	MultiplAnd,STACK-2
;moreadd	        btfss	STACK,0
;		 goto	noadd
;		addvv	STACK-2, ReSult,.16	; R= A+R
;noadd	        shll	STACK-2		,.16; A= A * 2
;		shr	STACK
;		movf	STACK,F
;		bnz	moreadd
;	endm				; result in ReSult
;
;mulvv	    macro Result, MultiPland, MultiKator, bits
;;		local	moreadd, noadd
;;		variable bitc,v1,v2,v3,STK_R,STK_And,STK_Ktr
;;
;;		v1 =  2* (bits-8)/8
;;		v2 =  v1 + 2*(bits/8)
;;		v3 = v2 + (bits/8)
;;		STK_R =	STACK-v1 
;;		STK_And = STACK-v2
;;		STK_Ktr = STACK-v3
;
;;		clearf	STK_R, bits*2
;
;;		move	MultiPland, STK_And,bits
;;		clearf	STK_And+ (bits/8), bits
;;		move	MultiKator,STK_Ktr,bits
;;
;;moreadd		btfss	STK_Ktr,0
;;		 goto 	noadd
;;		ar_	STK_R, STK_R,plus,STK_And, 2*bits
;;noadd		shll	STK_And,bits*2
;;		shrr	STK_Ktr,bits
;;		movf	STK_Ktr,F
;;bitc=8		
;;		while bitc<bits 
;;		 iorwf	STK_Ktr+(bitc/8),W
;;bitc+=8
;;		endw
;;		skpZ
;;		 goto	moreadd
;;		if Result== MultiPland
;;		 move	STK_R, MultiPland, bits
;;		else
;;		 move STK_R,Result, bits*2
;;		endif
;	    endm
;
;;mul16x16_16     macro MultiplAnd, MultiKator ,MulTemp ; :10  
;;	   local	moreadd, noadd
;;		clrffff	MulTemp+6		; result=0 
;;		movv	MultiKator,MulTemp 
;;		clrff	MulTemp+4;
;;		movv	MultiplAnd,MulTemp+2
;;moreadd	        btfss	MulTemp,0
;;		 goto	noadd
;;		incccc	MulTemp+6,MulTemp+2	; R= A+R
;;noadd	        shllll	MulTemp+2		; A= A * 2
;;		shrr	MulTemp         ; K=K/2
;;		movfw	MulTemp		; more bits to work with?
;;		iorwf	MulTemp+1,W
;;		bnz	moreadd
;;		movv	MulTemp+8,MultiplAnd
;;
;;	endm				; result in MultiPland
;;
;;
;;
;;mul8x8.8l macro MultiplAnd, MultConstInt,MultConstFrac,MulTemp ; :4
;;	  local	moreadd, noadd
;;		clrff	MulTemp+2			; result
;;		eq	MulTemp,MultConstFrac 		; e.g. 0x0064	; decimal .100 (frac / integer)
;;		eq	MulTemp+1,MultConstInt
;;moreadd	        btfss	MultiplAnd,0
;;		 goto	noadd
;;		incc	MulTemp+2, MulTemp		; B= A+B
;;noadd	       	shll	MulTemp				; A= A * 2
;;		clrc
;;		rrf	MultiplAnd,F			; more bits to work with?
;;		movf	MultiplAnd,F
;;		bnz	moreadd
;;	endm						; result in MulTemp+2 (:2)
;;
;; 
;;mul16.8x8.8l macro MultiplAnd, val ,vfrac  ; Lo 8(fraction) /Hi 8(integer)	
;;		local	moreadd, noadd				; needs 
;;				;cblock 
;;				; 1 byte extra above and under Multipland,AL_1:4,BL:2
;;				;		DL
;;				;#define 	DH		DL+1
;;				; will leave factors intact
;;		movfff	MultiplAnd, AL_1 
;;		clrf	AH+1
;;		eq	BL, vfrac 			;
;;		eq	BH, val
;;		clrffff	MultiplAnd-1		; result in MultiplikAnd
;;
;;
;;moreadd	        btfss	BL,0		
;;		 goto	noadd
;;		add4	AL_1, MultiplAnd-1		; R= A+R
;;noadd	       shl4	AL_1		; A= A * 2
;;		clrc
;;		rrf	BH,F	
;;		rrf	BL,F		; B= B div 2 more bits to work with?
;;		movfw	BH
;;		iorwf	BL,W
;;		bnz	moreadd
;;	
;;	endm				;  
;; 	
;; 
;;mul8.8x8.8v macro Result,MultiplAnd, MultiKator, MulTemp:10
;;		local	moreadd, noadd				; needs 
;;			
;;				;Result:16.8
;;				; will leave factors intact
;;		clrffff	MulTemp		; result in BL
;;		movff	MultiKator, MulTemp+4 
;;		clrff	MulTemp+6
;;		movff	MultiplAnd, MulTemp+8
;;moreadd	        btfss	MulTemp+8,0	
;;		 goto	noadd
;;		incccc	MulTemp,MulTemp+4		; B= A+B
;;noadd	        shllll	MulTemp+4		; A= A * 2
;;		shrr	MulTemp+8	
;;					; D= D div 2 more bits to work with?
;;		movfw	DH
;;		iorwf	DL,W
;;		bnz	moreadd
;;
;;;		mov	Result+1,Result		; Resolution reduction
;;;		mov	Result+2,Result+1; Resolution reduction
;;;		mov	Result+3,Result+2; Resolution reduction
;;;		clrf	Result+3	; Resolution reduction
;;	    endm				
;; 	
;		
;;TB040
;;DS91040A-page 2 Preliminary ? 2000 Microchip Technology Inc.
;;EXAMPLE 1: 8-BIT EXAMPLE
;;A = v0xCF48
;;A2 = 0xCF48
;;or
;;Step
;;1	1000 0000 (0x80)	this squared is less than 0xCF48, start next cycle with a new bit
;
;;2	1100 0000 (0xC0)this squared is less than 0xCF48, start next cycle with a new bit
;;3	1110 0000 (0xE0)
;;4	1111 0000 (0xF0)
;;5	1110 1000 (0xE8)
;;6	1110 0100 (0xE4)
;;7	1110 0110 (0xE6)
;;8	1110 0111 (0xE7)
;;9	1110 0110 (0xE6)
;;Aprocess is finished; otherwise, this could keep going for more accurate
;;fractional approximation
;
;;
;;new bit
;;1100 0000 (0xC0)
;;new bit
;;
;;new bit
;;
;;shifted bit
;;
;;shifted bit
;;
;;new bit
;;
;;new bit
;;
;;bit shifted out
;;
;;Description
;;;this squared is less than 0xCF48, start next cycle with a new bit
;;this squared is less than 0xCF48, start next cycle with a new bit
;;this is greater than 0xCF48, shift bit right
;;this is greater than 0xCF48, shift bit right
;;this squared is less than 0xCF48, start next cycle with a new bit
;;this squared is less than 0xCF48, start next cycle with a new bit
;;this is greater than 0xCF48, shift right
;;right-most bit is thrown away for the integer approximation and the
;;
