
	list      p=12F683	; list directive to define processor
	#include  macros3b.asm
	config683B
	
#define OPTIONinit	B'11000100';	; clock 1:32 , WDT 1:1 ,	
#define TRISIOinit 	b'00111001'	; GPIO1,2 as OUTPUT, GPIO 0,3,4,5 as INPUT
#define GPIOinit 	b'00000110'	; GPIO1,2 HIGH

#define 	Z_Detect_Port	GPIO,3	

	cblock	_MINRAM			; start of variables

	    SyS1,SyS2,AC_Avr
	    TimerCounter:3,JumpVector

	endc
#define		AC_Sumbit	AC_Avr,2
#define		AC_is_On	SyS1,5
#define		AC_is_High	SyS1,4
#define		Read_Out	SyS1,1

#define		LED_On		SyS2,7
#define		PWM_On		SyS2,6
#define		MAINS_On	SyS2,5

#define		Stay_Awake	SyS2,3

#define		LDR_Bright	SyS2,2
#define		Batt_Detect	SyS2,1
#define		AC_Detect	SyS2,0


;***** RESET VECTOR AND START OF CODE

	ORG     0x000           ; start coding 
        nop
	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	goto PWRUP
	ORG	0x004		;interrupts code
	return			; disable interrupts

PWRUP

		init683
		eq	AC_Avr,0
		eq	SyS2,0
		bsf	Stay_Awake
t_used = 3		
		settrap	.5*.60,sec,darkPIR,TimerCounter,JumpVector

		
MLOOP	if_not	Stay_Awake
	 goto	slpslp
	clrwdt 			;8msec
	if_not	INTCON,T0IF
	 goto	$-2		; or go somewhere else
	bcf	INTCON,T0IF 
	goto	afterwdt
	
slpslp	sleep
	sleep			; not precise for on	
afterwdt		
		call	acon
	
		decfsz	TimerCounter,F
	 	 goto	MLOOP			; 8 msec
		
		decfsz	TimerCounter+1,F
		 goto	MLOOP			; update battery,LDR,PIR every 4 seconds
 

		decfsz	TimerCounter+2,F
	 	 goto   MLOOP  			; expired counter
 	
		movfw	JumpVector
		movwf	PCL			; must be in first 256 bytes

darkPIR	bcf	LED_On
	bcf	MAINS_On
;	call	effect
	bcf	Stay_Awake
	goto	MLOOP		; set basic case

	
	
;detect0	macro
;	         movf	AC_Avr,F
;	         if_bit	STATUS,Z
;	          bcf	AC_Detect
;	endm
;	
;detect3	macro
;	         if_	AC_Avr,>,2,lit8
;	          bsf	AC_Detect
;	endm
;
;	i_f	AC_Detect,then, detect0,elseif,	detect3
;
;

red2	macro
	 red 5
	endm
blue2	macro
	 blue 5
	endm	

	i_f	AC_Detect,then, red2,	elseif, blue2
		 
	goto	MLOOP


acon		bcf	Read_Out		; read GPIO port
		btfsc	Z_Detect_Port		; store it
		 bsf    Read_Out
		bsf	AC_Sumbit		; if equal to previous reading
		if__    Read_Out,equal,AC_is_High
	  	 bcf	AC_Sumbit		; no change detected
		bsf	AC_is_On
		clrC
		rrf	AC_Avr,F		; average hits
		movf	AC_Avr,F
		skpnZ
	          bcf	AC_is_On
		bcf	AC_is_High		
		btfsc   Read_Out  		; store for next reading
		 bsf    AC_is_High	
		retlw	0	
	end