	list      p=12F683	; list directive to define processor
	#include  macros3b.asm
	config683B
	nointr683
#define OPTIONinit	B'11000100';	; clock 1:32 , WDT 1:1 ,	
	init683
	cblock	_MINRAM			; start of variables

	 SyS1

	endc


	variable TC0used


EVENTin	macro	time,unit,jumpto
	variable	optn,intime,k,clow,chigh,chi2,chi3,dus,tlab
			

		  
k=1
	if unit == msec
k=.1000
	endif
	if unit == sec
k=.1000000
	endif


	IFDEF	__12F683
				; OSCON:
				;bit 6-4 IRCF<2:0>: Internl Oscillator Frequency Select bits
				;000 = 31 kHz
				;001 = 125 kHz
				;010 = 250 kHz
				;011 = 500 kHz
				;100 = 1 MHz
				;101 = 2 MHz
				;110 = 4 MHz
				;111 = 8 MHz
	 IFDEF	OSCONinit
optn =	OSCONinit & b'01110000'
	 ELSE
optn =	b'01100001'
	 ENDIF

optn = optn >> 4
	
	 if	optn == 0
dus = 65
	 else
dus = 1<<(7-optn)
	 endif
	ELSE
dus = 2				; every other processor runs at 2 half microseconds (1MHz)
	ENDIF
	
	
optn = 0
 	IFDEF	OPTIONinit	
	 if ! (OPTIONinit & b'00001000')
optn = 1 + (OPTIONinit & b'00000111')
	endif	
	ENDIF
; OSCONinit * OPTIONinit

dus = dus << optn		; prescale from OSCON in half (0.5) microseconds 

	if unit == sec
k = k / dus 
intime = time *k * 2 	; number of timer ticks required
	else
intime = time * k / dus * 2
	endif			
clow =	intime	& 0xFF
chigh=  (intime >> 8) 
	if chigh > 0 
	 if TC0used < 1		; determine maximum of variables to use for
	 error "Required Delay needs higher clock prescaler !!"			
	 endif
	endif 
chi2  =  (intime >> .16)
	if chi2 > 0 
	 if TC0used < 2
	 error "Required Delay needs higher clock prescaler !!"
	 endif
	endif 
chi3  =  (intime >> .24)
	if chi3 > 0 
	 if TC0used < 3
	 error "Required Delay needs higher clock prescaler !!"
	 endif
	endif
	 
	if chi3 > .255
	 error "Required Delay needs higher clock prescaler !!"	 
	else

	 if TC0used > 0
	  if (intime >>8) < .1024		; omit if precise timing required
chigh = (chigh+1) & 0xFF
	  eq_ 	TC0,=,chigh,		lit8	
	  endif
	 endif

	 if TC0used > 1
	  if chi2 < .1024
chi2 = (chi2+1) & 0xFF
	 if	chi2 == chigh
	  movwf	TC0+1
	 else

	   eq_ 	TC0+1,=,chi2,	lit8
	   endif	
	  endif
	 endif
	 if TC0used > 2
chi3 +=1
	 if	chi3 == chi2
	  movwf	TC0+2
	 else
	  eq_ 	TC0+2,=,chi3,	lit8	
	 endif
	 endif

	endif

;	if      JVector != 0x00
	 movlw	jumpto
	 movwf	PrjP0
;	endif
	
;	if intime < .1024
;	 movlw	0x00FF - (intime & 0xFF)
;	 movwf	TMR0
;
;	 ifdef	__12F683
;	  bcf	INTCON,T0IF
;	 endif
;
;	 ifdef	__10F206
;	 ;	mov_bit TMR0,7,TMR7bit
;
;	  bcf	TMR7bit
;	  if_bit TMR0,7
;	   bsf	TMR7bit
;	  endif
;	 endif 
;	 
	  	
	    goto	endMLOOP0
	endm
	
TC0used = 1
	EVENTin	1,msec,0		 

JMPTable	andlw	0x03
		addwf	PCL,F
		 goto	PROCESS0

		 goto	PROCESS1

		 goto	PROCESS2
	
		 goto	PROCESS3
#define 		jMAIN 1





	 



	org	0x100
	
MLOOP	clrwdt
	if_not	INTCON,T0IF
	 goto	MLOOP
	bcf	INTCON,T0IF


	cblock
	 TC0,PrjP0
	endc

MLOOP1	decfsz	TC0,F
	 goto	endMLOOP0
	 
	movfw	PrjP0
	goto	JMPTable 
	 
endMLOOP0	 
	
	goto	MLOOP
	org	0x200

PROCESS0	
	black	5
	EVENTin 2,sec,1
	
PROCESS1
	blue	5
	EVENTin .200,msec,0

PROCESS2
PROCESS3	
	
		end