;*   This file is the firmware to implement a LED and AC lamp switch, based on 		*
;*   the PIC12F683.  It monitors the zero crossing of the AC waveform,                  *
;*   and switches off the mains or LED
;*	CONNECT IT TO MAINS, 2HOURS OF MAINS LIGHT, AFTER THAT LED LIGHT
;*	INTERRUPT MAINS, TOGGLE BETWEEN MAINS LIGHT AND LED LIGHT
;*	CONNECT IT TO BATTERY, 15 MINUTES OF LED LIGHT, AFTER THAT DARK
;                                                                    
;THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  
;WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  
;TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A       
;PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  
;IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         
;CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.       
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    mcos 1.0.2                              		                *
;*    Date:         November, 2009                                    			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael Drygas                                      		*
;*                  Applications Engineer                    				*
;*    Company:      MICHAELS Unternehmergesellschaft(haftungsbeschrnkt)                *
;*                                                                     			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   macros3b.asm                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*			\5\trafo-HU5-6-2t.brd         					*
;*                               							*
;*                                                                     			*
;*                  matching \5\smd+6+16.brd           					*
;*                                                                     			*
;****************************************************************************************







	list      p=12F683	; list directive to define processor
	#include  macros3b.asm
	config683B
	
#define OPTIONinit	B'11000100';	; clock 1:32 , WDT 1:1 ,	
#define TRISIOinit 	b'00111001'	; GPIO1,2 as OUTPUT, GPIO 0,3,4,5 as INPUT
#define GPIOinit 	b'00000110'	; GPIO1,2 HIGH

#define 	Z_Detect_Port	GPIO,3	
#define 	LDR_Port	GPIO,0	
#define 	Relay_Port	GPIO,1	
#define 	LED_Port	GPIO,2	

;****************************************************************************************


	cblock	_MINRAM			; start of variables

	    SyS1,SyS2,AC_Avr
	    CasE,AL
	    TimerCounter:3,JumpVector

	endc
#define		AC_Sumbit	AC_Avr,2
#define		AC_is_On	SyS1,5
#define		AC_is_High	SyS1,4
#define		Read_Out	SyS1,1

#define		MAINS_On	CasE,7
#define		LED_On		CasE,6
#define		Stay_Awake	CasE,5
#define		Switch_Case	CasE,4

#define		PWM_On		SyS2,6


#define		LDR_Bright	SyS2,2
#define		Batt_Detect	SyS2,1
#define		AC_Detect	SyS2,0

;****************************************************************************************
;***** RESET VECTOR AND START OF CODE

	ORG     0x000           ; start coding 
        nop
	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	goto PWRUP
	ORG	0x004		;interrupts code
	return			; disable interrupts


PWRUP

		eq	AC_Avr,0
		eq	SyS2,0
		eq	CasE,0
t_used = 3		
	 	settrap	.500 /4,msec,ledlight,TimerCounter,JumpVector
afterwdt	init683
		call	acon
	
;****************************************************************************************
		
MLOOP	if_not	Stay_Awake
	 goto	slpslp
	clrwdt 			;8msec
	if_not	INTCON,T0IF
	 goto	$-2		; or go somewhere else
	bcf	INTCON,T0IF 
	goto	afterslp
	
slpslp	sleep
	sleep			; not precise for on	


		
afterslp	call	acon
		if__	AC_Detect,not_but,AC_is_On
		 goto	ACcameon
		if__	AC_is_On,not_but,AC_Detect
		 goto	ACwentoff
	
		decfsz	TimerCounter,F
	 	 goto	MLOOP			; 8 msec
		
		decfsz	TimerCounter+1,F
		 goto	MLOOP			; update battery,LDR,PIR every 4 seconds
 

		decfsz	TimerCounter+2,F
	 	 goto   MLOOP  			; expired counter
 	
		movfw	JumpVector
		movwf	PCL			; must be in first 256 bytes



timedout	movlw	0x0F
		andwf	CasE,W
		addwf	PCL,F
		 goto	tocase0		; case 0->> loop		
		 goto	tocase2		;1
		 goto	tocase3         ;2
		 goto	tocase0         ;3
		 goto	tocase0         ;4
		 goto	tocase0         ;5
		 goto	tocase7         ;6
		 goto	tocase8         ;7
		 goto	tocase0      	;8
		 goto	tocase10	;9
		 goto	loopuntildark   ;10
		 goto	tocase12   	;11
		 goto	untilbright     ;12
		 goto	tocase10      	;13



darklight	eq	CasE,b'00000000'	; Moff, Loff,sleep,case0
	call	effect
	goto	MLOOP			; ignore further timers, wait for power down



ledlight 	
	eq	CasE,b'01000000'	; Moff, Lon,sleep,case0
	call	effect
	settrap	.15*.60 /4,sec,darklight,TimerCounter,JumpVector
	goto	MLOOP			; 

enersave  	
	eq	CasE,b'01000000'	; Moff, Lon,sleep,case0
	call	effect
	goto	MLOOP			; ignore further timers, wait for power down


ACcameon	bsf	AC_Detect

;
case6	macro		
	 eq_	CasE,=,b'10110110',lit8	 ;M on, L off, ,wake, case 6
	 settrap	.5,sec,timedout,TimerCounter,JumpVector
 	endm
; 	
case0	macro
	 eq_	CasE,=,b'01110000',lit8	 ;M off, L on, ,wake, case 0 
	 settrap	.15*.60,sec,enersave,TimerCounter,0
	endm
		
;c0or6   macro
;		 i_f	LDR_Port,then, case6, elseif, case0				
;	endm

		if_not	Switch_Case
		 goto	swC6

soff		movlw	0x0F
		andwf	CasE,W
		addwf	PCL,F
		 goto	makecase1		; 0
		 goto	makecase0		; 1
		 goto	makecase4		; 2
		 goto	makecase0		; 3	
		 goto	makecase0		; 4
		 goto	makecase0		; 5
		 goto	makecase0		; 6
		 goto	makecase9		; 7
		 goto	makecase0		; 8
		 goto	makecase0		; 9
		 goto	makecase0		;10
		 goto	makecase0		;11
		 goto	makecase0		;12
		 goto	makecase0		;13


swC6		case6
sweff		call	effect
		goto	MLOOP

ACwentoff	bcf	AC_Detect
		;clrf	AC_Avr
		movlw	0x1F
		andwf	CasE,F		; Moff, Loff,sleep, no case change
		bsf	Switch_Case
		call	effect
		settrap	.5/4,sec,darklight,TimerCounter,JumpVector
					; 5 seconds time for AC to come on
		goto	MLOOP		


;****************************************************************************************


acon		bcf	Read_Out		; read GPIO port
		btfsc	Z_Detect_Port		; store it
		 bsf    Read_Out
		bsf	AC_Sumbit		; if equal to previous reading
		if__    Read_Out,equal,AC_is_High
	  	 bcf	AC_Sumbit		; no change detected
		bsf	AC_is_On
		clrC
		rrf	AC_Avr,F		; average hits
		movf	AC_Avr,F
		skpnZ
	          bcf	AC_is_On
		bcf	AC_is_High		
		btfsc   Read_Out  		; store for next reading
		 bsf    AC_is_High	
		retlw	0
		
		
dis_pwm		macro
		movlw	b'11110011'	; disable pwm
		andwf	CCP1CON,F
		bsf	GPIO,2	        ;make sure transistor is HIGH
		bcf	LED_On
		endm

en_pwm		macro
		movlw	b'00001100'	; enable pwm
		iorwf	CCP1CON,F
		bsf	LED_On
		endm	
		
		
effect		if_not	MAINS_On
		 bsf	Relay_Port		;Pnp
		if_bit	LED_On
		 goto	ledon
		dis_pwm
		goto	mainson
ledon		if_bit	PWM_On 			
		 goto	enpwm
		bcf	LED_Port		;pnp
		goto	mainson 
enpwm		en_pwm
mainson		if_bit	MAINS_On
		 bcf	Relay_Port		;Pnp
		return
			

makecase0	eq_	CasE,=,b'01110000',lit8	 ;M off, L on, ,wake, case 0 
	 	settrap	.15*.60,sec,enersave,TimerCounter,JumpVector
		goto	MLOOP
		
cmakecase1	settrap	5,sec,timedout,TimerCounter,JumpVector
		eq_	CasE,=,b'10110001',lit8	 ;M on, L off, ,wake, case 1
		return

makecase1	call	cmakecase1
		goto	sweff

makecase4	eq_	CasE,=,b'01110100',lit8	 ;M off, L on, ,wake, case 4
t120		settrap	.120*.60,sec,timedout,TimerCounter,0
		goto	sweff		

makecase9	eq_	CasE,=,b'10111001',lit8	 ;M on, L off, ,wake, case 9
		settrap	.15,sec,timedout,TimerCounter,0
		goto	sweff		

	
tocase0		goto	makecase0
		;clrf	CasE
;		if_bit	Batt_Detect
;		 goto	darkPIR
;		goto	ledPIR

tocase2		incf	CasE,F
		settrap	.10,sec,timedout,TimerCounter,0		
		goto	MLOOP

tocase3		incf	CasE,F			
		settrap	.15*.60,sec,timedout,TimerCounter,0
		goto	MLOOP

tocase4		movlw	0xF0
		andwf	CasE,F
		movlw	4
		addwf	CasE,F
		settrap	.120*.60,sec,timedout,TimerCounter,0
		goto	MLOOP

tocase7		incf	CasE,F
		settrap	.10,sec,timedout,TimerCounter,0
		goto	MLOOP

tocase8		incf	CasE,F
			;.120*.60
		settrap	.120*.60,sec,timedout,TimerCounter,0		
		goto	MLOOP

tocase10	eq_	CasE,=,b'01111010',lit8	 ;M off, L on, ,wake, case 10
t15		settrap	.15,sec,timedout,TimerCounter,0
		goto	sweff


loopuntildark	incf	AL,F
		btfss	LDR_Port
		 goto	dark
		settrap	15,sec,timedout,TimerCounter,0

dark		eq_	CasE,=,b'10111011',lit8	 ;M on, L off, ,wake, case 11		swapf	AL,W
		movwf	TimerCounter+1
		andlw	0x0F
		movwf	TimerCounter+2
		do_	TimerCounter+2,=,TimerCounter+2,+,.16,lit8
;		call 	set120mintime		;test
		goto	sweff

tocase12	eq_	CasE,=,b'01111100',lit8	 ;M off, L on, ,wake, case 12
		goto	t120


untilbright	btfss	LDR_Port
		 goto	t15
bright		goto	tocase10
			
	end