
	list      p=12F683	; list directive to define processor
	#include  macros3b.asm
	config683B
	
#define OPTIONinit	B'11000100';	; clock 1:32 , WDT 1:1 ,	
#define TRISIOinit 	b'00111001'	; GPIO1,2 as OUTPUT, GPIO 0,3,4,5 as INPUT
#define GPIOinit 	b'00000110'	; GPIO1,2 HIGH

#define 	Z_Detect_Port	GPIO,3	

	cblock	_MINRAM			; start of variables

	    SyS1,SyS2,AC_Avr
	    TimerCounter:3,JumpVector

	endc
#define		AC_Sumbit	AC_Avr,2
#define		AC_is_On	SyS1,5
#define		AC_is_High	SyS1,4
#define		Read_Out	SyS1,1

#define		MAINS_On	CasE,7
#define		LED_On		CasE,6
#define		Stay_Awake	CasE,5
#define		Preserv_Case	CasE,4

#define		PWM_On		SyS2,6


#define		LDR_Bright	SyS2,2
#define		Batt_Detect	SyS2,1
#define		AC_Detect	SyS2,0


;***** RESET VECTOR AND START OF CODE

	ORG     0x000           ; start coding 
        nop
	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	goto PWRUP
	ORG	0x004		;interrupts code
	return			; disable interrupts

PWRUP

		init683
		eq	AC_Avr,0
		eq	SyS2,0

		
MLOOP	if_not	Stay_Awake
	 goto	slpslp
	clrwdt 			;8msec
	if_not	INTCON,T0IF
	 goto	$-2		; or go somewhere else
	bcf	INTCON,T0IF 
	goto	afterwdt
	
slpslp	sleep
	sleep			; not precise for on	
afterwdt		
		call	acon
		if__	AC_Detect,not_but,AC_is_On
		 goto	ACcameon
		if__	AC_is_On,not_but,AC_Detect
		 goto	ACwentoff
		  
		decfsz	TimerCounter,F
	 	 goto	MLOOP			; 8 msec
		
		decfsz	TimerCounter+1,F
		 goto	MLOOP			; update battery,LDR,PIR every 4 seconds
 

		decfsz	TimerCounter+2,F
	 	 goto   MLOOP  			; expired counter
 	
		movfw	JumpVector
		movwf	PCL			; must be in first 256 bytes

darkPIR	eq_	CasE,=,b'00000000',lit8		; M off, L off, ,sleep, case 0 
;	call	effect
	goto	MLOOP	

	
	
;detect0	macro
;	         movf	AC_Avr,F
;	         if_bit	STATUS,Z
;	          bcf	AC_Detect
;	endm
;	
;detect3	macro
;	         if_	AC_Avr,>,2,lit8
;	          bsf	AC_Detect
;	endm
;
;	i_f	AC_Detect,then, detect0,elseif,	detect3
;
;

red2	macro
	 red 5
	endm
blue2	macro
	 blue 5
	endm	

	i_f	AC_Detect,then, red2,	elseif, blue2
		 
	goto	MLOOP



switchcase macro
		movlw	0x0F
		andwf	CasE,W
		addwf	PCL,F
		 goto	makecase1		; 0
		 goto	makecase0		; 1
		 goto	makecase4		; 2
		 goto	makecase0		; 3	
		 goto	makecase0		; 4
		 goto	makecase0		; 5
		 goto	makecase0		; 6
		 goto	makecase9		; 7
		 goto	makecase0		; 8
		 goto	makecase0		; 9
		 goto	makecase0		;10
		 goto	makecase0		;11
		 goto	makecase0		;12
		 goto	makecase0		;13
	   endm
	   
ACcameon	bsf	AC_Detect
		i_f	Preserv_Case,then,switchcase,elseif,c0or6

case6	macro		
	 eq_	CasE,=,b'10110110'	 ;M on, L off, ,wake, case 6 
	endm
case0	macro
	 eq_	CasE,=,b'01110000'	;M off, L on, ,wake, case 0 
t_used = 3		
		settrap	.5,sec,darkPIR,TimerCounter,JumpVector

	endm	
c0or6   macro
		 i_f	LDR_Port,then, case6, elseif, case0				
		

	endm
	
		call	effect

		goto	MLOOP
	
		
ACwentoff	bcf	AC_Detect
		bcf	MAINS_On
		bcf	LED_On
		call	effect
		settrap	.5,sec,darkPIR,TimerCounter,JumpVector
		bsf	Preserv_Case
		bcf	StayAwake
		goto	MLOOP


acon		bcf	Read_Out		; read GPIO port
		btfsc	Z_Detect_Port		; store it
		 bsf    Read_Out
		bsf	AC_Sumbit		; if equal to previous reading
		if__    Read_Out,equal,AC_is_High
	  	 bcf	AC_Sumbit		; no change detected
		bsf	AC_is_On
		clrC
		rrf	AC_Avr,F		; average hits
		movf	AC_Avr,F
		skpnZ
	          bcf	AC_is_On
		bcf	AC_is_High		
		btfsc   Read_Out  		; store for next reading
		 bsf    AC_is_High	
		retlw	0

makecase0	eq	CasE,.0
		bcf	MAINS_On
		bsf	LED_On
		goto	set15min
;		clrf	TimerCounter+2		;test
		;call	set5sectime		;test
;		bcf	Dim_LED
		goto	godead
		
cmakecase1	settrap	5,sec,timedout,TimerCounter,JumpVector
		eq	CasE,.1
		bcf	LED_On
		bsf	MAINS_On
		return

makecase1	call	cmakecase1
		goto	godead

makecase4	eq	CasE,.4
		bsf	MAINS_On
		settrap	.120*.60,sec,timedout,TimerCounter,JumpVector
		goto	godead		

makecase9	eq	CasE,.9
		settrap	.15,sec,timedout,TimerCounter,JumpVector

		goto	godead		

		
		
dis_pwm		macro
		movlw	b'11110011'	; disable pwm
		andwf	CCP1CON,F
		bsf	GPIO,2	        ;make sure transistor is HIGH
		bcf	LED_On
		endm

en_pwm		macro
		movlw	b'00001100'	; enable pwm
		iorwf	CCP1CON,F
		bsf	LED_On
		endm	
		
		
effect		if_not	MAINS_On
		 bsf	Relay_Port		;Pnp
		if_bit	LED_On
		 goto	ledon
		dis_pwm
		goto	mainson
ledon		if_bit	PWM_On 			
		 goto	enpwm
		bcf	LED_Port		;pnp
		goto	mainson 
enpwm		en_pwm
mainson		if_bit	MAINS_On
		 bcf	Relay_Port		;Pnp
		return
		
		
			
	end