;*   This file is the firmware to implement a LED and AC lamp switch, based on 		*
;*   the PIC12F683.  It monitors the zero crossing of the AC waveform,                  *
;*   and switches off the mains after 2 hours
;*	CONNECT IT TO MAINS, 2HOURS OF MAINS LIGHT, AFTER THAT LED LIGHT
;*	CONNECT IT TO BATTERY, 15 MINUTES OF LED LIGHT, AFTER THAT DARK
;                                                                    
;THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  
;WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  
;TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A       
;PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  
;IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         
;CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.       
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    mcos 1.2.0                              		                *
;*    Date:         November, 2009                                    			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael Drygas                                      		*
;*                  Applications Engineer                    				*
;*    Company:      MICHAELS Unternehmergesellschaft(haftungsbeschrnkt)                *
;*                                                                     			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   macros3b.asm                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*			\5\trafo-HU5-6-2t.brd         					*
;*                               							*
;*                                                                     			*
;*                  matching \5\smd+6+16.brd           					*
;*                                                                     			*
;****************************************************************************************







	list      p=12F683	; list directive to define processor
	#include  macros3b.asm
	config683B
	
#define OPTIONinit	B'11000100';	; clock 1:32 , WDT 1:1 ,	
#define TRISIOinit 	b'00111001'	; GPIO1,2 as OUTPUT, GPIO 0,3,4,5 as INPUT
#define GPIOinit 	b'00000110'	; GPIO1,2 HIGH
#define ANSELinit 	B'01111000' 	; ADC Frc clock, ((AN0,))AN3(GP4) as analog
#define	ADCON0init	b'00001101'	; left justified , AN3, on

#define PR2init		.128
#define CCPR1Linit      PR2init - .10
#define CCP1CONinit	b'00000000'	; disable pwm
#define T2CONinit       b'00000100'	; switch on TMR2

#define 	Z_Detect_Port	GPIO,3	
#define 	LDR_Port	GPIO,0	
#define 	Relay_Port	GPIO,1	
#define 	LED_Port	GPIO,2	

;****************************************************************************************


	cblock	_MINRAM			; start of variables

	    SyS1,SyS2,BatAvr:2
	    CasE
	    TimerCounter:3,JumpVector

	endc
#define	STACK	_MAXRAM	
	
	
#define		AC_Sumbit	AC_Avr,2
#define		AC_is_On	SyS1,5
#define		AC_is_High	SyS1,4
#define		Read_Out	SyS1,1

#define		MAINS_On	CasE,7
#define		LED_On		CasE,6
#define		Stay_Awake	CasE,5
#define		Preserv_Case	CasE,4

#define		Allw_OverV	SyS2,7
#define		Main_Tenance	SyS2,6
#define		PWM_On		SyS2,5


#define		LDR_Bright	SyS2,2
#define		Batt_Detect	SyS2,1
#define		AC_Detect	SyS2,0

;****************************************************************************************
;***** RESET VECTOR AND START OF CODE

	ORG     0x000           ; start coding 
        nop
	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	goto PWRUP
	ORG	0x004		;interrupts code
	return			; disable interrupts


PWRUP


		eq	SyS2,0
		eq	CasE,0
t_used = 3		
	 	settrap	.0 ,sec,ledlight,TimerCounter,JumpVector
afterwdt	init683
		call	batADC
		eq_	BatAvr,=,ADRESH,byte

;		call	acon	; reset	readout
;		eq	ACAvr,0
;****************************************************************************************
		
MLOOP	if_not	Stay_Awake
	 goto	slpslp
	clrwdt 			;8msec
	if_not	INTCON,T0IF
	 goto	$-2		; or go somewhere else
	bcf	INTCON,T0IF 
	goto	afterslp
	
slpslp	sleep			; 35msec
	sleep			; not precise for on	


		
afterslp  	
		
;		call	acon
;		if__	AC_Detect,not_but,AC_is_On
;		 goto	ACcameon
;		if__	AC_is_On,not_but,AC_Detect
;		 goto	ACwentoff
	
		decfsz	TimerCounter,F
	 	 goto	MLOOP			; 8 msec
		
		decfsz	TimerCounter+1,F
		 goto	MLOOP			; update battery,LDR,PIR every 4 seconds
 		
 		call	battery
		call	linearze
		
		decfsz	TimerCounter+2,F
	 	 goto   MLOOP  			; expired counter

 	

		movfw	JumpVector
		movwf	PCL			; must be in first 256 bytes


dark	eq	CasE,b'00000000'	; Moff, Loff,sleep,case0
	call	effect
	goto	MLOOP			; ignore further timers, wait for power down



ledlight 	
	eq	CasE,b'01100000'	; Moff, Lon,wake,case0
	call	effect
		;.15*.60
	settrap	.15 ,sec,enersave,TimerCounter,JumpVector
	goto	MLOOP			; 

enersave  
	eq_	CCPR1L,=,.245,lit8	
	eq_	PR2,=,.255,lit8		;pnp
	goto	MLOOP			; ignore further timers, wait for power down

;ACcameon	bsf	AC_Detect

;switchcase	macro
;		 nop
;		end
;
case6	macro		
	 eq_	CasE,=,b'10110110',lit8	 ;M on, L off, ,wake, case 6
			;.120*.60
	 settrap	.30,sec,enersave,TimerCounter,JumpVector
 	endm
; 	
;case0	macro
;	 eq_	CasE,=,b'01110000'	 ;M off, L on, ,wake, case 0 
;
;	endm
;		
;c0or6   macro
;		 i_f	LDR_Port,then, case6, elseif, case0				
;	endm
;	
;		i_f	Preserv_Case,then,switchcase,elseif,c0or6
;	
;	
;		case0
;		call	effect

;		goto	MLOOP

;****************************************************************************************

;
;acon		bcf	Read_Out		; read GPIO port
;		btfsc	Z_Detect_Port		; store it
;		 bsf    Read_Out
;		bsf	AC_Sumbit		; if equal to previous reading
;		if__    Read_Out,equal,AC_is_High
;	  	 bcf	AC_Sumbit		; no change detected
;		bsf	AC_is_On
;		clrC
;		rrf	AC_Avr,F		; average hits
;		movf	AC_Avr,F
;		skpnZ
;	          bcf	AC_is_On
;		bcf	AC_is_High		
;		btfsc   Read_Out  		; store for next reading
;		 bsf    AC_is_High	
;		retlw	0
;		
		
dis_pwm		macro
		movlw	b'11110011'	; disable pwm
		andwf	CCP1CON,F
		bsf	GPIO,2	        ;make sure transistor is HIGH
;		bcf	LED_On
		endm

en_pwm		macro
		movlw	b'00001100'	; enable pwm
		iorwf	CCP1CON,F
;		bsf	LED_On
		endm	
		
		
effect		if_not	MAINS_On
		 bsf	Relay_Port		;Pnp
		if_bit	LED_On
		 goto	ledon
		dis_pwm
		goto	mainson
ledon		if_bit	PWM_On 			
		 goto	enpwm
		bcf	LED_Port		;pnp
		goto	mainson 
enpwm		en_pwm
mainson		if_bit	MAINS_On
		 bcf	Relay_Port		;Pnp
		return

batADC	
		;eq_	ADCON0,=,b'00001101',lit8; left justified , AN3, on
		;dlay	6
		bsf	ADCON0,GO
		btfsc	ADCON0,GO
		 goto	$-1
		retlw	0
	
battery
		call	batADC
		clrf	BatAvr+1
		movfw	BatAvr
		addwf	BatAvr,F
		skpNC
		 incf	BatAvr+1,F
		addwf	BatAvr,F
		skpNC
		 incf	BatAvr+1,F
		movfw	ADRESH
		addwf	BatAvr,F
		skpNC
		 incf	BatAvr+1,F
		clrC
		rrf	BatAvr+1,F
		rrf	BatAvr,F
		clrC
		rrf	BatAvr+1,F
		rrf	BatAvr,F
		retlw 0		

	cblock
	 EnerLevel
	endc	
		
apbatt		if_not	AC_Detect
		 goto	disled
		 
		if_	BatAvr,<,0x88,	lit8	; >13.8V
		 goto	enled
		if_	BatAvr,<,0x8B,	lit8	; >13.6V hysteresis
		 goto	xitbat

disled		dis_pwm
		bcf	Stay_Awake
		goto	xitbat 

enled		en_pwm				 
		bsf	Stay_Awake 
		 
xitbat		retlw	0
						; if battery voltage > 14.7
						; switch on LED regardless, overloaded
		if_bit	Allw_OverV
		 goto	atstmaint
		if_	BatAvr,>,0x32,lit8
		 return				; wait for V > 14.7
		bsf	Allw_OverV	

mton		bsf  	Main_Tenance
		call	linearze
		en_pwm
		return
					; wait for next cycle
						; if overloaded and voltage > 13.8
						; switch on LED regardless
				
atstmaint
		if_	BatAvr,<,0x88,	lit8	; V > 13.8V
		 goto	inc_intsy


		if_	BatAvr,<,0x8B,	lit8	; V > 13.6V hysteresis
		 return				; do nothing
		movf	EnerLevel,F
		bZ	atoff

		decf	EnerLevel,F
		do_	PR2,=,PR2,+,1,	lit8
		do_	CCPR1L,=,CCPR1L,+,1,lit8	;pnp  
		return
	 
atoff		if_bit	LED_On
	 	 goto	atoff2
	 	dis_pwm
	 	bcf	Main_Tenance
atoff2		if_	BatAvr,>,0xB0,	lit8	
		 bcf	Allw_OverV		; 12.3V allow overload battery  
		return
	


		
inc_intsy	if_not	Main_Tenance
		 goto	mton

		if_	PR2,>,.18,	lit8
		 goto	ats4
		bcf	LED_On			; faulty / wrong battery
		bcf	Batt_Detect
			return
				 
ats4		incf	EnerLevel,F
		do_	PR2,=,PR2,-,1,lit8
		do_	CCPR1L,=,CCPR1L,-,1,lit8	;pnp 		
		return
		

	
slinear	
#define	howmany	1
#define lo1	0x32		; 14.7
#define rs1	0xFF
#define hi1	0xB6
#define rs2	.20
	variable  hicount
	; 11.9V	10110110   $B6
	; 12.6  10100101   $A5
	; 13.6  10001110   $8C
	; 14.1   1000011   $43	

	if_	STACK,<=,lo1,lit8
	 goto	lors1
	if_	STACK,>=,hi1,lit8
	 goto	hirs2
	clrf	STACK-1
	do_	STACK-2,=,STACK,-,lo1,lit8
	eq_	STACK,=,rs1,lit8
	if	(rs2-rs1) >0
hicount = (rs2-rs1)*.256 / (hi1-lo1)	

	else
hicount = (rs1-rs2)*.256 / (hi1-lo1)
	endif
	 movlw	hicount	& 0xFF	

adloop
	while	(hicount >> 8) > 0
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
hicount -= .256	
	endw
	addwf	STACK-1,F
	skpnC
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
	decfsz	STACK-2,F
	 goto adloop 
	return
lors1	eq_	STACK,=,rs1,lit8
	return
hirs2	 eq_	STACK,=,rs2,lit8
	return

linearze		
		eq_	STACK,=,BatAvr,	byte
		call	slinear
		eq_	PR2,=,STACK,	byte
		do_	CCPR1L,=,STACK,-,.10,lit8	;pnp
		bsf	PWM_On
	return

		 
	cblock
	 x
	endc
		 
#define	E1	0x1000		 
	eq_	x,=,.0,	(lit8)
;;
rpt	eq_	STACK,=,x,byte

	call	slinear
	e_q 	E1,[,x,byte,]=,STACK,byte
	incfsz	x,F
	 goto rpt
	goto $		
;;				
			
	end