;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 1..5 microseconds(depending on supply voltage 4.8-3V)   *
;*   at GPIO 2 Transistor output driver                                *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       G M DRYGAS                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros2c                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=10F206	; list directive to define processor
	#include  macros2c.asm
	config206
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************

	IFDEF __10F206
	cblock 0x08				; var starting at  0x08
		UprampTime:4
		

	endc
	ENDIF

	cblock 0x10
	shdw_TRISIO,SystemStatus,FlipDuty,Duty
	MaxTmr:2,TmrVector
	NoCounter,VoltMem

	endc
#define	STACK	0x1F

					; 
#define GPIOinit	b'00000000'	; all io initiate as LOW
#define TRISIOinit	b'11111010'	; configure NFET_Gate_Port as output 
#define	OPTIONinit	b'11000000'	; no wakup, no pullup, Clock 1:2

#define Dutyinit	.127
#define	NFET_Gate	2
#define TMR0IF	SystemStatus,0


	init206

start	eq	Duty,Dutyinit
	mov	Duty,FlipDuty
	bcf	GPIO,NFET_Gate
	settrap206B	1,msec,case0	
	goto	MAIN
;******************************************************************************
;Subroutines
;******************************************************************************

;******************************************************************************
;Subroutines
;******************************************************************************

#define	V11.0	b'01000000'
#define	V12.0	b'01100000'
#define V12.6	b'01110101'
#define	V13.7	b'10011110'
#define	V14.7	b'10101011'

vtable		addwf	PCL,F

		 retlw	V11.0
		 retlw  0xFE

		 retlw	V12.0
		 retlw	0xF0

		 retlw	V12.6
		 retlw	0x30

		 retlw  V13.7
		 retlw	0x10

		 retlw  V14.7
		 retlw	0x04
	
;******************************************************************************
;Subroutines
;******************************************************************************

calltrap	if_not	TMR0IF
		 retlw	0
		bcf	TMR0IF


cntdwn		decfsz	MaxTmr,F
		 retlw	0
		decfsz	MaxTmr+1,F
		 retlw	0
		movfw	TmrVector
		movwf	PCL

;******************************************************************************
;Subroutines
;******************************************************************************

		
case0		ADCON206B 0
		settrap206B	.500,usec,case1 
		retlw	0
;******************************************************************************
;Subroutines
;******************************************************************************




#define MdBndry	STACK-2
#define LoBndry	STACK-3
#define HiBndry	STACK-4

#define MdDuty	STACK-5
#define LoDuty	STACK-6
#define HiDuty	STACK-7
  

#define		BL	STACK-1
#define		AL	STACK
#define		AH	STACK-1


case1		eq	BL,.1
		GOTO	basesearch


;******************************************************************************
;Subroutines
;******************************************************************************


#define		DH	STACK-2		

#define		disport	1
displaybits	movlw	(1<<disport)
		iorwf	shdw_TRISIO,F
		movfw	shdw_TRISIO
		TRIS 	TRISGPIO	;GP1 input

		settrap206B	.5,sec, ff
		retlw	0

ff		eq	DH, .15
firstbit	movf	DH,F
		if_any AH, 7, STATUS, Z
		 goto nextbit-1
		clrC
		rlf	AL,F
		rlf	AH,F
		decf	DH,F
		goto	firstbit

		incf	DH,F
nextbit		clrC				;restore AL
		rlf	AL,F
		rlf	AH,F

		bcf	GPIO,disport		;red LED on
		movlw	((.200* .500 ) >> .16) +1
		skpC
		 goto	wdelay
		movlw	((.1000  * .500 ) >>.16) +1
		bsf	AL,0			;restore AL
		bsf	GPIO,disport		;green LED on

wdelay		movwf	MaxTmr+1
	
		movlw	0x0F -(1<<disport)
		andwf	shdw_TRISIO,F
		movfw	shdw_TRISIO
		TRIS 	TRISGPIO	;GPport outout

		movlw	offlight
		movwf	TmrVector
		retlw	0

offlight	movlw	(1<<disport)
		iorwf	shdw_TRISIO,F
		movfw	shdw_TRISIO
		TRIS 	TRISGPIO	;GPport input

		eq 	MaxTmr+1,((.200* .500 ) >> .16) +1
		if_	DH,not_eql,.9,	(byteconst)
		 goto	settmr
		 eq	MaxTmr+1,((.600* .500 ) >> .16) +1
settmr		movlw	morebits
		movwf	TmrVector
		retlw	0

morebits	decfsz	DH,F
		 goto nextbit
		settrap206B	1,msec,case0
		retlw	0


;******************************************************************************
;Subroutine: control voltage of battery
;******************************************************************************


cntrlV
	if_	AL,lss,V11.0,		(byteconst);undervoltage
	 goto	slpy
	if_	AL,lss,.255,		(byteconst); overvoltage
	 goto	ok_V

	settrap206B	2,msec,cntrlV
cincDty	if_	Duty,grtr,.127,		(byteconst)
          retlw	0

incDuty	bcf 	STATUS,C
	if_	Duty,not_eql,FlipDuty,	(byte)
	 bsf	STATUS,C

	incf	Duty,F
	if_NC	
	 incf	FlipDuty,F
	if_C	
	 decf	FlipDuty,F
	retlw	0			

deccDuty	bcf 	STATUS,C
	if_	Duty,not_eql,FlipDuty,	(byte)
	 bsf	STATUS,C

	decf	Duty,F
	if_C	
	 incf	FlipDuty,F
	if_NC	
	 decf	FlipDuty,F
	retlw	0	



slpy	if_not	GPIO,NFET_Gate
	 sleep
	bcf	GPIO,NFET_Gate
	mov	Duty,FlipDuty
	sleep

afterwdt	call	case0	;ADC0
;	clrf	AH
;	call displaybits
	if_	AL,lss,V12.0,		(byteconst)
	 goto	slpy
	goto	cntrlV
					;emergency stop


ok_V	;if_	AL,lss,(V12.0+V13.7 )/2, (byteconst)
	; clrf	Vcase
	;if_bit	Lamp_on		; lamp on?
	; goto	case1


Vcharge	
	settrap206B	.16,sec,Vcharge
	if_	AL,lss,V14.7,	(byteconst)
	 goto	moreadc
	if_	AL,grtr,VoltMem,(byte)
	 goto	moreadc
	decfsz	NoCounter,F
	 goto	try10	

	eq	NoCounter,.2
	eq	Duty,.3
	movwf	FlipDuty
	settrap206B	.5,msec,Vhold

moreadc	mov	AL,VoltMem
	eq	NoCounter,.10
try10	
	retlw	0


Vhold   settrap206B	.500,msec,Vhold

	if_	AL,lss,V13.7-.2,	(byteconst)
	 goto	Vrecharge

	if_ 	AL,grtr_eql,VoltMem,	(byte)
	 goto	cincDty
	mov	AL,VoltMem
	retlw 0


	
Vrecharge 
	settrap206B	.500,msec,Vrecharge
	if_	AL,grtr,VoltMem	,	(byte)
	 goto	risingV
	if_	Duty,lss,.1,		(byteconst)
	 goto	risingV

risingV	mov	AL,VoltMem
	if_	AL,lss,V13.7+3,		(byteconst)
	 goto	moreadc	

	goto	Vhold


		

MAIN	btfsc	TMR0,7
	 goto	$-1
flip	movlw	1<<NFET_Gate
	xorwf	GPIO,F
	if__	TMR0IF,not_but, GPIO,NFET_Gate
	 bsf	TMR0IF
	clrwdt
	comf	FlipDuty,F
	movfw	FlipDuty
	movwf	TMR0

	btfsc	TMR0,7		; smaller cycle (needs 1:2 prescale)
	 goto	MAIN		

	call	calltrap	; now is time for 256cycles


#define nega_bit SystemStatus,1
#define go_dwn	SystemStatus,2


updown
	bcf nega_bit
	if_	Duty,not_eql,FlipDuty,	(byte)
	 bsf	nega_bit

	if_bit	go_dwn
	 goto	neg	
	incf	Duty,F
	if_not	nega_bit	
	 incf	FlipDuty,F
	if_bit	nega_bit	
	 decf	FlipDuty,F
	if_	Duty,grtr,.252,		(byteconst)
	 bsf	go_dwn
	 goto	enupdn
neg	decf	Duty,F
	if_not	nega_bit	
	 decf	FlipDuty,F
	if_bit	nega_bit	
	 incf	FlipDuty,F
	if_	Duty,lss,.4,		(byteconst)
	 bcf	go_dwn
enupdn


	btfss	TMR0,7		
	 goto	$-1
	 goto	MAIN




basesearch	if_	BL,grtr,.9,	(byteconst)
		 goto	over147
		 
		incf	BL,F
		movfw	BL
		call	vtable
		movwf	HiBndry

;		incf	BL,F
;		movfw	BL
;		call	vtable
;		movwf	CH
;
		incf	BL,F
		movfw	BL
		call	vtable
		movwf	HiDuty
	
;		incf	BL,F
;		movfw	BL
;		call	vtable
;		movwf	DH
;
		if_ 	AL,grtr,HiBndry,		(byte)
                 goto	basesearch
		
		decl	BL,.3
		movfw	BL
		call	vtable
		movwf	LoBndry

;		incf	BL,F
;		movfw	BL
;		call	vtable
;		movwf	
;
;
		incf	BL,F
		movfw	BL	
		call	vtable
		movwf	LoDuty

	
;		incf	BL,F
;		movfw	BL
;		call	vtable
;		movwf	DLH+1

		if_	AL,lss,LoBndry,			(byte)
		 goto	xitcase1
binsearch	ar_	MdBndry,LoBndry,plus,HiBndry,	(byte)
		rrf	MdBndry,F
		ar_	MdDuty,LoDuty,plus,HiDuty,	(byte)
		rrf	MdDuty,F
		if_	AL,eql,MdBndry	,		(byte)
		 goto	xit
		
		if_	AL,grtr,MdBndry,		(byte)
		 goto	higher

		mov	MdBndry,HiBndry
		mov	MdDuty,HiDuty
		goto	binsearch
higher		mov	MdBndry,LoBndry
		mov	MdDuty,LoDuty
		goto	binsearch
		incf	BL,F
xit		
		if_	Duty,not_eql,FlipDuty	,	(byte)
		 goto	negative
		mov	MdDuty,Duty
		mov	MdDuty,FlipDuty
	        goto	xitcase1
negative	mov	MdDuty,Duty
		comf	Duty,W
		movwf	FlipDuty
		

xitcase1
		settrap206B	.500,usec,displaybits		
		retlw	0


over147		eq	Duty,.3			
		goto	xit





	end