;****************************************************************************************
;*   This file is the firmware to implement a LED and AC lamp switch, based on 		*
;*   the PIC12F683.  It monitors the zero crossing of the AC waveform,    the ambient   *
;*   light, the battery voltage and the flicking of a PIR sensor
;*   and drives a relay to switch the mains light or the LED light     *
;*                                                                			*
;*                                                                     			*
;*   Control is accomplished through one or more interruptions of power to the circuit,	*
;*   which causes a certain sequence of effects                		             	*
;*          			                                                        *
;*             light	   duration  interrupt   timeout                                *
;*    LDR senses "dark"       	       within      goto		                        *
;*					goto            				*             
;*    c0:      LED	   forever      c1        loop                          	*
;*    c1:      MAINS        5 sec  	c0	  c2                   	                *
;*    c2:      MAINS       10 sec       c4        c3               			*
;*    c3:      MAINS	   15 min 	c0        c0                			*
;*    c4:      MAINS	  120 min	c0        c0           				*
;*    		                        						*
;*											*
;*                                   							*
;*    "When it is dark, you will switch on LEDs, by interrrupting shortly you switch    *
;*     on MAINS for fifteen minutes, by waiting about ten seconds and interrupting      *
;*     then, you switch on MAINS 2 hours. If you interrupt a second time       		*
;*     without waiting, you will toggle between MAINS and LED light"                    *
;*          			                                                        *
;*             light	   duration  interrupt   timeout                                *
;*    LDR senses "dim or bright"       within      goto		                        *
;*					goto                         			*
;*    6:       MAINS        5 sec       c0   	   c7					*
;*    7:       MAINS       10 sec       c9         c8       				*
;*    8:       MAINS      120 min       c0         c0    				*
;*    9:       MAINS       15 sec       c0         c10					*
;*    10:      DIM LED     15 sec	c0         until dark:c11			*
;*    11:      MAINS     180-240 min    c0         c12					*
;*    12       DIM LED    120 min	c0         c13					*
;*    13:      DIM LED	   15 sec	c0	   until bright:c10			*
;*                                               					*
;*    "When it is not very dark, you will switch on then MAINS for 120 minutes. If	*
;*     you wait for 10 seconds and interrupt shortly, then lamp will go into 		*
;*    'goodnight' (burglar deterrent) mode. If you interrupt without waiting, you will 	*
;*     toggle between MAINS and LED mode. 'Goodnight' mode will wait until it becomes 	*
;*     dark, switch on the MAINS light and wait for a random time of 3 to 4 hours	*
;*     until it switches off."                                                          *
;*     											*
;*    "If you are unsure what mode the lamp is in, switch off for ten seconds to 	*
;*     restart"										*
;*											*
;*   GPIO 0 LDR sensor                   						*
;*   GPIO 1 relay output driver via transistor            				*
;*   GPIO 2 LED output driver via transistor                                 		*
;*   GPIO 3 zero cross detection input                   			        *
;*   GPIO 4 battery voltage sensor                      			        *
;*   GPIO 5 PIR detection input                   			        	*
;*                                                                     			*
;*   Refer to the MPASM User's Guide for additional information on     			*
;*   features of the assembler (Document DS33014).                     			*
;*                                                                     			*
;*   Refer to the respective PICmicro data sheet for additional        			*
;*   information on the instruction set.                               			*
;*                                                                     			*
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    uni683.asm                              		                *
;*    Date:         OCtober, 2009                                    			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael Drygas                                      		*
;*                  Applications Engineer                    				*
;*    Company:      MICHAELS Unternehmergesellschaft(haftungsbeschrnkt)                *
;*                                                                     			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   macros3b.asm                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*			\5\trafo-HU5-6-2t.brd         					*
;*                               							*
;*                                                                     			*
;*                  matching \5\smd+6+16.brd           					*
;*                                                                     			*
;****************************************************************************************
