;***********************************************************************
;*   This file is the firmware to implement                        *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       G M DRYGAS                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=10F206	; list directive to define processor
	#include  ..\macros3c.asm
	config206B		; WDT ON
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************

	cblock _MINRAM 
	 CountS 

	endc
#define STACK	_MAXRAM

#define GPIOinit	b'00000000'	; all OUTPUT initiate as HIGH
#define TRISIOinit	b'11111001'	; configure GP1,2 as output 
#define	OPTIONinit	b'11111000'	; no wakup, no pullup, source comparator Clock 1:1
#define CMCON0init	b'00001011'     ; inverted,sourceTMR0,on,0.6V-, GP0+ 
;#define	ADCON0init	b'01000001'	; gP0 analog, chanel 00,enable
;#define	ADCON0init	b'10000101'	; gP1 analog, chanel 01,enable


	init2xx
	movlw	b'11111100'	; no wakup, no pullup, source comparator WDT 1:32
cycle	OPTION
	sleep		; wait 16msec*32

outputbaud			; variable to output @FSR	
#define port 1
	setC
	clrf	STACK-1

baudnextbit	
		
	movfw	GPIO
	movwf	STACK
	movfw	STACK-1
	andwf	INDF,W
	if_Z			
	 bsf	STACK,port	;NPN
	if_NZ
	 bcf	STACK,port	;NPN
	movfw	STACK
	movwf	GPIO			; electrical change occurs now

;	btfss	x,3			; adjust timing 57600baud = 17.36us
;	 goto	noextradelay			; call	zerocall
;	goto	$+1			; bit 3 is 3 cycles longer
;	goto	$+1
;noextradelay
#define	looptime .17
	delay 	.26-looptime		; delay to adjust for other baud rates
	
	rlf	STACK-1,F
	skpC	
	 goto   baudnextbit
	delay	.17-.6			; last data bit (adjust for other bauds)

	bcf	GPIO,port		; start of stop bit (NPN transistor)
	retlw 0


afterwdt 
	movlw	b'11111000'	; no wakup, no pullup, source comparator Clock 1:1
	OPTION
	clrf	TMR0
	bsf	CMCON0,CMPON	; oscillator on
	delay	.255			;look for minimum value without TMR0 overflow
	bcf	CMCON0,CMPON	; stop oscillator

	eq_	CountS,=,TMR0,	byte	
	eq_	FSR,=,CountS,	lit8
	call	outputbaud

	goto	cycle
	
	

	end