;****************************************************************************************
;*   This file is the firmware to implement 
;*	2 timers, which on expiration can trigger 16 different single event routines
;*      furthermore the possibility of insertion of code into periodic routines 
;*	which occur every 64 microseconds, 8 milliseconds, 2 seconds and 16 seconds
;*
;*   Refer to the MPASM User's Guide for additional information on     			*
;*   features of the assembler (Document DS33014).                     			*
;*                                                                     			*
;*   Refer to the respective PICmicro data sheet for additional        			*
;*   information on the instruction set.                               			*
;*                                                                     			*
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    MICROCHIP OS for 12F2xx.asm                              		                *
;*    Date:         December, 2009                                    			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael Drygas                                      		*
;*                  Applications Engineer                    				*
;*    Company:      MICHAELS Unternehmergesellschaft(haftungsbeschrnkt)                *
;*                  EU TAX ID  263676163                               			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   m0-3.asm (macros)                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*		         					*
;*                                                                     			*
;****************************************************************************************
	list      p=10F200	; list directive to define processor
	#include  m0-3.asm
	config_
 	
#define	OPTIONinit	b'11000100'	; no wakup, no pullup, Clock 1:32
#define TRISIOinit 	b'00001011'	; all ports input bar GP2	
#define GPIOinit 	b'00000000'	; GPIO  all LOW 
;****************************************************************************************

	init_			; reasonable initiation of special function registers 


	cblock	_MINRAM			; start of variables
	 SyS1,SyS2,Count
	endc
#define STACK		_MAXRAM

    eq_  Count,=,.120, lit8
main
    delay .60000000
    decfsz  Count,f
     goto main
	bsf GPIO,2
    goto $
		end