;****************************************************************************************
 ;                          			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   m0-3.asm (macros)                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*		         					*
;*                                                                     			*
;****************************************************************************************
	list      p=10F200	; list directive to define processor
	#include  ..\m0-3.asm
	config_
 	
#define	OPTIONinit	b'11000111'	; no wakup, no pullup, Clock 1:256
#define TRISIOinit 	b'00001011'	; all ports output bar GP3	
#define GPIOinit 	b'00000000'	; GPIO  all LOW 
;****************************************************************************************

	init_			; reasonable initiation of special function registers 


	cblock	_MINRAM			; start of variables
	 Sys1,Tck,FlipDty,PR_Duty:2,Avr:2,Vta,TMR0save,TMR0high,Case
	endc
#define STACK		_MAXRAM
#define ShdGP3		Sys1,3
#define nega_bit	Sys1,0
#define	TMR07Bit	Sys1,7

#define OUTP		2
	goto RESET1

tick
	decfsz	Tck,F
	 goto noflip
    
	do_		GPIO,=,GPIO,XOR,1<<OUTP,	lit8
	comf	FlipDty,F
	eq_		Tck,=,FlipDty,byte
    RETLW 0
noflip
    goto $+1
    goto $+1
	nop
    RETLW 0

avrof4		clrf	Avr+1
		movfw	INDF
		addwf	INDF,F
		skpNC
		 incf	Avr+1,F
		addwf	INDF,F
		skpNC
		 incf	Avr+1,F
		movfw	Vta		; Value to add
		addwf	INDF,F
		skpNC
		 incf	Avr+1,F

		clrC
		rrf	Avr+1,F
		rrf	INDF,F
		clrC
		rrf	Avr+1,F
		rrf	INDF,F		; result in INDF

		retlw 0	


RESET1
	eq_		PR_Duty,=,.254,lit8
	movwf	FlipDty
	movwf	Tck
	movwf	Avr
	bcf		GPIO,OUTP
    movlw	case0
	movwf	Case
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
main


   if_m	TMR0,!=,TMR0save, byte
    eq_ TMR0save,=,TMR0,byte
	
	

	eq_	PCL,=,Case,byte
case0
	movlw	case1			;wait until GP3 high or reset
	if_ GPIO,3,is_on,1
      movwf	Case
    goto endcase
case1
    movlw 	case2
    if_ GPIO,3,is_on,1
     goto endcase
    clrf	TMR0
	clrf	TMR0high
	bcf		TMR07Bit
	movwf	Case
    goto	endcase+2
case2
	movlw	case3
	if_ GPIO,3,is_off,1 
	  goto endcase
    clrf	TMR0			; store GP3 high time
	clrf	TMR0high
	bcf		TMR07Bit
      movwf	Case
    goto endcase+2			
case3
	nop
	if_ GPIO,3,is_on,1	 
     goto endcase

						; store GP3 low time
;    bcf	nega_bit
;	 if_ PR_Duty,!=,FlipDty,byte
;         bsf nega_bit
;	 eq_	PR_Duty,=,TMR0,byte
;     eq_	PR_Duty+1,=,TMR0high,byte
;	 clrC		
;     rrf	PR_Duty+1,f
;	 rrf	PR_Duty,f
;	 clrC		
;     rrf	PR_Duty+1,f
;	 rrf	   PR_Duty,f
;	clrC		
;     rrf	PR_Duty+1,f
;	 rrf	PR_Duty,f			; div 8	
;	eq_		Vta,=,PR_Duty,	byte;
;
;	call tick	
;;
;	
;;
;		movlw	Avr
;		movwf	FSR
;		call	avrof4
;		call tick
;
;		call	ldrADC
;		call	tick
;		call	avrof4
;	call tick
;
;
;
;	 movfw	Avr
;     if_	nega_bit,is_on,singlebit
;        comf	Avr,W
; 	 movwf	FlipDty

	eq_		PR_Duty,=,.234,lit8
	movwf	FlipDty
	movwf	Tck
	movwf	Avr
	bcf		GPIO,OUTP
    movlw	case0
	movwf	Case

    clrf	TMR0			; store ontime
	clrf	TMR0high
	bcf		TMR07Bit

     movlw	case0
     movwf	Case
     
  else_m
endcase
	nop
	goto $+1
	goto $+1
  end_m


loop		; 9 usec
	if_	    TMR0,7,is_on, singlebit			; software emulation of
	 goto	set7			; timer 0 overflow
	if_not	TMR07Bit		;
	 goto	set71
	bcf	TMR07Bit
	if_ TMR0high,==,7,lit8
	 goto RESET1
    incf	TMR0high,f
    goto	set72
set7
    nop	
	bsf	TMR07Bit   
set71
;    goto	$+1
;    goto	$+1		; for perfect timing
;    goto	$+1
    goto	$+1
set72
 ;goto loop
	call tick
	goto main

		end