;****************************************************************************************
 ;                          			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   m0-3.asm (macros)                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*		         					*
;*                                                                     			*
;****************************************************************************************
	list      p=10F222	; list directive to define processor
	#include  ..\m0-3.asm
	config_
 	
#define	OPTIONinit	b'11000111'	; no wakup, no pullup, Clock 1:256
#define TRISIOinit 	b'00001011'	; all ports output bar GP3	
#define GPIOinit 	b'00000000'	; GPIO  all LOW 
;****************************************************************************************

	cblock	_MINRAM			; start of variables
	Sys1,Tck,FlipDty,PR_Duty:2,Avr:2,Vta
	TMR0save,TMR0high,T0S:2,T1S:2
	endc


	init_			; reasonable initiation of special function registers 


	
#define STACK		_MAXRAM
#define ShdGP3		Sys1,3
#define RGP3		Sys1,4
#define cfRESET		Sys1,5
#define nega_bit	Sys1,0
#define	TMR07Bit	Sys1,7

#define OUTP		2
	goto RESET1

tick
	decfsz	Tck,F
	 goto noflip
    
	do_		GPIO,=,GPIO,XOR,1<<OUTP,	lit8
	comf	FlipDty,F
	eq_		Tck,=,FlipDty,byte
    RETLW 0
noflip
    goto $+1
    goto $+1

    RETLW 0

avrof4		clrf	Avr+1
		movfw	INDF
		addwf	INDF,F
		skpNC
		 incf	Avr+1,F
		addwf	INDF,F
		skpNC
		 incf	Avr+1,F
		movfw	Vta		; Value to add
		addwf	INDF,F
		skpNC
		 incf	Avr+1,F

		clrC
		rrf	Avr+1,F
		rrf	INDF,F
		clrC
		rrf	Avr+1,F
		rrf	INDF,F		; result in INDF

		retlw 0	


RESET1
	eq_		PR_Duty,=,.254,lit8
	movwf	FlipDty
	movwf	Tck
	movwf	Avr
	bcf		GPIO,OUTP
	eq__	RGP3,=,GPIO,3
	clrf	TMR0high
	bsf		cfRESET

	goto	$+1	
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
main
	CALL	tick 					;11 us
   	if_	TMR0,==,TMR0save, byte
      goto main-8

   	eq_ 	TMR0save,=,TMR0,byte

	movf	TMR0,F
	if_Z_m	
      incf 	TMR0high,F
	  if_ TMR0high,<=,.70,lit8
        goto main-3
      clrf	TMR0high

	  if_m PR_Duty,==,FlipDty,byte
	    do_	PR_Duty,=,PR_Duty,-,8,lit8
 	    eq_	FlipDty,=,PR_Duty,byte
        goto	main
	  else_m	
      	do_	PR_Duty,=,PR_Duty,-,8,lit8
 	    comf	PR_Duty,W
		movwf	FlipDty
        goto	main
	  end_m
    end_m						;7us

	eq__	ShdGP3,=,GPIO,3
;	if__	RGP3,equal,ShdGP3
	nop
	  goto main-2
		end