;****************************************************************************************
;*   This file is the firmware to implement 
;*	 1 timer, which on expiration can trigger 16 different single event routines
;*      furthermore the possibility of insertion of code into periodic routines 
;*	which occur every  8 milliseconds, 2 seconds and 16 seconds
;*
;*   Refer to the MPASM User's Guide for additional information on     			*
;*   features of the assembler (Document DS33014).                     			*
;*                                                                     			*
;*   Refer to the respective PICmicro data sheet for additional        			*
;*   information on the instruction set.                               			*
;*                                                                     			*
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    MICROCHIP OS for 10F200  .asm                              		                *
;*    Date:         December, 2009                                    			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael Drygas                                      		*
;*                  Applications Engineer                    				*
;*    Company:      MICHAELS Unternehmergesellschaft(haftungsbeschrnkt)                *
;*                  EU TAX ID  263676163                               			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   m0-3.asm (macros)                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 	RGB led on GP0,1,2          							*
;*		         					*
;*                                                                     			*
;****************************************************************************************
	list      p=10F206	        ; list directive to define processor
	#include  m0-3.asm
	config_
 	
#define OPTIONinit	b'11000101'	; no wakeup, no pullup, Clock 1:64 (60Hz)
#define TRISIOinit 	b'00001000'	; all ports output bar GP3	
#define GPIOinit 	b'00000111'	; GPIO  all HI
;****************************************************************************************


	init_			; reasonable initiation of special function registers 


	cblock	_MINRAM			; start of variables
	 SyS1       ;,SyS2
     dir,rgb
	endc


#define STACK		_MAXRAM

#define	Mi_Nus	SyS1,0
#define	Low_Detect	SyS1,1
#define	TMR07Bit	SyS1,7
	

;PWRUP	
		eq_ SyS1,=,0,               lit8
		eq_	dir,=,.16,              lit8
        eq_ rgb,=,0,                lit8

TC0used = 2					        ; use 2 bytes of timer for TC0
	cblock
	 TC0:TC0used
	 NmbrEvent0
	endc	 
		EVENT0in	.500,msec,.15   ; set time @ 500 milliseconds
;		clrf	NmbrEvent0		    ; set execution  for EVENT0

;TC1used = 2
;	cblock
;	 TC1:TC1used,NmbrEvent1
;	endc
;		EVENT1in	1,msec,.15	     ;EVENT15 in 1 msec, goto MLOOP	 

JMPTable	andlw	0x0F
		addwf	PCL,F
		 goto	EVENT0	
		 goto	EVENT1
		 goto	EVENT2	
		 goto	EVENT3
		 goto	EVENT4
		 goto	EVENT5
		 goto	EVENT6
		 goto	EVENT7
		 goto	EVENT8
		 goto	EVENT9
		 goto	EVENT10
		 goto	EVENT11
		 goto	EVENT12
		 goto	EVENT13
		 goto	EVENT14
		 goto	EVENT15


tabca   addwf PCL,f  
    dt  .127 ,  .0,  .0     ;0
    dt  .150 , .20 , .0     ;1
    dt  .175 , .61,  .0     ;2
	dt  .209 ,.105,  .0     ;3
	dt  .199 ,.155,  .0     ;4
    dt  .173 ,.205,  .0     ;5
    dt   .50 ,.235, .16     ;6
    dt   .38 ,.245, .38     ;7
    dt   .25 ,.250, .98     ;8

    dt   .19 ,.254,.158     ;9  
    dt   .21 ,.180,.200     ;10
 

    dt   .37 , .86,.225     ;12
    dt   .88 , .40,.240     ;13

    dt  .135 , .68,.250     ;14
    dt  .235 , .98,.255     ;14
    dt  .245 ,.255,.255     ;15
    dt  .255 ,.255,.255     ;15


	cblock
	 oldtmr0,RedPoint,GreenPoint,BluePoint,oldrgb,pollrgb
	endc
;
onepoint   
        movwf   STACK
        swapf   rgb,w
        andlw   0x0F
        addwf   STACK,F
        addwf   STACK,F
        addwf   STACK,F
        movfw   STACK
        call tabca
        movwf  INDF
        swapf   rgb,w
        andlw   0xF0
        movwf   STACK-1
        do_     STACK,=,STACK,+,3, lit8
        movfw   STACK
        call tabca
        subwf   INDF,W
        movwf   STACK
        if_Z
         goto   clerC
        if_C
         bsf Mi_Nus
        if_NC
clerC     bcf Mi_Nus
        comf    STACK,F
        incf    STACK,F
rlfstack
       rrf     SyS1,W     ; load Carry with bit minus
       rrf     STACK,f
       movfw   STACK
       clrC
       rlf     STACK-1,f
       if_C
         addwf INDF,f
       movf    STACK-1,f
       if_NZ 
         goto rlfstack

        retlw 0


#define Red_LED GPIO,0
#define Green_LED GPIO,1
#define Blue_LED GPIO,2

swchoff
                                             ;        
         if_ TMR0,>=,RedPoint,byte  
               bsf Red_LED        
         if_ TMR0,>=,GreenPoint,byte  
               bsf Green_LED
         if_ TMR0,>=,BluePoint,byte  
               bsf Blue_LED
                                            ;
        retlw   0

colortable
        eq_  FSR,=,RedPoint,lit8
        movlw  0
        call   onepoint
        call    swchoff
        eq_  FSR,=,GreenPoint,lit8
        movlw  1
        call   onepoint
        call    swchoff        
        eq_  FSR,=,BluePoint,lit8
        movlw  2
        call   onepoint
        call    swchoff
        goto returnpoint        ;<<<<<<<<<<<<<<<<<<<<<<<<<<<<dontforget   
;
;        if__m   TMR00Bit,not_but,TMR0,0
;          bsf   TMR00Bit
;          goto  exec256us
;        end_m
;        if__m   TMR0,0,not_but,TMR00Bit
;          bcf   TMR00Bit
;          goto  exec256us
;        end_m
;        goto    no256us


;	org	0x100


;#define	TMR00Bit	SyS1,0	
MLOOP	clrwdt
                                                ;
;         if_m oldtmr0 = green                      
;            clr grnbit
;         if_ oldtmr0 = blue
;            clr bluebit
;        end_m                                     ; oldtmr > 0
; 
;         if_m rgb,!=, oldrgb,        byte
;           eq_ oldrgb,=,rgb,        byte
;           goto colortable
;returnpoint
;        end_m
;    
;       if_m LoW_Detect             ; single port capacitor charge over resistor, 
                                    ; 1bit at xxxus total 256x256us=64ms
;       if_m GPIO,3,is_on, singlebit
;store     eq_  rgb,=, pollrgb, byte
;        comf pollrgb,f
;        incf pollrgb,f
;        bcf Low_Detect
;      else_m
;        incfsz pollrgb,f
;           goto $+2
;         goto store
;      end_m

;       if__m   Low_Detect,is_on          ;1- wire style serial input 1 start bit, 8 data bit @ 256 us
;         eq__   STATUS,C =,gpio,3,            ; MSB first
 ;        rlf    pollrgb
;         if_C_m 
;           bcf  Low_Detect
;          
;           eq_ rgb, = ,pollrgb,byte
;         end_m
;        else_m
;          if_m gpio,3,is_off, 1
;           setC
;           clrf pollrgb
;           rlf pollrgb
;           bsf Low_Detect
;          end_m
;        end_m
                                           
    call    swchoff
no256us	
	if_ 	TMR0,7,is_on,1			; software emulation of
	 goto	set7			        ; timer 0 overflow of any bit
	if_  	TMR07Bit,is_off,1		;
	 goto	set7+1
    bcf     TMR07Bit

    clrf  GPIO                      ; all LEDs on
    call    swchoff
;	if_not	INTCON,T0IF		        ; wait for timer TMR0 to time out
;	 goto	MLOOP
;	bcf	INTCON,T0IF			
;	goto	PERIODIC8		        ; which is 256*64 us =8 milliseconds
exitPERIODIC8
;
	decfsz	TC0,F
	 goto	endMLOOP0
;	goto	PERIODIC2048		    ; after first TC0 expired, 2048 milliseconds 
exitPERIODIC2048			        ; have passed
	if TC0used > 1
;	movlw	0x07			        ;example for very long periodic events
;	andwf	TC0+1,W
;	movwf	STACK
;	movlw	-7
;	addwf	STACK,W
;	skpnZ
;	 goto	PERIODIC16sec		    ; every 16 seconds (Event0 must be later!)
exitPERIODIC16sec
	decfsz	TC0+1,F
	 goto	endMLOOP0
	endif
					                ; after TC0+1 expired, 8 minutes 44 seconds
	if TC0used > 2			        ; have passed
	decfsz	TC0+2,F
	 goto	endMLOOP0
	endif 

	movfw	NmbrEvent0		        ; after TC0+2 expired, 37 hours 17 minutes
	goto	JMPTable 		        ; now jump to loaded Event
	 
endMLOOP0				        ; and continue execution here	 
end0MLOOP0
    if TC1used>0
	 decfsz	TC1,F			        ; analogous as TC0
	  goto	endMLOOP1
    else 
     goto endMLOOP1
    endif
	if TC1used > 1
	decfsz	TC1+1,F
	 goto	endMLOOP1
	endif
	if TC1used > 2
	decfsz	TC1+2,F
	 goto	endMLOOP1
	endif
    if TC1used > 0 
	movfw	NmbrEvent1
	goto	JMPTable 
	endif 
	 
set7	bsf	TMR07Bit	
endMLOOP1	goto	MLOOP

;	org	0x200
;PERIODIC64usec			
;       

;		goto	exitPERIODIC64usec

PERIODIC8
		goto	exitPERIODIC8			

PERIODIC2048	
		goto	exitPERIODIC2048
		
PERIODIC16sec	
		goto	exitPERIODIC16sec	
				 
EVENT0		
		
EVENT1	

EVENT2			
		
EVENT3
		 
EVENT4		

EVENT5		
		
EVENT6	

EVENT7		

EVENT8		

EVENT9		

EVENT10		

EVENT11		


EVENT12	
		EVENT0in .60,sec,0	;loop

EVENT13


EVENT14 

   
EVENT15 
        do_  rgb,=,rgb,+,dir,   byte
        if_m rgb,<,.8,          lit8
           eq_ dir,=,.2,       lit8
        end_m                   
;         
        if_m  rgb,>=,.248,      lit8
           eq_ dir,=,.256-.2,  lit8  
        end_m

           goto colortable
returnpoint

;		EVENT0in 2,sec,.15	

;       do_       BluePoint,=,BluePoint,+,dir,  byte
        EVENT0in .1500,msec,.15


		end