;****************************************************************************************
;*   This file is the firmware to implement 
;*	2 timers, which on expiration can trigger 16 different single event routines
;*      furthermore the possibility of insertion of code into periodic routines 
;*	which occur every 64 microseconds, 8 milliseconds, 2 seconds and 16 seconds
;*
;*   Refer to the MPASM User's Guide for additional information on     			*
;*   features of the assembler (Document DS33014).                     			*
;*                                                                     			*
;*   Refer to the respective PICmicro data sheet for additional        			*
;*   information on the instruction set.                               			*
;*                                                                     			*
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    MICROCHIP OS for 10F200  .asm                              		                *
;*    Date:         December, 2009                                    			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael Drygas                                      		*
;*                  Applications Engineer                    				*
;*    Company:      MICHAELS Unternehmergesellschaft(haftungsbeschrnkt)                *
;*                  EU TAX ID  263676163                               			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   m0-1.asm (macros)                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*		         					*
;*                                                                     			*
;****************************************************************************************
	list      p=10F200	; list directive to define processor
	#include  m0-4.asm
	config200
 	
#define	OPTIONinit	b'11000100'	; no wakup, no pullup, Clock 1:32
#define TRISIOinit 	b'00001011'	; all ports input bar GP2	
;#define GPIOinit 	b'00000000'	; GPIO  all LOW 
;****************************************************************************************
    

	init2xx			; reasonable initiation of special function registers 


	cblock	_MINRAM			; start of variables
	 SyS1,SyS2
	endc

	#define bit1	SyS1,1
	#define bit2	SyS2,2

#define STACK		_MAXRAM
;							not_but    (0) : base1,bit1 = false and  base2,bit2 = true  
;                           and        (1) : base1,bit1 = true  and  base2,bit2 = true
;                           nor        (2) : base1,bit1 = false and  base2,bit2 = false
;                           or_not     (3) : base1,bit1 = true  or   base2,bit2 = false
;                           or         (4) : base1,bit1 = true  or   base2,bit2 = true
;                           not_or_not (5) : base1,bit1 = false or   base2,bit2 = false
;                           either_or  (6) : base1,bit1 not equal base2,bit2 
;                           equal      (7) : base1,bit1  equal    base2,bit2
	if__	bit1,not_but,bit2
		nop
	if__m	bit1,not_but,bit2
		nop
	end_m
	if__	bit1,and,bit2
		nop
	if__m	bit1,and,bit2
		nop
	end_m

	if__	bit1,nor,bit2
		nop
	if__m	bit1,nor,bit2
		nop
	end_m
	if__	bit1,or_not,bit2
		nop
	if__m	bit1,or_not,bit2
		nop
	end_m
	if__	bit1,or,bit2
		nop
	if__m	bit1,or,bit2
		nop
	end_m
	if__	bit1,not_or_not,bit2
		nop
	if__m	bit1,not_or_not,bit2
		nop
	end_m
	if__	bit1,either_or,bit2
		nop
	if__m	bit1,either_or,bit2
		nop
	end_m
	if__	bit1,equal,bit2
		nop
	if__m	bit1,equal,bit2
		nop
	end_m
		end