{$M $4000,0,655360 }
unit xEdt;
 (*  *)


interface

const
 EdtX1          : Byte = 1;
 EdtY1          : Byte = 1;
 EdtX2          : Byte = 78;
 EdtTop         : String = 'X-Editor';
var
 esc_with       : Byte;
 errorlevel     : word;



procedure TextEdit(filename : String);

implementation

uses

 dos,crt,screen,searchi;
const
 reihen         = 255;
 inhsize        = MaxInt;
 maxwindh       = 4096;
 maxvarlen      = 10;
 allmaxdta      = 1024;
 maxfil         = 1;
type
 workstring     = String[reihen];
 Pworkstring    = ^workstring;
 inhbuftyp      = array[1..inhsize] of Char;
 pinhbuf        = ^inhbuftyp;
 inhtyp         = array[1..maxwindh] of Pworkstring;
 pinhtyp        = ^inhtyp;
 varstring      = String[maxvarlen];


type
 StatString     = String[255];
 DynString      = ^StatString;

type
 seek_or_ptr    =record case integer of
                       0 : (Zeile: DynString);
                       1:  (seeknr: longint);
                     end;
 TextListe      = ^TextZeile;     (* TextListe ist eine doppelt *)
 TextZeile      = record          (* verkettete Liste           *)
                   sptr           : seek_or_ptr;
                   Vor, Rueck     : TextListe;
                   ifseek :word;
                  end;

const
 edited         : Boolean = False;
 {no_pv          :boolean = false;}
var
 internfile:string;


 function MaxX  : Byte;
 begin
  MaxX := Succ(Lo(WindMax) - Lo(WindMin));
 end;

 function MaxY  : Byte;
 begin
  MaxY := Succ(Hi(WindMax) - Hi(WindMin));
 end;

 procedure clreol;
 var
  x, y           : Byte;
 begin
  x := wherex;
  y := wherey;
  Write('':Succ(MaxX) - x);
  gotoxy(x, y);
 end;



 procedure LiesZeichen(var c : Char);
 var
  fntast         : Byte;
  count :word;
 begin
  repeat
  until keypressed;
    keyboardinput(c, fntast);

 end;
 (* $I RPEDT.DOC *)


 procedure NeuerText(var t : TextListe); (* Initialisierung *)
 begin
  t := nil;
 end;

 function DynStringLength(D : DynString) : Integer;
 begin
  DynStringLength := Ord(D^[0])
 end;                             (* DynStringLength *)

 procedure MakeDynString(S : StatString; var D : DynString);
 var
  l              : Byte absolute S;
 begin
  GetMem(D, Succ(l));
  Move(S, D^, Succ(l))
 end;                             (* MakeDynString *)

 procedure MakeStatString(D : DynString; var S : StatString);
 begin
  S := D^
 end;                             (* MakeStatString *)

 procedure ForgetDynString(var D : DynString);
 begin
  FreeMem(D, Succ(DynStringLength(D)))
 end;                             (* ForgetDynString *)

 function DynStringLess(x, y : DynString; upper : Boolean) : Boolean;
 var
  i, l1, l2, m   : Integer;
 begin
  if not upper then
   begin
    DynStringLess := x^ < y^;
    Exit;
   end;
  l1 := DynStringLength(x);
  l2 := DynStringLength(y);
  i := 1;
  if l1 < l2 then
   m := l1
  else
   m := l2;
  while (i <= m) and (Upcase(x^[i]) = Upcase(y^[i])) do
   i := Succ(i);
  if i <= m then
   DynStringLess := Upcase(x^[i]) < Upcase(y^[i])
  else
   DynStringLess := l1 < l2;
 end;                             (* DynStringLess *)

 function DynStringEQUAL(x, y : DynString; upper : Boolean) : Boolean;
 var
  i, l1, l2      : Integer;
 begin
  if not upper then
   begin
    DynStringEQUAL := x^ = y^;
    Exit;
   end;
  l1 := DynStringLength(x);
  l2 := DynStringLength(y);
  if l1 <> l2 then
   begin
    DynStringEQUAL := False;
    Exit;
   end;
  for i := 1 to l1 do
   if Upcase(x^[i]) <> Upcase(y^[i]) then
    begin
     DynStringEQUAL := False;
     Exit;
    end;
  DynStringEQUAL := True;
 end;                             (* DynStringEQUAL *)

 function DynStringPos(x, y : DynString; start : Integer; upper : Boolean) : Integer;
 var
  i, j, l1, l2   : Integer;
 begin
  l1 := DynStringLength(x);
  l2 := DynStringLength(y);
  for i := start to Succ(l2 - l1) do
   begin
    j := 0;
    if upper then
     while (j < l1) and (Upcase(x^[Succ(j)]) = Upcase(y^[i + j])) do
      j := Succ(j)
    else
     while (j < l1) and (x^[Succ(j)] = y^[i + j]) do
      j := Succ(j);
    if j = l1 then
     begin
      DynStringPos := i;
      Exit;
     end
   end;
  DynStringPos := 0;
 end;                             (* DynStringPos *)


 procedure TextEdit(filename : String);




  function HeapAvail : Integer;
  var
   temp           : LongInt;
  begin
   temp := MaxAvail;
   if temp > MaxInt then
    HeapAvail := MaxInt
   else
    HeapAvail := temp;
  end;


  function LiesText(var f : file; var t : TextListe):longint;
  var
   line              : StatString;
   D              : DynString;
   p, q           : TextListe;
    var l          : LongInt;
    var
      fs, seeknr, toread : LongInt;
      startnr        : Integer;
      rread, foundnr : Word;
      block          : array[0..4095] of Char;
    const
      sst            : String = #13;

  begin
   NeuerText(t);
   Reset(f,1);
   {getftime(f,filetime);}
   q := t;
    { if constRec>0 then
      begin
      for l := 0 to nolines do
      begin
      New(p);
     with p^ do
      begin
       MakeDynString(l*constrec, Zeile);
       Rueck := q;
       Vor := nil;
      end;
     if q <> nil then
      q^.Vor := p
     else
      t := p;
     q := p
     end
     else
    }

    begin
      l := 1;
      seeknr := 0;
      startnr := seeknr;
      fs := FileSize(f);
      startnr := SizeOf(block);
      while ((seeknr + Ord(sst[0]) < fs)) do
        begin
          startnr := startnr - SizeOf(block);
          if seeknr + SizeOf(block) > fs then
            toread := fs - seeknr
          else
            toread := SizeOf(block);
          Seek(f, seeknr);
          BlockRead(f, block, toread, rread);
          foundnr := 0;
          foundnr := search(block, rread, sst[1], 1);
          while foundnr < $FFFF do
            begin
              New(p);
     with p^ do
      begin
       sptr.seeknr :=seeknr + startnr;
       if startnr < 0 then
                startnr := foundnr + 2
              else
                startnr := startnr + foundnr + 2;
              ifseek := startnr - sptr.seeknr;

       Rueck := q;
       Vor := nil;
      end;
     if q <> nil then
      q^.Vor := p
     else
      t := p;
     q := p;
              Inc(l);

              if startnr < rread then
                foundnr := search(block[startnr], rread - startnr, sst[1], 1)
              else
                foundnr := $FFFF;
            end;
          seeknr := seeknr + rread {- Ord(sst[0])} ;
        end;
      liestext := l - 1;
    end;
 end;
   {
   while not EoF(f) do
    begin
     if HeapAvail < 10000 then
      begin
       Close(f);
       Exit;
      end;
     ReadLn(f, l);
     New(p);
     with p^ do
      begin
       MakeDynString(l, Zeile);
       Rueck := q;
       Vor := nil;
      end;
     if q <> nil then
      q^.Vor := p
     else
      t := p;
     q := p
    end;
   Close(f)
  end;
    }
  procedure SchreibText(var f:file; var fout : Text; t : TextListe);
  var
  block          : array[1..4096] of Char;
  i:word;
  begin
   Assign(fout, filename);
   Rewrite(fout);
   while t <> nil do
    with t^ do
     begin
      if ifseek>0 then
        begin
          seek(f,sptr.seeknr);
          blockread(f,block,ifseek);
          for i:=1 to ifseek do
            write(fout,block[i]);

        end
      else
      WriteLn(fout, sptr.Zeile^);
      t := Vor;
     end;
   Close(f);
  end;

  procedure LoescheText(var t : TextListe);
  var
   p              : TextListe;
  begin
   while t <> nil do
    begin
     p := t^.Vor;
     if t^.ifseek = 0 then
     ForgetDynString(t^.sptr.Zeile);
     Dispose(t);
     t := p;
    end;
  end;

 var
  T0             : TextListe;
  f              : file;
  dummy : string;
  x, y, Z        : Integer;
  c              : Char;
{  S : string[255];
 }
  (*    TEDINST.INC  Installation von TED (Abgestimmt auf Herkules-Karte)     *)

 type
  VideoString    = String[80];

 var
  ActiveColor    : Byte;

  procedure SetTextColor;
  begin
   ActiveColor := 15
  end;

  procedure SetBlockColor;
  begin
   ActiveColor := 112
  end;

  procedure SetStatusColor;
  begin
   ActiveColor := 7
  end;

  procedure MoveToScreen(S : VideoString; x, y : Integer);
  type
   Screentyp      = array[1..49, 1..80] of Word;
  var
   i              : Integer;
   OldAttr,oldactive        : Byte;
   ActScreen      : ^Screentyp;
  begin
   if DirectVideo then
    begin
     x := Pred(x);
     if LastMode = Mono then
      ActScreen := Ptr($b000, 0)
     else
      ActScreen := Ptr($b800, 0);
     oldactive := activecolor;
     for i := 1 to Length(S) do
      begin
      if (s[i]='-') and (s[i+1] in ['1'..'9']) then
        activecolor := lightred;
      if (s[i]='-') and (s[i+1] = '0') then
        activecolor := red;

      if (s[i]='+') and (s[i+1] in ['1'..'9']) then
        activecolor := lightgreen;
      if (s[i]='+') and (s[i+1] = '0') then
        activecolor := green;
      if (s[i]=^G) then
        activecolor := yellow;

      if s[i]=' ' then
        activecolor := oldactive;

      if (S[i] >= #32) or (s[i]<= #6) then
       ActScreen^[y + EdtY1, EdtX1 + x + i] := Byte(S[i]) + ActiveColor shl 8
      else
       ActScreen^[y + EdtY1, EdtX1 + x + i] := 64 + Byte(S[i]) + 1 shl 8;
  {if s[i] =^G then
  begin
    sound(1000);
    delay(300);
    nosound;
  end;
   }
     end;
     activecolor := oldactive;
    end

   else
    begin
     OldAttr := TextAttr;
     TextAttr := ActiveColor;
     gotoxy(x, y);
     Write(S);
     TextAttr := OldAttr;
    end;
  end;                            (* MoveToScreen *)


  procedure EditText(var t : TextListe; x, y, Z : Integer;
                     Spalten, ZeilenGanz : Integer; Status : Boolean);
  const
   MaxSpalten     = 255;
  var
   Zeile          : StatString;   (* Die Zeile, innerhalb der ediert wird. *)
   l              : Byte absolute Zeile; (* Die ZeilenLnge *)
   temp, Anfang   : TextListe;    (* Der Zeiger auf letzte Zeile *)
   c              : Char;         (* Das eingegebene Zeichen *)
   LR, RO         : Integer;      (* Linker und oberer Rand *)
   Zeilen         : Integer;      (* Die nutzbaren Zeilen *)

  const
   Buchstaben     : set of Char = ['','','','',',', '.', '?', '#', '^', '$', '_',
   'A'..'Z', '', '', '',
   'a'..'z', '', '', '', '', '0'..'9'];
   NaechsterBefehl : Char = #0;
   InsertMode     : Boolean = True;
   IndentMode     : Boolean = True;
   SpaltenBlock   : Boolean = False;

  type BlockMarke = record
                     Line           : TextListe;
                     tx, tz         : Integer;
                     Markiert       : Boolean;
                    end;

  var
   BlockAnfang, BlockEnde : BlockMarke;

   procedure AppendLine(var t : TextListe; Z : DynString);
   var
    temp           : TextListe;
   begin
    New(temp);
    with temp^ do
     begin
      ifseek :=0;
      sptr.Zeile := Z;
      Rueck := t;
      if t <> nil then
       begin
        Vor := t^.Vor;
        t^.Vor := temp;
        if Vor <> nil then
         Vor^.Rueck := temp;
       end
      else
       Vor := nil;
     end;                         (* WITH *)
    t := temp;
   end;                           (* InsertLine *)

   procedure DeleteLine(var t : TextListe);
   begin
    if t <> nil then
     begin
      with t^ do
       begin
        if ifseek = 0 then
        ForgetDynString(sptr.Zeile);
        if Vor <> nil then
         Vor^.Rueck := Rueck;
        if Rueck <> nil then
         Rueck^.Vor := Vor;
        Dispose(t);
        t := nil;
       end;                       (* WITH *)
     end;                         (* IF *)
   end;                           (* DeleteLine *)

   function Copies(c : Char; n : Integer) : StatString;
   var
    S              : StatString;
   begin
    FillChar(S[1], n, c);
    S[0] := Chr(n);
    Copies := S;
   end;                           (* Copies *)

   procedure StatusZeile;
   var
    i              : Byte;
   begin
    gotoxy(1, 1);
    NormVideo;
    Write('':MaxX);
    i := Length(filename);
    {
    while (i > 0) and (filename[i] <> '\') do
     i := Pred(i);
    if i > 0 then
     Delete(filename, 1, i);
    }
    for i := 1 to Length(filename) do
     filename[i] := Upcase(filename[i]);
    gotoxy(5, 1);
    Write(filename);
    gotoxy(20, 1);
    Write(' Zl:      Sp:     St:');
    if InsertMode then
     Write(' Einf.');
    if IndentMode then
     Write(' Einr.');
    HighVideo;
   end;

   procedure SchreibStatus;
   begin
    gotoxy(bildschirmzeilen-1, 1);
    Write(Z:5);
    gotoxy(34, 1);
    Write(x:3);
   end;

   procedure ChangeMode;
   begin
    InsertMode := not InsertMode;
    if Status then
     begin
      StatusZeile;
      SchreibStatus;
     end;
   end;

   procedure ChangeIndent;
   begin
    IndentMode := not IndentMode;
    if Status then
     begin
      StatusZeile;
      SchreibStatus;
     end;
   end;

   procedure Print(var S : StatString; x, y, Sp : Integer);
   var
    t              : String[80];
    lt             : Byte absolute t;
    ls             : Byte absolute S;
    xp, nt, ns     : Integer;
   begin
    if Sp < 1 then
     Exit;
    if Sp > Spalten then
     Sp := Spalten;
    if x <= LR then
     x := Succ(LR);
    xp := x - LR; if xp > Sp then
     Exit;
    nt := Succ(Sp - xp);
    ns := Succ(ls - x);
    if nt > ns then
     nt := ns;
    t := Copy(S, x, nt);
    nt := Succ(Sp - lt - xp);
    if nt > 0 then
     begin
      FillChar(t[Succ(lt)], nt, ' ');
      lt := lt + nt;
     end;
    MoveToScreen(t, xp, y + RO);
   end;                           (* print *)

   procedure ShowLine(var S : StatString; x, y, Z : Integer);
   begin
    if not(BlockAnfang.Markiert and BlockEnde.Markiert) or
    (Z < BlockAnfang.tz) or (Z > BlockEnde.tz) then
     Print(S, x, y, Spalten)
    else if ((Z = BlockAnfang.tz) and (Z = BlockEnde.tz)) or SpaltenBlock then
     begin
      Print(S, x, y, Pred(BlockAnfang.tx - LR));
      SetBlockColor;
      Print(S, BlockAnfang.tx, y, Pred(BlockEnde.tx - LR));
      SetTextColor;
      Print(S, BlockEnde.tx, y, Spalten);
     end
    else if Z = BlockAnfang.tz then
     begin
      Print(S, x, y, Pred(BlockAnfang.tx - LR));
      SetBlockColor;
      Print(S, BlockAnfang.tx, y, Spalten);
      SetTextColor;
     end
    else if Z = BlockEnde.tz then
     begin
      SetBlockColor;
      Print(S, x, y, Pred(BlockEnde.tx - LR));
      SetTextColor;
      Print(S, BlockEnde.tx, y, Spalten)
     end
    else
     begin
      SetBlockColor;
      Print(S, x, y, Spalten);
      SetTextColor;
     end;
   end;                           (* ShowLine *)

   procedure getline(tz:textzeile);
   begin
     with tz do
     begin
      seek(f,sptr.seeknr);
      blockread(f,dummy,ifseek);
      dummy[0]:=char(ifseek);
     end;
      
   end;
   procedure ShowPage(t : TextListe; ab : Integer);
   var
    i, iz          : Integer;
    LeerZeile      : String[80];
   begin
    iz := Z + ab - y;
    LeerZeile := Copies(' ', Spalten);
    for i := ab to Succ(Zeilen) do
     begin
      if NaechsterBefehl <> #0 then
       if KeyPressed then
        begin
         LiesZeichen(c);
         if c = NaechsterBefehl then
          Exit;
        end;
      if t = nil then
       MoveToScreen(LeerZeile, 1, i + RO)
      else
       begin
        if t^.ifseek = 0 then
        ShowLine(t^.sptr.Zeile^, Succ(LR), i, iz)
        else
        begin
        getline(t^);
        ShowLine(dummy, Succ(LR), i, iz)
        end;
        iz := Succ(iz);
        t := t^.Vor;
        {if no_pv then
          begin
            while (t <> nil) and
                  (copy(t^.Zeile^,1,1) = '.') and
                  (copy(t^.Zeile^,3,1) = 'v') do
               t := t^.Vor;
          end; }
       end;
     end;
    c := #0;
   end;                           (* ShowPage *)

   procedure AktualisiereBlocks(cx, cz : Integer);
   var
    xp             : Integer;
    procedure Pruefe(cx, cz : Integer; var Block : BlockMarke);
    begin
     with Block do
      if Markiert then
       begin
        if Z < tz then
         tz := tz + cz
        else if Z = tz then
         begin
          if cz < 0 then
           tx := 1
          else if (xp > tx + cx) and (xp <= tx) then
           tx := xp
          else if xp < tx then
           tx := tx + cx;
         end;
       end;
    end;

   begin
    xp := x + LR;
    Pruefe(cx, cz, BlockAnfang);
    Pruefe(cx, cz, BlockEnde);
   end;                           (* AktualisiereBlocks *)

   procedure aktualisiere;
   var
    D              : DynString;
    p              : TextListe;
   begin
    while Zeile[l] = ' ' do
     l := Pred(l);
    if Zeile = temp^.sptr.Zeile^ then
     Exit;
    MakeDynString(Zeile, D);
    AppendLine(temp, D);
    p := temp^.Rueck;
    if t = p then
     t := temp;
    DeleteLine(p);
   end;                           (* aktualisiere *)

   function Top   : TextListe;
   var
    i              : Integer;
    p              : TextListe;
   begin
    p := temp;
    for i := 2 to y
    do p := p^.Rueck;
    Top := p;
   end;                           (* Top *)

   procedure HochSchieben;
   var
    p              : TextListe;
   begin
    aktualisiere;
    p := Top;
    NaechsterBefehl := ^Z;
    if temp^.Vor = nil then
     Exit;
    repeat
     if y > 1 then
      y := Pred(y)
     else
      begin
       Z := Succ(Z);
       temp := temp^.Vor
      end;
     p := p^.Vor;
     ShowPage(p, 1)
    until (c = #0) or (temp^.Vor = nil);
    NaechsterBefehl := #0;
    Zeile := temp^.sptr.Zeile^;
    if c <> #0 then
     ShowPage(p, 1);
   end;                           (* HochSchieben *)

   procedure TiefSchieben;
   var
    p              : TextListe;
   begin
    aktualisiere; p := Top;
    NaechsterBefehl := ^W;
    if p = t then
     Exit;
    repeat
     if y < Zeilen then
      y := Succ(y)
     else
      begin
       Z := Pred(Z);
       temp := temp^.Rueck
      end;
     p := p^.Rueck;
     ShowPage(p, 1)
    until (c = #0) or (p = t);
    NaechsterBefehl := #0;
    Zeile := temp^.sptr.Zeile^; if c <> #0 then
     ShowPage(p, 1);
   end;                           (* TiefSchieben *)

   procedure ZeileVor;
   var
    i              : Integer;
    p              : TextListe;
    cc             : Char;
   begin
    if temp^.Vor = nil then
     Exit;
    NaechsterBefehl := ^x;
    aktualisiere;
    p := Top;
    repeat
     Z := Succ(Z);
     if y = Zeilen then
      begin
       ShowPage(temp^.Vor, y);
       p := p^.Vor;
       ShowPage(p, 1)
      end
     else
      begin
       y := Succ(y);
       c := #0
      end;
     temp := temp^.Vor;           (* Z:=succ(Z); *)
    until (c = #0) or (temp^.Vor = nil);
    NaechsterBefehl := #0;
    Zeile := temp^.sptr.Zeile^;
    if c <> #0 then
     ShowPage(p, 1)
   end;                           (* ZeileVor *)

   procedure ZeileRueck;
   var
    p              : TextListe;
   begin
    if temp^.Rueck = nil then
     Exit;
    NaechsterBefehl := ^E;
    aktualisiere;
    p := Top;
    repeat
     Z := Pred(Z);
     if y = 1 then
      begin
       p := p^.Rueck;
       ShowPage(p, 1)
      end
     else
      begin
       y := Pred(y);
       c := #0
      end;
     temp := temp^.Rueck;         (* Z:=pred(Z); *)
    until (c = #0) or (temp^.Rueck = nil);
    NaechsterBefehl := #0;
    Zeile := temp^.sptr.Zeile^;
    if c <> #0 then
     ShowPage(p, 1)
   end;                           (* ZeileRueck *)

   procedure SeiteRueck;
   var
    i, j           : Integer;
    p              : TextListe;
   begin
    if Z = 1 then
     Exit;
    NaechsterBefehl := ^R;
    aktualisiere;
    repeat
     if Z > Zeilen then
      i := Zeilen
     else
      i := Z;
     Z := Z - Pred(i);
     for j := 2 to i do
      temp := temp^.Rueck;
     if Z < y then
      y := Z;
     ShowPage(Top, 1)
    until c <> ^R;
    NaechsterBefehl := #0;
    Zeile := temp^.sptr.Zeile^
   end;                           (* SeiteRueck *)

   procedure SeiteVor;
   var
    i,ii, j           : Integer;
    p,predict              : TextListe;
   begin
    if temp^.Vor = nil then
     Exit;
    NaechsterBefehl := ^c;
    aktualisiere;
    repeat
     i := 0;
     while (i < Pred(Zeilen)) and (temp^.Vor <> nil) do
      begin
       temp := temp^.Vor;
       i := Succ(i);
      end;

     {if temp^.Vor <> nil then}
     begin
      predict:= temp;
      ii:=0;
      while (ii < Pred(Zeilen)) and (predict^.Vor <> nil) do
      begin
       predict := predict^.Vor;
       ii := Succ(ii);
      end;
      if i<>ii then
       while i>ii do
         begin
           temp := temp^.rueck;
           dec(i);
         end;
     end;

     Z := Z + i;
     if temp^.Vor = nil then
      y := 1;
     ShowPage(Top, 1)
    until c <> ^c;
    NaechsterBefehl := #0;
    Zeile := temp^.sptr.Zeile^
   end;                           (* SeiteVor *)

   procedure WortVor;
   begin
    if x > l then
     if temp^.Vor = nil then
      Exit
     else
      begin
       ZeileVor;
       x := 1;
       if Zeile[x] in Buchstaben then
        Exit
      end;
    while (x <= l) and (Zeile[x] in Buchstaben) do
     x := Succ(x);
    while (x <= l) and not(Zeile[x] in Buchstaben) do
     x := Succ(x);
   end;                           (* WortVor *)

   procedure WortRueck;
   begin
    if x > l then
     x := l + 1;
    x := Pred(x);
    while (x > 0) and not(Zeile[x] in Buchstaben) do
     x := Pred(x);
    if x = 0 then
     begin
      if temp^.Rueck <> nil then
       begin
        ZeileRueck;
        x := l
       end
     end
    else
     while (x > 0) and (Zeile[x] in Buchstaben) do
      x := Pred(x);
    x := Succ(x)
   end;                           (* WortRueck *)

   procedure AppendNextLine;
   var
    p              : TextListe;
   begin
    if temp^.Vor = nil then
     Exit;                        (* Es gibt keine naechste Zeile *)
    p := temp^.Vor;
    if l + Length(p^.sptr.Zeile^) < 256 then
     Zeile := Zeile + p^.sptr.Zeile^
    else
     begin
      Write(^G);
      Exit
     end;
    ShowLine(Zeile, x, y, Z);
    DeleteLine(p);
    p := temp^.Vor;
    ShowPage(p, y + 1)
   end;                           (* AppendNextLine *)

   procedure InsChar;
   begin
    if (l >= MaxSpalten) or (x >= MaxSpalten) then
     begin
      Write(^G);
      Exit
     end;
    while l < Pred(x) do
     Zeile := Zeile + ' ';
    if InsertMode then
     begin
      Move(Zeile[x], Zeile[Succ(x)], Succ(l - x));
      l := Succ(l)
     end
    else if l < x then
     l := x;
    Zeile[x] := c;
    x := Succ(x);
    if InsertMode then
     AktualisiereBlocks(1, 0);
    ShowLine(Zeile, Pred(x), y, Z);
   end;                           (* InsChar *)

   procedure DeleteChar;
   begin
    Delete(Zeile, x, 1);
    AktualisiereBlocks(- 1, 0);
    ShowLine(Zeile, x, y, Z);
   end;                           (* DeleteChar *)

   procedure LoeschZeichenLinks;
   begin
    if x > 1 then
     begin
      x := Pred(x);
      if x <= l then
       DeleteChar
     end
    else if Z > 1 then
     begin
      ZeileRueck;
      x := 0;
      AktualisiereBlocks(0, - 1);
      AktualisiereBlocks(l, 0);
      x := l + 1;
      AppendNextLine;
      aktualisiere;
      ShowPage(temp, y)
     end;
   end;                           (* LoeschZeichenLinks *)

   procedure LoeschZeichen;
   begin
    if x <= l then
     DeleteChar
    else
     begin
      while l < x do
       Zeile := Zeile + ' ';
      AppendNextLine;
      aktualisiere;
      AktualisiereBlocks(0, - 1);
      ShowPage(temp, y)
     end;
   end;                           (* LoeschZeichen *)

   procedure LoeschWort;
   var i          : Integer;
   begin
    if x > l then
     begin
      while l < Pred(x) do
       Zeile := Zeile + ' ';
      AppendNextLine;
      aktualisiere;
      AktualisiereBlocks(0, - 1);
      ShowPage(temp, y);
      Exit;
     end;
    i := x;
    if Zeile[i] in Buchstaben then
     while (i <= l) and (Zeile[i] in Buchstaben) do
      i := Succ(i)
    else
     i := Succ(i);
    while (i <= l) and (Zeile[i] = ' ') do
     i := Succ(i);
    Delete(Zeile, x, i - x);
    AktualisiereBlocks(x - i, 0);
    ShowLine(Zeile, x, y, Z)
   end;                           (* LoeschWort *)

   procedure ZeileLoeschen;
   var
    p, q           : TextListe;
    i              : Integer;
   begin
    if temp^.Vor = nil then
     begin
      Zeile := '';
      aktualisiere;
      ShowLine(Zeile, x, y, Z)
     end
    else
     begin
      NaechsterBefehl := ^y;
      AktualisiereBlocks(0, - 1);
      while (c = ^y) and (temp^.Vor <> nil) do
       begin
        p := temp;
        q := temp^.Vor;
        DeleteLine(temp);
        temp := q;
        ShowPage(temp, y);
        if t = p then
         t := q
       end;
      NaechsterBefehl := #0;
      ShowPage(Top, 1)
     end;
    Zeile := temp^.sptr.Zeile^;
    x := 1
   end;                           (* ZeileLoeschen *)

   procedure ZeileEinfuegen(Anzeige : Boolean);
   var
    D              : DynString;
    p              : TextListe;
   begin
    repeat
     MakeDynString(Copy(Zeile, x, Succ(l - x)), D);
     Zeile := Copy(Zeile, 1, Pred(x));
     p := temp;
     AppendLine(p, D);
     aktualisiere;
     with BlockAnfang do
      if Markiert and (Z = tz) and (x < tx) then
       begin
        Z := Pred(Z);
        AktualisiereBlocks(0, 1);
        Z := Succ(Z);
        tx := tx - Pred(x);
        if BlockEnde.Markiert and (BlockEnde.tz = tz) then
         BlockEnde.tx := BlockEnde.tx - Pred(x);
       end
      else
       AktualisiereBlocks(0, 1);
     if Anzeige then
      ShowPage(temp, y)
    until (c = #0) or not Anzeige;
    NaechsterBefehl := #0;
   end;                           (* ZeileEinfuegen *)

   procedure NaechsteZeile;
   var
    p, n           : Integer;
   begin
    if InsertMode then
     begin
      ZeileEinfuegen(False);
      ShowLine(Zeile, x, y, Z)
     end;
    ZeileVor;
    if IndentMode and InsertMode then
     begin
      p := 1;
      n := DynStringLength(temp^.Rueck^.sptr.Zeile);
      if x < n then
       n := Pred(x);
      while (p < n) and (temp^.Rueck^.sptr.Zeile^[p] = ' ') do
       p := Succ(p);
      if p > x then x := 1
      else
       begin
        with BlockAnfang do
         if Markiert and (Z = tz) then
          begin
           tx := tx + Pred(p);
           if BlockEnde.Markiert and (BlockEnde.tz = tz) then
            BlockEnde.tx := BlockEnde.tx + Pred(p);
          end;
        x := p;
        Zeile := Copies(' ', Pred(p)) + Zeile;
        aktualisiere;
       end;
     end
    else
     x := 1;
    ShowPage(temp, y);
   end;                           (* NaechsteZeile *)

   procedure InitEditor;
   var
    i              : Integer;
   begin
    LR := 0;
    HighVideo;
    if Status then
     begin
      RO := 1;
      Zeilen := ZeilenGanz - 2
     end
    else
     begin
      RO := 0;
      Zeilen := ZeilenGanz - 1
     end;
    if t = nil then
     begin
      New(temp);
      t := temp;
      with temp^ do
       begin
        Vor := nil;
        Rueck := nil;
        ifseek := 0;
        MakeDynString('', sptr.Zeile)
       end;
      x := 1;
      y := 1;
      Z := 1
     end
    else
     begin
      if x >= Spalten then
       LR := Succ(x - Spalten);
      temp := t;
      i := 1;
      while (temp^.Vor <> nil) and (i < Z) do
       begin
        i := Succ(i);
        temp := temp^.Vor
       end;
      if i < Z then
       Z := i;
      if y > Z then
       y := Z;
      Anfang := temp;
      for i := 2 to y do
       Anfang := Anfang^.Rueck;
      ShowPage(Anfang, 1)
     end;
    Zeile := temp^.sptr.Zeile^;
    if Status then StatusZeile
   end;                           (* InitEditor *)

   (* $I EDT-Q.INC    *)          (* Das Ctrl-Q-Men                       *)
   procedure CtrlQ_Menue(RepeatOp : Boolean);

   type Str_32    = String[32];

   const FindStr  : Str_32 = ''; ReplaceString : Str_32 = '';
    OptionString   : Str_32 = ''; Anzeige : Boolean = True;
    Options        : set of (upper, words, back, global, norequest) = [];
    LastOp         : (FindOp, ReplaceOp) = FindOp;

   var TopList    : TextListe;

    function BDynStringPos(A, B : DynString; n : Integer; upper : Boolean) : Integer;
    var p, q       : Integer;
    begin
     p := 1; q := 0; if n = 0 then
      begin
       BDynStringPos := 0; Exit
      end;
     repeat
      p := DynStringPos(A, B, p, upper);
      if p > 0
      then if Pred(p + DynStringLength(A)) <= n
       then
        begin
         q := p; p := Succ(p)
        end
       else p := 0
     until p = 0;
     BDynStringPos := q
    end;                          (* BDynStringPos *)

    procedure GetString(var S : Str_32);
    var c          : Char; l : Byte absolute S;
    begin
     LiesZeichen(c);
     if c = ^m then
      begin
       S := ''; Exit
      end
     else
      if c <> ^R then
       S := c;
     Write(S);
     repeat
      LiesZeichen(c);
      case c of
       #01..#7,#14..#255 :
        begin
         S := S + c;
         Write(c);
        end;
       ^H :
        if l > 0 then
         begin
          l := Pred(l);
          Write(^H' '^H)
         end
      end
     until (c = ^m) or (l >= 32)
    end;                          (* GetString *)

    procedure ZumAnfang;
    begin
     aktualisiere; temp := t;
     Zeile := temp^.sptr.Zeile^;
     x := 1; y := 1; Z := 1; LR := 0;
     ShowPage(t, 1)
    end;                          (* ZumAnfang *)

    procedure ZumEnde;
    var p          : TextListe;
    begin
     aktualisiere; p := temp;
     while p^.Vor <> nil do
      begin
       p := p^.Vor; Z := Succ(Z); if y < Zeilen then y := Succ(y)
      end;
     temp := p;
     Zeile := temp^.sptr.Zeile^;
     x := Succ(l);
     if x > Spalten + LR then
     LR := x - Spalten;
     ShowPage(Top, 1)
    end;                          (* ZumEnde *)

    procedure SeitenAnfang;
    begin
     aktualisiere; temp := Top;
     Zeile := temp^.sptr.Zeile^;
     Z := Succ(Z - y);
     y := 1;
    end;                          (* SeitenAnfang *)

    procedure SeitenEnde;
    begin
     aktualisiere;
     while (temp^.Vor <> nil) and (y < Zeilen) do
      begin
       temp := temp^.Vor; y := Succ(y); Z := Succ(Z)
      end;
     Zeile := temp^.sptr.Zeile^
    end;                          (* SeitenEnde *)

    procedure RetteZeile;
    begin
     Zeile := temp^.sptr.Zeile^;
     ShowLine(Zeile, Succ(LR), y, Z);
     if x > l then x := l + 1;
    end;                          (* RetteZeile *)

    procedure LoescheBisZeilenEnde;
    var n          : Integer;
    begin
     n := 1 + l - x;
     if n > 0 then
      begin
       l := Pred(x); AktualisiereBlocks(- n, 0); ShowLine(Zeile, x, y, Z)
      end;
    end;

    procedure LiesOptions;
    var i          : Integer;
    begin
     gotoxy(1, 1); Write('Optionen: '); clreol; GetString(OptionString);
     Options := [];
     for i := 1 to Length(OptionString) do
      case Upcase(OptionString[i]) of
       'G' : Options := Options + [global];
       'N' : Options := Options + [norequest];
       'U' : Options := Options + [upper];
       'W' : Options := Options + [words];
       'B' : Options := Options + [back];
      end                         (* CASE *)
    end;                          (* LiesOptions *)

    function Found : Boolean;
    var p          : TextListe;
    n, tz, ty, tx : Integer;
    gef : Boolean;
     D              : DynString;

     procedure CheckWord;
     begin
      gef := n > 0;
      if gef and (words in Options) then
       gef := (((n = 1) or
              not(p^.sptr.Zeile^[Pred(n)] in Buchstaben)) and
               ((n + Length(FindStr) > DynStringLength(p^.sptr.Zeile)) or
                not(p^.sptr.Zeile^[n + Length(FindStr)] in Buchstaben)))
     end;                         (* CheckWord *)

    begin
     aktualisiere; p := temp; tx := x; ty := y; tz := Z; n := tx;
     if back in Options then n := Pred(n); MakeDynString(FindStr, D);
     repeat
      if back in Options then
       begin
        n := BDynStringPos(D, p^.sptr.Zeile, n, upper in Options); CheckWord;
        if n = 0 then
         begin
          p := p^.Rueck; n := 255; tz := Pred(tz); if ty > 1 then ty := Pred(ty)
         end
        else if not gef then n := Pred(n)
       end
      else
       begin
        n := DynStringPos(D, p^.sptr.Zeile, n, upper in Options); CheckWord;
        if n = 0 then
         begin
          n := 1; p := p^.Vor; tz := Succ(tz); ty := Succ(ty)
         end
        else if not gef then n := Succ(n)
       end;
     until (p = nil) or gef; ForgetDynString(D);
     if gef then
      begin
       x := n; if ty > Zeilen then y := Zeilen
       else y := ty;
       temp := p; Z := tz; Zeile := temp^.sptr.Zeile^;
       if Anzeige then ShowPage(Top, 1)
      end;
     Found := gef
    end;                          (* Found *)

    procedure Suche(Neu : Boolean);
    label Ausgang;
    begin
     if Neu then
      begin
       gotoxy(1, 1); Write('Suchen: '); clreol; GetString(FindStr);
       if FindStr = '' then goto Ausgang;
       LiesOptions;
      end;
     if not Found then
      begin
       gotoxy(1, 1); Write('Suchbegriff nicht gefunden <ESC> '); clreol;
       repeat
        LiesZeichen(c)
       until c = ^[; c := #0
      end
     else if not(back in Options) then x := x + Length(FindStr);
Ausgang:
     if Status then StatusZeile
     else
      begin
       TopList := Top; ShowLine(TopList^.sptr.Zeile^, 1 + LR, 1, 1 + Z - y)
      end
    end;                          (* Suche *)

    procedure Replace(Neu : Boolean);
    label Ausgang;
    const Schranke = 1000;        (* Ausprobieren! *)
    var Erfolg, Oben : Boolean; c : Char; Count : Integer;
    begin
     if Neu then
      begin
       gotoxy(1, 1); Write('Suchen: '); clreol;
       GetString(FindStr); if FindStr = '' then goto Ausgang;
       gotoxy(1, 1); Write('Ersetzen durch: '); clreol;
       GetString(ReplaceString);
       LiesOptions;
      end;                        (* IF Neu *)
     if global in Options then
      if back in Options then ZumEnde
      else ZumAnfang;
     Erfolg := Found;
     Anzeige := True;
     if not Erfolg then
      begin
       gotoxy(1, 1); Write('Suchbegriff nicht gefunden <ESC> '); clreol;
       repeat
        LiesZeichen(c)
       until c = ^[; c := #0
      end
     else
      repeat
       if x > Spalten + LR then
        begin
         aktualisiere; LR := x - Spalten; ShowPage(Top, 1);
         edited := True;
        end
       else
        if x <= LR then
         begin
          aktualisiere; LR := Pred(x); ShowPage(Top, 1)
         end;
       if not(norequest in Options) then
        begin
         gotoxy(1, 1); Write('Ersetzen (J/N)? '); clreol;
         Oben := True; Count := 0; c := #0;
         repeat
          if Count = Schranke then
           begin
            if Oben then gotoxy(17, 1)
            else gotoxy(x - LR, y + RO);
            Count := 0; Oben := not Oben;
           end;
          if KeyPressed then
           begin
            LiesZeichen(c); c := Upcase(c)
           end;
          Count := Count + 1
         until (c = 'J') or (c = 'N') or (c = ^U);
         if c = ^U then goto Ausgang;
        end
       else
        if KeyPressed then
         begin
          LiesZeichen(c);
          Anzeige := False
         end;
       if (c = 'J') or (norequest in Options) then
        begin
         Delete(Zeile, x, Length(FindStr));
         Insert(ReplaceString, Zeile, x);
         if Anzeige then ShowLine(Zeile, Succ(LR), y, Z);
         edited := True;
        end;
       if not(back in Options) then x := x + Length(ReplaceString);
       if global in Options then Erfolg := Found
       else Erfolg := False
      until not Erfolg;
     if global in Options then
      if back in Options then ZumAnfang 
      else ZumEnde;
Ausgang: Anzeige := True;
     if Status then StatusZeile
     else 
      begin
       TopList := Top; ShowLine(TopList^.sptr.Zeile^, 1 + LR, 1, 1 + Z - y)
      end
    end;                          (* Replace *)

    procedure RepeatLastOp;       (* Wird durch ^L gestartet *)
    begin
     case LastOp of
      FindOp : Suche(False);
      ReplaceOp : Replace(False)
     end;                         (* CASE *)
    end;                          (* RepeatLastOp *)

   begin
    if RepeatOp then 
     begin
      RepeatLastOp; Exit 
     end;
    if Status then 
     begin
      gotoxy(1, 1); Write('^Q')
     end;
    LiesZeichen(c);
    case c of
     ^R, 'r', 'R' : ZumAnfang;
     ^c, 'c', 'C' : ZumEnde;
     ^E, 'e', 'E' : SeitenAnfang;
     ^x, 'x', 'X' : SeitenEnde;
     ^S, 's', 'S' : x := 1;
     ^D, 'd', 'D' : x := l + 1;
     ^l, 'l', 'L' : RetteZeile;
     ^y, 'y', 'Y' : LoescheBisZeilenEnde;
     ^i, 'i', 'I' : ChangeIndent;
     ^f, 'f', 'F' :
      begin
       Suche(True); LastOp := FindOp
      end;
     ^A, 'a', 'A' :
      begin
       Replace(True); LastOp := ReplaceOp
      end;
    end;                          (* CASE *)
    if Status then
     begin
      gotoxy(1, 1); Write('  ')
     end;
   end;                           (* CtrlQ_Menue *)
   (* $I EDT-K.INC    *)          (* Das Ctrl-K-Men                       *)
   procedure CtrlK_Menue;

   type Str40     = String[40];

   var TopListe   : TextListe;
    Abbruch        : Boolean;

   const Anzeige  : Boolean = True;

    procedure ErsteZeile;
    begin
     if Status then StatusZeile
     else
      begin
       TopListe := Top; ShowLine(TopListe^.sptr.Zeile^, 1 + LR, 1, 1 + Z - y)
      end
    end;                          (* ErsteZeile *)

    function LegalBlock : Boolean;
    begin
     LegalBlock := ((BlockAnfang.tz < BlockEnde.tz) or
                    (((BlockAnfang.tz = BlockEnde.tz) or SpaltenBlock) and
                     (BlockAnfang.tx < BlockEnde.tx))) and
     (BlockAnfang.Markiert and BlockEnde.Markiert);
    end;                          (* LegalBlock *)

    function CursorInBlock : Boolean;
    var h          : Boolean;
    begin
     h := (Z >= BlockAnfang.tz) and (Z <= BlockEnde.tz);
     if SpaltenBlock then h := h and (x >= BlockAnfang.tx) and (x < BlockEnde.tx)
     else
      begin
       if (Z = BlockAnfang.tz) and (x < BlockAnfang.tx) then h := False
       else
        if (Z = BlockEnde.tz) and (x >= BlockEnde.tx) then h := False;
      end;
     CursorInBlock := h;
    end;                          (* CursorInBlock *)

    function CursorAuf(Block : BlockMarke) : Boolean;
    begin
     CursorAuf := (Z = Block.tz) and (x = Block.tx)
    end;                          (*CursorAuf *)

    procedure BlockWegmachen;
    begin
     BlockAnfang.Markiert := False;
     BlockEnde.Markiert := False;
     aktualisiere;
     ShowPage(Top, 1);
     edited := True;
    end;                          (* BlockWegmachen *)

    procedure BlockMarkieren(var B : BlockMarke; Anzeige : Boolean);
    begin
     B.tx := x; B.tz := Z; B.Markiert := True;
     if BlockAnfang.Markiert and BlockEnde.Markiert and Anzeige then
      begin
       aktualisiere; ShowPage(Top, 1)
      end;
    end;                          (* BlockMarkieren *)

    procedure WortMarkieren;
    var Xsave      : Integer;
    begin
     Xsave := x;
     if x > l then x := l + 1;
     while (x > 0) and (Zeile[x] in Buchstaben) do x := Pred(x);
     x := Succ(x); BlockMarkieren(BlockAnfang, False);
     while (x <= l) and (Zeile[x] in Buchstaben) do x := Succ(x);
     BlockMarkieren(BlockEnde, False);
     x := Xsave; aktualisiere; ShowPage(Top, 1)
    end;                          (* WortMarkieren *)

    procedure ZeileMarkieren;
    begin
     SpaltenBlock := False; x := 1; BlockMarkieren(BlockAnfang, False);
     ZeileVor; BlockMarkieren(BlockEnde, True);
    end;                          (*ZeileMarkieren *)

    procedure RestauriereBlock;
    var p          : TextListe; i : Integer;
    begin
     p := t;
     for i := 1 to Pred(BlockAnfang.tz) do p := p^.Vor;
     BlockAnfang.Line := p;
     for i := BlockAnfang.tz to Pred(BlockEnde.tz) do p := p^.Vor;
     BlockEnde.Line := p;
    end;                          (*RestauriereBlock *)

    procedure GetPosition(m : Str40; var B : BlockMarke);
    var c          : Char;
    begin
     LowVideo;
     gotoxy(1, 1);
     Write('  ', m, ' <RETURN>');
     clreol; HighVideo;
     repeat
      if x > Spalten + LR then
       begin
        aktualisiere; LR := x - Spalten; ShowPage(Top, 1)
       end
      else
       if x <= LR then
        begin
         aktualisiere; LR := Pred(x); ShowPage(Top, 1)
        end;
      gotoxy(x - LR, y + RO); LiesZeichen(c);
      case c of
       ^S : if x > 1 then x := Pred(x);
       ^D : if x < MaxSpalten then x := Succ(x);
       ^x : ZeileVor;
       ^E : ZeileRueck;
       ^R : SeiteRueck;
       ^c : SeiteVor;
       ^f : WortVor;
       ^A : WortRueck;
       ^W : TiefSchieben;
       ^Z : HochSchieben;
       ^q : CtrlQ_Menue(False);
      end;
     until (c = ^m) or (c = ^U); Abbruch := (c = ^U);
     if not Abbruch then BlockMarkieren(B, True)
    end;                          (* GetPosition *)

    procedure LiesPositionen(Anzahl : Integer);
    var EinfuegePosition : BlockMarke;
    begin
     Abbruch := False;
     if BlockAnfang.Markiert and BlockEnde.Markiert then Exit;
     GetPosition('Blockanfang', BlockAnfang); if Abbruch then Exit;
     GetPosition('Blockende', BlockEnde); if Abbruch then Exit;
     if Anzahl = 3 then GetPosition('Neue Position', EinfuegePosition);
    end;                          (* LiesPosition *)

    procedure DelBlock;
    var D          : DynString; Block : TextListe; n, i : Integer;
    begin
     n := BlockEnde.tx - BlockAnfang.tx;
     with BlockAnfang do
      if tz = BlockEnde.tz then
       begin
        if Z = tz then Delete(Zeile, tx, n)
        else Delete(Line^.Zeile^, tx, n);
       end
      else if SpaltenBlock then
       for i := tz to BlockEnde.tz do
        begin
         if Z = i then Delete(Zeile, tx, n)
         else Delete(Line^.Zeile^, tx, n);
         Line := Line^.Vor;
        end
      else
       begin
        MakeDynString(Copy(Line^.Zeile^, 1, Pred(tx)) +
                      Copy(BlockEnde.Line^.Zeile^, BlockEnde.tx, 255), D);
        ForgetDynString(Line^.Zeile); Line^.Zeile := D;
        Block := Line^.Vor; Line^.Vor := BlockEnde.Line^.Vor;
        if Line^.Vor <> nil then Line^.Vor^.Rueck := Line;
        if BlockEnde.tz = Z then
         begin
          Zeile := Line^.Zeile^; temp := Line
         end;
        BlockEnde.Line^.Vor := nil; LoescheText(Block);
       end;
    end;                          (* DelBlock *)

    procedure InsBlock(TL : TextListe);
    var D          : DynString; p : TextListe; S : StatString; dx, i : Integer;
    begin
     if SpaltenBlock and (BlockAnfang.tz <> BlockEnde.tz) then
      begin
       dx := BlockEnde.tx - BlockAnfang.tx;
       for i := BlockAnfang.tz to BlockEnde.tz do
        begin
         if l < x then Zeile := Zeile + Copies(' ', Pred(x) - l);
         S := Copy(TL^.Zeile^, BlockAnfang.tx, dx);
         if Length(S) < dx then S := S + Copies(' ', dx - Length(S));
         Insert(S, Zeile, x);
         aktualisiere; TL := TL^.Vor;
         if (temp^.Vor = nil) and (TL <> nil) then
          begin
           MakeDynString('', D); Zeile := '';
           AppendLine(temp, D); aktualisiere
          end
         else if TL <> nil then
          begin
           temp := temp^.Vor; Zeile := temp^.Zeile^
          end;
        end;
       for i := 1 to BlockEnde.tz - BlockAnfang.tz do temp := temp^.Rueck;
       Zeile := temp^.Zeile^; aktualisiere
      end
     else
      begin
       p := temp^.Vor; temp^.Vor := TL; TL^.Rueck := temp;
       while TL^.Vor <> nil do TL := TL^.Vor;
       TL^.Vor := p; if p <> nil then p^.Rueck := TL;
       MakeDynString(TL^.Zeile^ + Copy(Zeile, x, 255), D);
       ForgetDynString(TL^.Zeile); TL^.Zeile := D;
       l := Pred(x); AppendNextLine; aktualisiere;
      end
    end;                          (* InsBlock *)

    procedure MakeBlock(var TL : TextListe);
    var p, q       : TextListe; D : DynString; A : Integer;
    begin
     NeuerText(TL);
     if BlockAnfang.tz = BlockEnde.tz then
      begin
       MakeDynString(Copy(BlockAnfang.Line^.Zeile^, BlockAnfang.tx,
                          BlockEnde.tx - BlockAnfang.tx), D);
       AppendLine(TL, D)
      end
     else
      begin
       if SpaltenBlock then A := 1
       else A := BlockAnfang.tx;
       MakeDynString(Copy(BlockAnfang.Line^.Zeile^, A, 255), D);
       AppendLine(TL, D); p := TL; q := BlockAnfang.Line^.Vor;
       while (q <> BlockEnde.Line) and (HeapAvail > 1000) do
        begin
         MakeDynString(q^.Zeile^, D); AppendLine(p, D); q := q^.Vor
        end;
       MakeDynString(Copy(BlockEnde.Line^.Zeile^, 1, Pred(BlockEnde.tx)), D);
       AppendLine(p, D)
      end;
    end;                          (* MakeBlock *)

    procedure BlockSchreiben;
    label Ausgang;
    var p          : TextListe;
     f              : Text;
     fn             : String[32];
     ta, n          : Integer;
    begin
     LiesPositionen(2);
     if not Abbruch and LegalBlock then
      begin
       gotoxy(1, 1); Write('Datei zum Schreiben: '); clreol;
       ReadLn(fn); if fn = '' then goto Ausgang;
       Assign(f, fn); Rewrite(f);
       aktualisiere; RestauriereBlock;
       if BlockAnfang.tz = BlockEnde.tz
       then with BlockAnfang do
        Write(f, Copy(Line^.Zeile^, tx, BlockEnde.tx - tx))
       else
        begin
         if SpaltenBlock
         then
          begin
           ta := BlockAnfang.tx; n := BlockEnde.tx - ta
          end
         else
          begin
           ta := 1; n := 255
          end;
         with BlockAnfang do WriteLn(f, Copy(Line^.Zeile^, tx, n));
         p := BlockAnfang.Line^.Vor;
         while p <> BlockEnde.Line do
          begin
           WriteLn(f, Copy(p^.Zeile^, ta, n)); p := p^.Vor
          end;
         with BlockEnde do
          if tx = 1 then WriteLn(f)
          else Write(f, Copy(Line^.Zeile^, ta, tx - ta));
        end;
       Close(f)
      end;
Ausgang: ErsteZeile
    end;                          (* BlockSchreiben *)

    procedure BlockLesen;
    label Ausgang;
    var f          : Text;
     fn             : String[32];
     TL, p          : TextListe;
     n              : Integer;
    begin
     repeat
      gotoxy(1, 1);
      Write('Datei zum Lesen: '); clreol;
      ReadLn(fn); if fn = '' then goto Ausgang;
      (*$I-*) Assign(f, fn); Reset(f) (*$I+*) ;
      if IoResult > 0 then
       begin
        (*$I-*) Assign(f, fn + '.RP'); Reset(f) (*$I+*) ;
       end;
     until IoResult = 0; Close(f);
     BlockMarkieren(BlockAnfang, False);
     if l < x then Zeile := Zeile + Copies(' ', x - l);
     LiesText(f, TL); p := TL;
     if p = nil then n := 0
     else
      begin
       n := 1; while p^.Vor <> nil do
        begin
         n := Succ(n); p := p^.Vor
        end;
      end;
     with BlockEnde do
      begin
       tz := BlockAnfang.tz + Pred(n); tx := Succ(DynStringLength(p^.Zeile));
       if BlockAnfang.tz = tz then tx := Pred(tx + BlockAnfang.tx);
       Markiert := True;
      end;
     SpaltenBlock := False; InsBlock(TL); ShowPage(Top, 1);
     edited := True;
Ausgang: ErsteZeile
    end;                          (* BlockLesen *)

    procedure BlockLoeschen;
    begin
     LiesPositionen(2);
     if not Abbruch and LegalBlock then with BlockAnfang do
      begin
       aktualisiere; RestauriereBlock; DelBlock;
       if SpaltenBlock or (tz = BlockEnde.tz) then aktualisiere;
       if CursorInBlock or (CursorAuf(BlockEnde) and not SpaltenBlock) then
        begin
         Z := tz; x := tx; y := y - Z + tz; if y < 1 then y := 1
        end
       else if not SpaltenBlock and (Z > tz) then
        begin
         if Z - BlockEnde.tz < y then y := y - BlockEnde.tz + tz;
         if y < 1 then y := y - BlockEnde.tz; Z := Z - BlockEnde.tz + tz
        end;
       Markiert := False; BlockEnde.Markiert := False;
       InitEditor;
       edited := True;
      end;
     ErsteZeile
    end;                          (* BlockLoeschen *)

    procedure BlockKopieren;
    var Block      : TextListe;
    begin
     LiesPositionen(3);
     if not Abbruch and LegalBlock and
     (not CursorInBlock or CursorAuf(BlockAnfang)) then
      begin
       aktualisiere; RestauriereBlock;
       if l < x then Zeile := Zeile + Copies(' ', x - l);
       MakeBlock(Block); InsBlock(Block);
       with BlockEnde do
        begin
         if tz = BlockAnfang.tz
         then
          begin
           tz := Z; tx := x + tx - BlockAnfang.tx
          end
         else
          begin
           tz := Z + tz - BlockAnfang.tz;
           if SpaltenBlock then tx := x + tx - BlockAnfang.tx
          end;
        end;
       BlockAnfang.tx := x; BlockAnfang.tz := Z;
       ShowPage(Top, 1);
       edited := True;
      end;
     ErsteZeile
    end;                          (* BlockKopieren *)

    procedure BlockVerschieben;
    var Block      : TextListe; D : DynString; dx, dz : Integer; h : Boolean;
    begin
     LiesPositionen(3);
     if Abbruch or not LegalBlock or
     (CursorInBlock and not(SpaltenBlock and (BlockAnfang.tx = x))) or
     CursorAuf(BlockEnde) then
      begin
       ErsteZeile; Exit
      end;
     aktualisiere; RestauriereBlock;
     if l < x then Zeile := Zeile + Copies(' ', x - l);
     with BlockAnfang do
      begin
       dx := BlockEnde.tx - tx; dz := BlockEnde.tz - tz;
       MakeBlock(Block); DelBlock;
       h := SpaltenBlock or (tz = BlockEnde.tz);
       if h and (Z >= tz) and (Z <= BlockEnde.tz) and (x > tx) then x := x - dx;
       InsBlock(Block);
       edited := True;
       if h then BlockEnde.tx := x + dx
       else if BlockEnde.tz <= Z then
        begin
         if Z - BlockEnde.tz < y then
          begin
           if (Z - tz < y) and (y > dz) then y := y - dz
           else if Z - dz < y then y := Z - dz;
          end;
         Z := Z - dz;
        end;
       tx := x; tz := Z; BlockEnde.tz := tz + dz; InitEditor
      end;
    end;                          (* BlockVerschieben *)

   begin
    if Status then
     begin
      gotoxy(1, 1);
      Write('^K')
     end;
    LiesZeichen(c);
    case c of
     ^D, 'd', 'D' : c := ^[;
     ^X, 'x', 'X' : c := ^[;
     ^S, 's', 'S' : SchreibText(f, t);
     ^Y, 'y', 'Y' : BlockLoeschen;
     ^R, 'r', 'R' : BlockLesen;
     ^W, 'w', 'W' : BlockSchreiben;
     ^C, 'c', 'C' : BlockKopieren;
     ^V, 'v', 'V' : BlockVerschieben;
     ^B, 'b', 'B' : BlockMarkieren(BlockAnfang, True);
     ^K, 'k', 'K' : BlockMarkieren(BlockEnde, True);
     ^H, 'h', 'H' : BlockWegmachen;
     ^L, 'l', 'L' : ZeileMarkieren;
     ^T, 't', 'T' : WortMarkieren;
     ^N, 'n', 'N' :
      begin
       SpaltenBlock := not SpaltenBlock;
       aktualisiere; ShowPage(Top, 1)
      end;
      ^U,'u','U'  :
        begin
          no_pv := not no_pv;
          showPage(top,1);
        end;
    end;
    if Status then
     begin
      gotoxy(1, 1); Write('  ')
     end;
   end;                           (* CtrlK_Menue *)

  begin                           (* EditText *)
   if Spalten >= MaxX then
    Spalten := Pred(MaxX);
   if ZeilenGanz >= MaxY then
    ZeilenGanz := Pred(MaxY);
   SetTextColor;
   BlockAnfang.Markiert := False;
   BlockEnde.Markiert := False;
   InitEditor;
   repeat
    if Status then
     SchreibStatus;
    if HeapAvail < 1000 then
     begin
      gotoxy(1, 1);
      Write(^G'Speicher voll!')
     end;
    if x > Spalten + LR then
     begin
      aktualisiere;
      LR := x - Spalten;
      ShowPage(Top, 1)
     end
    else if x <= LR then
     begin
      aktualisiere;
      LR := Pred(x);
      ShowPage(Top, 1)
     end;
    gotoxy(x - LR, y + RO);
    LiesZeichen(c);
    case c of
     #32..#255 : InsChar;
     ^n :
      begin
       NaechsterBefehl := ^n;
       ZeileEinfuegen(True)
      end;
     ^h : LoeschZeichenLinks;
     ^G : LoeschZeichen;
     ^t : LoeschWort;
     ^y : ZeileLoeschen;
    end;
    case c of
     #13 : NaechsteZeile;
     ^S : if x > 1 then
           x := Pred(x);
     ^D : if x < MaxSpalten then x := Succ(x);
     ^x : ZeileVor;
     ^E : ZeileRueck;
     ^R : SeiteRueck;
     ^c : begin
            ;
            SeiteVor;
          end;
     ^f : WortVor;
     ^A : WortRueck;
     ^W : TiefSchieben;
     ^Z : HochSchieben;
     ^q : CtrlQ_Menue(False);
     ^l : CtrlQ_Menue(True);
     ^K : CtrlK_Menue;
     ^V : ChangeMode;
     ^i : if x < Pred(MaxSpalten - 8) then x := 8 * Succ(x div 8);
     ^[ : ;
    else
     edited := True;              (* CASE *)
    end;
   until (c = #27) ;
   aktualisiere;
  end;                            (* EditText *)
 label xit;

 var
  i              : Word;
 begin
  internfile:= filename;
  openwindow(EdtX1, EdtY1, EdtX2, bildschirmzeilen-1);
  WindowTop(EdtTop);
  CursorOn;
  if getenv('VIDEO') = 'BIOS' then
   DirectVideo := False;
  CheckBreak := False;
  edited := False;
  Assign(f, filename);
  (*$I-*)
  Reset(f);
  (*$I+*)
  if IoResult = 0 then
   begin
    Close(f);
    LiesText(f, T0);
   end
  else
   NeuerText(T0);
  x := 1;
  y := 1;
  Z := 1;
  ClrScr;

  esc_with := 2;
  Errorlevel := 10;
  repeat
   EditText(T0, x, y, Z, 79, bildschirmzeilen-1, True);
   if edited then
    begin
     esc_with := 1;
     esc_with := alertbox(28, 7, filename + ' ok ?', ' J a ! N e i n ', esc_with);
     case esc_with of
      1 :
       begin
        SchreibText(f, T0);
        filename := '';
        Errorlevel := 0;
       end;
      2 :
       filename := '';
      255 :
       esc_with := 2;
     end
    end
   else
    filename := '';
  until filename = '';
  xit:

  LoescheText(T0);
  closewindow;
 end;

end.
