{$M $9000,0,655360 }

const
  horizontal     : Word = 5;
  vertical       : Word = 8;

type                              (*Types for File Headers*)
  fileheaders    = record
                     bftype         : Word;
                     bfsize         : LongInt;
                     bfreserved1, bfreserved2 : Word;
                     bfoffbits      : LongInt;
                   end;
  infoheaders    = record
                     bisize, biwidth, biheight : LongInt;
                     biplanes, bibitcount : Word;
                     bicompression, bisizeimage,
                     bixpelspermeter,
                     bitpelspermeter,
                     biclrused,
                     biclrimportant : LongInt;
                   end;
  entete_bmp     = record
                     fileheader     : fileheaders;
                     infoheader     : infoheaders;
                   end;
    tcouleurs_bmp  = record
                     b, g, r        : Byte;
                   end;

  tligne_24_v    = array[0..$4FFF] of tcouleurs_bmp;
  line           = ^tligne_24_v;
  twrit           = array[0..$3FF0] of Boolean;

  procedure hard_error(nom_fichier : String ; var f:file);
  begin
    WriteLn(nom_fichier);
    ReadLn;
    Close(f);
    Halt;
  end;


var
  fin1,fin2,fx:file;
  kname,name: string[63];
  entete:  entete_bmp;
    origxsize,origfxofs,testxsize,
    origysize,origxmemsize : longint;
    origin:line;
    y:longint;
begin
  name := paramstr(1);
  if Pos('.BMP', name) = 0 then
    name := name + '.BMP';
  Assign(fin1, 'C4'+name);
  {$I-}
  Reset(fin1, 1);
  if IoResult <> 0 then
    hard_error(name + ' not found',fin1);
  {$I+}

  BlockRead(fin1, entete, SizeOf(entete));
  if entete.infoheader.bisize <> 40 then
    hard_error('WINDOWS-BMP only (not OS-BMP)',fin1);
  if entete.fileheader.bftype <> 19778 then
    hard_error('no BMP Header',fin1);
  if entete.infoheader.biplanes <> 1 then
    hard_error('not one picture plane ',fin1);
  if entete.infoheader.bicompression = 1 then
    hard_error('only uncompressed pictures pls',fin1);
  if entete.infoheader.bibitcount <> 24 then
    hard_error('not 24 bit',fin1);
  if entete.infoheader.bisizeimage = 0 then
    hard_error('WINDOWS-BMP only (not OS-BMP)',fin1);

  origxsize := entete.infoheader.biwidth;
  origysize := entete.infoheader.biheight;
  origfxofs := entete.fileheader.bfoffbits;


  testxsize := entete.infoheader.bisizeimage div (origysize);
 {   if testxsize <> origxsize * 3 then
      hard_error('strange '+name); }

  origxmemsize := testxsize;      {origxsize * SizeOf(tcouleurs_bmp);}

  Assign(fin2, 'C-4'+name);
  {$I-}
  Reset(fin2, 1);
  if IoResult <> 0 then
    hard_error('C-4'+ name + ' not found',fin2);
  {$I+}

  BlockRead(fin2, entete, SizeOf(entete));
  if entete.infoheader.bisize <> 40 then
    hard_error('WINDOWS-BMP only (not OS-BMP)',fin2);
  if entete.fileheader.bftype <> 19778 then
    hard_error('no BMP Header',fin2);
  if entete.infoheader.biplanes <> 1 then
    hard_error('not one picture plane ',fin2);
  if entete.infoheader.bicompression = 1 then
    hard_error('only uncompressed pictures pls',fin2);
  if entete.infoheader.bibitcount <> 24 then
    hard_error('not 24 bit',fin2);
  if entete.infoheader.bisizeimage = 0 then
    hard_error('WINDOWS-BMP only (not OS-BMP)',fin2);




  GetMem(origin, origxmemsize*2);





  kname:= 'D4'+name;
  Assign(fx, kname);
  Rewrite(fx, 1);
  entete.infoheader.biwidth := entete.infoheader.biwidth*2;
  entete.infoheader.bisizeimage  := entete.infoheader.bisizeimage*2;
  entete.fileheader.bfsize  := entete.infoheader.bisizeimage+54;


  blockwrite(fx,entete,origfxofs);
  for y:=1 to origysize do
  begin
    blockread(fin1,origin^,origxmemsize);
    blockread(fin2,origin^[origxsize],origxmemsize);

    blockwrite(fx,origin^, 2* origxmemsize);
  end;
  close(fin1);
  close(fin2);
  close(fx);
  freeMem(origin, origxmemsize*2);
 end.