;****************************************************************************************
 ;                          			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   m0-3.asm (macros)                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*		         					*
;*                                                                     			*
;****************************************************************************************
	list      p=10F200	; list directive to define processor
	#include  ..\m0-3.asm
	config_
 	
#define	OPTIONinit	b'11000111'	; no wakup, no pullup, Clock 1:256
#define TRISIOinit 	b'00001011'	; all ports output bar GP3	
#define GPIOinit 	b'00000000'	; GPIO  all LOW 
;****************************************************************************************

	init_			; reasonable initiation of special function registers 


	cblock	_MINRAM			; start of variables
	 Sys1,Tck,FlipDty,PR_Duty:2,TMR0save,TMR0high,Case
	endc
#define STACK		_MAXRAM
#define ShdGP3		Sys1,3
#define nega_bit	Sys1,0
#define	TMR07Bit	Sys1,7

#define OUTP		2

RESET1
	eq_		PR_Duty,=,.254,lit8
	movwf	FlipDty
	movwf	Tck
	bcf		GPIO,OUTP
    movlw	case0
	movwf	Case
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
main
   if_m	TMR0,!=,TMR0save, byte
    eq_ TMR0save,=,TMR0,byte
	eq_	PCL,=,Case,byte
case0
	movlw	case1
	if_ GPIO,3,is_on,1
      movwf	Case
    goto endcase
case1
    if_ GPIO,3,is_on,1
     goto endcase
    clrf	TMR0
	clrf	TMR0high
	bcf		TMR07Bit
    movlw 	case2
	movwf	Case
    goto	endcase
case2
	movlw	case3
	if_ GPIO,3,is_on,1
      movwf	Case
    goto endcase
case3
	if_ GPIO,3,is_on,1
     goto endcase
    bcf	nega_bit
	 if_ PR_Duty,!=,FlipDty,byte
         bsf nega_bit
	 eq_	PR_Duty,=,TMR0,byte
     eq_	PR_Duty+1,=,TMR0high,byte
	 clrC		
     rrf	PR_Duty+1,f
	 rrf	PR_Duty,f
	 clrC		
     rrf	PR_Duty+1,f
	 rrf	   PR_Duty,f
	clrC		
     rrf	PR_Duty+1,f
	 rrf	PR_Duty,f	; div 8

	 movfw	PR_Duty
     if_	nega_bit,is_on,singlebit
        comf	PR_Duty,W
 	 movwf	FlipDty
     movlw	case0
     movwf	Case
     goto tick
  else_m
	goto $+1
	goto $+1
  end_m
endcase


	if_	    TMR0,7,is_on, singlebit			; software emulation of
	 goto	set7			; timer 0 overflow
	if_not	TMR07Bit		;
	 goto	set7+1
	bcf	TMR07Bit
	if_ TMR0high,==,7,lit8
	 goto RESET1
    incf	TMR0high,f
    goto	set7+1
set7	
	bsf	TMR07Bit


tick
	decfsz	Tck,F
	 goto tst3
    
flip
	do_		GPIO,=,GPIO,XOR,1<<OUTP,	lit8
	comf	FlipDty,F
	eq_		Tck,=,FlipDty,byte
    GOTO	main
tst3
  	;nop
    goto    main-3

mainflip
    goto $+1
    goto $+1
    goto $+1
    goto flip

		end