;*************************************************************************************
;*   This file is the firmware to implement 
;    the battery switcher on PCB
;*                                                                     			
;*************************************************************************************	
;*                                                                 			         *
;*    Filename:	    test for pic16F506  .asm                              		     *
;*    Date:         Oct, 2014                                   			         *
;*    File Version: A, this is a new file                                    		 *
;*                                                                     			     *
;*    Author:       G Michael                                       		         *
;*                  Applications Engineer                    				         *
;*    Company:                                                                       *
;*                                               			                         *
;*************************************************************************************
;*                                			                                         *
;*    Files required:   m0-4.asm (macros) for NATURAL assembler User Interface       *               
;*************************************************************************************                                                                     			*
;********************************************************************************
;*                                                                     			*
;*    Notes:        hardware solar/batt_swtch2.brd								*
;*		         					*
;*                                                                     			*
;********************************************************************************
		list      p=16F506  ; define processor
		#include  ..\m0-4.asm
		config_
		#define	OPTIONinit	b'11000101'	; no wakup, no pullup, Clock 1:64
		#define TRISBinit 	b'11111111'	; all ports input bar PB4,5	
		#define PORTBinit 	b'00000000'	; BIO  all LOW 
		#define TRISCinit 	b'11011110'	; all ports output 	
		#define PORTCinit 	b'00000000'	; CIO  all LOW 
		#define ADCON0init 	b'01111001'	; all digital but AN2 ,intosc,RB2,GO_NOT_DONE,enable
		

;****************************************************************************************
  
		cblock	_MINRAM			; start of variables
		 ;shdwTRISB,
		 SyS1 ,Avr:2,TAvr
		endc  

	init_			; reasonable initiation of special function registers 
	
;		cblock Bank1
;		 Result1x
;		endc
;		cblock Bank2
;		 Result2
;		endc
;		cblock Bank3
;		 Result3
;		endc
;
		#define STACK		_MAXRAM
		#define	TMR07Bit	SyS1,7
		#define	PORTset		SyS1,6	

;PWRUP	
	

		#define	TC0used 3					; use 3 bytes of timer for TC0
		cblock
		 TC0:TC0used
		 NmbrEvent0
		endc	
		#define TC1used 2
		cblock
			 TC1:TC1used,NmbrEvent1
		endc

	eq_	ADCON0,=, 	b'11110101',lit8	; all analog,intosc,RB1,GO_NOT_DONE,enable
;	eq_	ADCON0,=, 	b'11110001',lit8	; all analog,intosc,RB0,GO_NOT_DONE,enable
;	eq_	ADCON0,=, 	b'11111001',lit8	; all analog,intosc,RB2,GO_NOT_DONE,enable
;
;	eq_		Index,=,0,	lit8
;
	clrf	Avr
	bcf		PORTC,0
	delay	.10000 
	clrf		SyS1
	EVENT0in	.500,msec,0xFF  ; set time @ 500 milliseconds
	clrf		NmbrEvent0		; set execution  for EVENT0

	EVENT1in	.500,msec,.14
JMPTable	
	andlw	0x0F
	addwf	PCL,F
	 goto	EVENT0	
	 goto	EVENT1
	 goto	EVENT2	
	 goto	EVENT3
	 goto	EVENT4
	 goto	EVENT5
	 goto	EVENT6
	 goto	EVENT7
	 goto	EVENT8
	 goto	EVENT9
	 goto	EVENT10
	 goto	EVENT11
	 goto	EVENT12
	 goto	EVENT13
	 goto	EVENT14
	 goto	EVENT15

del1sec	
	delay .1000000
	retlw	0

vtable
	addwf	PCL,F
	dt	PORTC,b'00100000'	;LED4 0
	dt	PORTC,b'00010000'	;LED3 1
	dt	PORTC,b'00001000'	;LED2 2
	dt	PORTB,b'00010000'	;LED1 3

	dt	PORTC,b'00000001'	;LED5 4
	dt	PORTC,b'00000010'	;LED6 5
	dt	PORTC,b'00000100'	;LED7 6
	dt	PORTB,b'00100000'	;LED8 7
avrof4		
	clrf	Avr+1
	movfw	INDF
	addwf	INDF,F
	skpNC
	 incf	Avr+1,F
	addwf	INDF,F
	skpNC
	 incf	Avr+1,F
	movfw	TAvr		; Value to add
	addwf	INDF,F
	skpNC
	 incf	Avr+1,F

	clrC
	rrf	Avr+1,F
	rrf	INDF,F
	clrC
	rrf	Avr+1,F
	rrf	INDF,F		; result in INDF^

	retlw 0	




;loop
;
;
;
;	call	del1sec
;	movlw	.4*2
;	call	vtable
;		movwf	FSR
;	movlw	.4*2+1
;	call	vtable
;	iorwf	INDF,F
;
;	call	del1sec
;	call	del1sec
;
;
;	goto loop
MLOOP	

	clrwdt
	if_		TMR0,7,is_on,1			; software emulation of
	 goto	set7					; timer 0 overflow
	if_		TMR07Bit,is_off,1		;
	 goto	set7+1
	bcf		TMR07Bit

	if_m	PORTset,is_off,1
	 	bsf	ADCON0,GO_NOT_DONE
		if_	ADCON0,GO_NOT_DONE,is_on,1
	      goto	$-1
		
		movlw	Avr
		movwf	FSR
		eq_		TAvr,=,ADRES,byte
		call	avrof4
	
		if_m Avr,>,.126,lit8		
		  bsf PORTC,0
		  bsf PORTset
	;		incf	Index,F
	;		if_		Index,>,3,lit8
	;		 clrf	Index
	;		clrC
	;		rlf		Index,W
	;		movwf	Result
	;		call	vtable
	;		movwf	FSR
	;		incf	Result,W
	;		call	vtable
	;		iorwf	INDF,f	; switch on	
	;
	;		CALL	del1sec
	;
	;		if_m	Index,>=,1,lit8
	;	      decf	Index,F
	;		else_m
	;		  eq_	Index,=,3,lit8 
	;		end_m
	;
	;		clrC
	;		rlf		Index,W
	;		movwf	Result
	;		call	vtable
	;		movwf	FSR
	;		incf	Result,W
	;		call	vtable
	;		xorlw	0xFF
	;		andwf	INDF,f		;switch off
	;	
	;		incf	Index,F
	;		if_		Index,>,3,lit8
	;		 clrf	Index
	;
		
	  	end_m
	end_m
	decfsz	TC0,F
	 goto	endMLOOP0
	decfsz	TC0+1,F
	 goto	endMLOOP0
	decfsz	TC0+2,F
	 goto	endMLOOP0

	movfw	NmbrEvent0		; after TC0+2 expired, 
	goto	JMPTable 		; now jump to loaded Event

end0MLOOP0
endMLOOP0
	decfsz	TC1,F
	 goto	endMLOOP1
	decfsz	TC1+1,F
	 goto	endMLOOP1
	movfw	NmbrEvent1		; after TC1+1 expired, 
	goto	JMPTable 		; now jump to loaded Event

end0MLOOP1
endMLOOP1

;	if_		GPIO,3,is_on,1
;     goto    MLOOP
;    bcf		GPIO,2			;switchoff for power saving
;moreslp  
;	      sleep
;afterwdt
;	if_		GPIO,3,is_off,1
;      goto	moreslp
;	if_m	MemHilo,is_on,1
;      bcf	MemHilo
;      goto EVENT0
;    end_m
;    bsf	MemHilo
;	goto EVENT0
	GOTO	MLOOP
set7	
	bsf	TMR07Bit
	goto	MLOOP

		#define	fac	.3600

EVENT0	
	
		EVENT0in fac*.4,sec,.1	;loop
	
EVENT1	
		bcf		PORTC,0
		bcf		PORTset
		EVENT0in fac*.4,sec,.0	;loop
EVENT2			
		
EVENT3
		 
EVENT4		

EVENT5		
		
EVENT6	

EVENT7		

EVENT8		

EVENT9		

EVENT10		

EVENT11		


EVENT12	
	
EVENT13
;		eq_		Reslt+1,=,ADRES,byte	
;	eq_		Reslt+2,=,0,lit8
;	do_		Reslt+1,=,Reslt+1,*,.9,lit16
;
;	eq_		Count,=,.10,lit8
;
;blink
;    exec_vardelay Reslt	
;
;		
;	decfsz	Count,F
;	 goto	blink
;	
EVENT14 
	#define INDEX	0; LED4

	movlw	INDEX*2
	call	vtable
	movwf	FSR
	movlw	INDEX*2+1
	call	vtable
	xorwf	INDF,F
	
	do_		TC1,=,Avr,-,.128,lit8
	comf	TC1,f
	eq_		TC1+1,=,1,lit8

	goto MLOOP

EVENT15 
	




 end