;*************************************************************************************
;*   This file is the firmware to implement 
;    the battery switcher on PCB
;*                                                                     			
;*************************************************************************************	
;*                                                                 			         *
;*    Filename:	    test for pic16F506  .asm                              		     *
;*    Date:         Oct, 2014                                   			         *
;*    File Version: A, this is a new file                                    		 *
;*                                                                     			     *
;*    Author:       G Michael                                       		         *
;*                  Applications Engineer                    				         *
;*    Company:                                                                       *
;*                                               			                         *
;*************************************************************************************
;*                                			                                         *
;*    Files required:   m0-4.asm (macros) for NATURAL assembler User Interface       *               
;*************************************************************************************                                                                     			*
;********************************************************************************
;*                                                                     			*
;*    Notes:        hardware solar/batt_swtch2.brd								*
;*		         					*
;*                                                                     			*
;********************************************************************************
		list      p=16F506  ; define processor
		#include  ..\m0-4.asm
		config_
		#define	OPTIONinit	b'11000101'	; no wakup, no pullup, Clock 1:64
		#define TRISBinit 	b'11111111'	; all ports input bar PB4,5	
		#define PORTBinit 	b'00000000'	; BIO  all LOW 
		#define TRISCinit 	b'11011110'	; all ports output 	
		#define PORTCinit 	b'00000000'	; CIO  all LOW 
		#define ADCON0init 	b'01111001'	; all digital but AN2 ,intosc,RB2,GO_NOT_DONE,enable
		

;****************************************************************************************
  
		cblock	_MINRAM			; start of variables
		 ;shdwTRISB,
		 SyS1 ,Avr:2,TAvr
		endc  

	init_			; reasonable initiation of special function registers 
	
;		cblock Bank1
;		 Result1x
;		endc
;		cblock Bank2
;		 Result2
;		endc
;		cblock Bank3
;		 Result3
;		endc
;
		#define STACK		_MAXRAM
		#define	TMR07Bit	SyS1,7

;PWRUP	
	

		#define	TC0used 3					; use 3 bytes of timer for TC0
		cblock
		 TC0:TC0used
		 NmbrEvent0
		endc	
		#define TC1used 2
		cblock
			 TC1:TC1used,NmbrEvent1
		endc

	eq_	ADCON0,=, 	b'11110101',lit8	; all analog,intosc,RB1,GO_NOT_DONE,enable
;	eq_	ADCON0,=, 	b'11110001',lit8	; all analog,intosc,RB0,GO_NOT_DONE,enable
;	eq_	ADCON0,=, 	b'11111001',lit8	; all analog,intosc,RB2,GO_NOT_DONE,enable
;
;	eq_		Index,=,0,	lit8
;
	clrf	Avr
	bcf		PORTC,0
	delay	.10000 
	clrf		SyS1
	EVENT0in	.500,msec,0xFF  ; set time @ 500 milliseconds
	clrf		NmbrEvent0		; set execution  for EVENT0

	EVENT1in	.500,msec,.14
JMPTable	
	andlw	0x0F
	addwf	PCL,F
	 goto	EVENT0	
	 goto	EVENT1
	 goto	EVENT2	
	 goto	EVENT3
	 goto	EVENT4
	 goto	EVENT5
	 goto	EVENT6
	 goto	EVENT7
	 goto	EVENT8
	 goto	EVENT9
	 goto	EVENT10
	 goto	EVENT11
	 goto	EVENT12
	 goto	EVENT13
	 goto	EVENT14
	 goto	EVENT15

del1sec	
	delay .1000000
	retlw	0

vtable
	addwf	PCL,F
	dt	PORTC,b'00100000'	;LED4 0
	dt	PORTC,b'00010000'	;LED3 1
	dt	PORTC,b'00001000'	;LED2 2
	dt	PORTB,b'00010000'	;LED1 3

	dt	PORTC,b'00000001'	;LED5 4
	dt	PORTC,b'00000010'	;LED6 5
	dt	PORTC,b'00000100'	;LED7 6
	dt	PORTB,b'00100000'	;LED8 7
avrof4		
	clrf	Avr+1
	movfw	INDF
	addwf	INDF,F
	skpNC
	 incf	Avr+1,F
	addwf	INDF,F
	skpNC
	 incf	Avr+1,F
	movfw	TAvr		; Value to add
	addwf	INDF,F
	skpNC
	 incf	Avr+1,F

	clrC
	rrf	Avr+1,F
	rrf	INDF,F
	clrC
	rrf	Avr+1,F
	rrf	INDF,F		; result in INDF^

	retlw 0	




;loop
;
;
;
;	call	del1sec
;	movlw	.4*2
;	call	vtable
;		movwf	FSR
;	movlw	.4*2+1
;	call	vtable
;	iorwf	INDF,F
;
;	call	del1sec
;	call	del1sec
;
;
;	goto loop
MLOOP	

	clrwdt
	if_		TMR0,7,is_on,1			; software emulation of
	 goto	set7					; timer 0 overflow
	if_		TMR07Bit,is_off,1		;
	 goto	set7+1
	bcf		TMR07Bit

	eq_	ADCON0,=, 	b'11110001',lit8	; all analog,intosc,RB0,GO_NOT_DONE,enable

 	bsf	ADCON0,GO_NOT_DONE
	if_	ADCON0,GO_NOT_DONE,is_on,1
	 goto	$-1
		
		#define	Panel		SyS1,5	

    bcf Panel
	if_	ADRES,>,.50,lit8		; 1 Volt
      bsf  Panel

	eq_	ADCON0,=, 	b'11110101',lit8	; all analog,intosc,RB1,GO_NOT_DONE,enable

 	bsf	ADCON0,GO_NOT_DONE
	if_	ADCON0,GO_NOT_DONE,is_on,1
      goto	$-1
	
	movlw	Avr
	movwf	FSR
	eq_		TAvr,=,ADRES,byte
	call	avrof4
	
	if_ Panel,is_off,.1
	  goto	EVENT1

;	if solar panel fails
;	 switch off booster
;    switch off charger
;	else
;	 make boost voltage
;	  or maintain	float voltage
;	 	 and switch on charger
		#define	Charger		SyS1,6	

	if_m	Charger,is_off,1
		if_m Avr,>,.126,lit8	; 2.5 Volt		
		  bsf PORTC,0
		  bsf Charger
	  	end_m
	end_m
	decfsz	TC0,F
	 goto	endMLOOP0
	decfsz	TC0+1,F
	 goto	endMLOOP0
	decfsz	TC0+2,F
	 goto	endMLOOP0

	movfw	NmbrEvent0		; after TC0+2 expired, 
	goto	JMPTable 		; now jump to loaded Event

end0MLOOP0
endMLOOP0
	decfsz	TC1,F
	 goto	endMLOOP1
	decfsz	TC1+1,F
	 goto	endMLOOP1
	movfw	NmbrEvent1		; after TC1+1 expired, 
	goto	JMPTable 		; now jump to loaded Event

end0MLOOP1
endMLOOP1

	GOTO	MLOOP
set7	
	bsf	TMR07Bit
	goto	MLOOP

		#define	fac	.3600

EVENT0	
	
	EVENT0in fac*.6,sec,.1	;loop
	
EVENT1	
	bcf		PORTC,0
	bcf		Charger
	EVENT0in fac*.6,sec,.0	;loop
EVENT2			
		
EVENT3
		 
EVENT4		

EVENT5		
		
EVENT6	

EVENT7		

EVENT8		

EVENT9		

EVENT10		

EVENT11		


EVENT12	
	
EVENT13

EVENT14 
	#define INDEX	0; LED4

	movlw	INDEX*2
	call	vtable
	movwf	FSR
	movlw	INDEX*2+1
	call	vtable

	if_m		Panel,is_off,1
	 iorwf	INDF,F
	  EVENT1in	.100,msec,.15
	end_m
	xorwf	INDF,F
	
	do_		TC1,=,Avr,-,.128,lit8
	comf	TC1,f
	eq_		TC1+1,=,1,lit8

	goto MLOOP

EVENT15 
	movlw	INDEX*2
	call	vtable
	movwf	FSR
	movlw	INDEX*2+1
	call	vtable
	xorlw	0xFF
	andwf	INDF,f	
	EVENT1in	.900,msec,.14


 end