;****************************************************************************************
;*   This file is the firmware to implement 

;*                                                                     			*
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    test for pic16F506  .asm                              		                *
;*    Date:         Feb, 2014                                   			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael                                       		*
;*                  Applications Engineer                    				*
;*    Company:                      *
;*                                               			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   m0-4.asm (macros)                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*		         					*
;*                                                                     			*
;****************************************************************************************
	list      p=16F506  ; define processor
	#include  ..\m0-4.asm
	config_
#define	OPTIONinit	b'11000101'	; no wakup, no pullup, Clock 1:32
#define TRISBinit 	b'11111011'	; all ports input bar PB2	
#define PORTBinit 	b'00000000'	; BIO  all LOW 
#define TRISCinit 	b'11111011'	; all ports input bar PC2	
#define PORTCinit 	b'00000000'	; CIO  all LOW 
#define ADCON0init 	b'11110001'	; all analog,intosc,RB0,GO_NOT_DONE,enable


;****************************************************************************************
  
	cblock	_MINRAM			; start of variables
	 shdwTRISB,SyS1,SyS2,Result,Result1
	endc  

	init_			; reasonable initiation of special function registers 


	
	cblock Bank1
	 Result1x
	endc
	cblock Bank2
	 Result2
	endc
	cblock Bank3
	 Result3
	endc

#define STACK		_MAXRAM




main

	bsf	ADCON0,GO_NOT_DONE
	if_	ADCON0,GO_NOT_DONE,is_on,1
      goto	$-1

	do_	shdwTRISB,=,shdwTRISB,OR,b'00010000',lit8
	movfw	shdwTRISB
	TRIS	PORTB							;black


	if_m ADRES,>,.156,lit8		
	  do_	shdwTRISB,=,shdwTRISB,AND,b'11101111',lit8
  	  movfw	shdwTRISB
	  TRIS	PORTB
	  do_	PORTB,=,PORTB,OR,b'00010000',	lit8
  	end_m


	if_m ADRES,<,.100,lit8
	  do_	shdwTRISB,=,shdwTRISB,AND,b'11101111',lit8
  	  movfw	shdwTRISB
	  TRIS	PORTB
	  do_	PORTB,=,PORTB,AND,b'11101111',	lit8
	end_m

	eq_	ADCON0,=, 	b'11110101',lit8	; all analog,intosc,RB1,GO_NOT_DONE,enable

	delay .1000000


	bsf	ADCON0,GO_NOT_DONE
	if_	ADCON0,GO_NOT_DONE,is_on,1
      goto	$-1

	do_	shdwTRISB,=,shdwTRISB,OR,b'00100000',lit8
	movfw	shdwTRISB
	TRIS	PORTB


	if_m ADRES,>,.156,lit8		
	  do_	shdwTRISB,=,shdwTRISB,AND,b'11011111',lit8
  	  movfw	shdwTRISB
	  TRIS	PORTB
	  do_	PORTB,=,PORTB,OR,b'00100000',	lit8
  	end_m


	if_m ADRES,<,.100,lit8
	  do_	shdwTRISB,=,shdwTRISB,AND,b'11011111',lit8
  	  movfw	shdwTRISB
	  TRIS	PORTB
	  do_	PORTB,=,PORTB,AND,b'11011111',	lit8
	end_m

	eq_	ADCON0,=, 	b'11110001',lit8	; all analog,intosc,RB0,GO_NOT_DONE,enable

	delay .1000000



	goto main
 end