;****************************************************************************************
;*   This file is the firmware to implement 

;*                                                                     			*
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    test for pic16F506  .asm                              		                *
;*    Date:         Oct, 2014                                   			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael                                       		*
;*                  Applications Engineer                    				*
;*    Company:                      *
;*                                               			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   m0-4.asm (macros)                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*		         					*
;*                                                                     			*
;****************************************************************************************
	list      p=16F506  ; define processor
	#include  ..\m0-4.asm
	config_
#define	OPTIONinit	b'11000101'	; no wakup, no pullup, Clock 1:32
#define TRISBinit 	b'11101111'	; all ports input bar PB4	
#define PORTBinit 	b'00000000'	; BIO  all LOW 
#define TRISCinit 	b'11000111'	; all ports input bar PC3,4,5	
#define PORTCinit 	b'00000000'	; CIO  all LOW 
#define ADCON0init 	b'01111001'	; all digital but AN2 ,intosc,RB2,GO_NOT_DONE,enable


;****************************************************************************************
  
	cblock	_MINRAM			; start of variables
	 ;shdwTRISB,
	 SyS1,SyS2,Result,Result1,Index
	endc  

	init_			; reasonable initiation of special function registers 

	goto	main
	
	cblock Bank1
	 Result1x
	endc
	cblock Bank2
	 Result2
	endc
	cblock Bank3
	 Result3
	endc

#define STACK		_MAXRAM

vtable
	addwf	PCL,F
	dt	PORTC,b'00100000'
	dt	PORTC,b'00010000'
	dt	PORTC,b'00001000'
	dt	PORTB,b'00010000'
main
	eq_		Index,=,0,	lit8
	bsf		PORTC,5
loop


	bsf	ADCON0,GO_NOT_DONE
	if_	ADCON0,GO_NOT_DONE,is_on,1
      goto	$-1


	if_m ADRES,>,.20,lit8		
		
		clrC
		rlf		Index,W
		movwf	Result
		call	vtable
		movwf	FSR
		incf	Result,W
		call	vtable
		xorlw	0xFF
		andwf	INDF,f
		incf	Index,F
		if_		Index,>,3,lit8
		 clrf	Index
		clrC
		rlf		Index,W
		movwf	Result
		call	vtable
		movwf	FSR
		incf	Result,W
		call	vtable
		iorwf	INDF,f
  	end_m

	delay .1000000



	goto loop
 end