;****************************************************************************************
;*   This file is the firmware to implement 

;*                                                                     			*
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    test for pic16F506  .asm                              		                *
;*    Date:         Oct, 2014                                   			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael                                       		*
;*                  Applications Engineer                    				*
;*    Company:                      *
;*                                               			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   m0-4.asm (macros)                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*		         					*
;*                                                                     			*
;****************************************************************************************
	list      p=16F506  ; define processor
	#include  ..\m0-4.asm
	config_
#define	OPTIONinit	b'11000101'	; no wakup, no pullup, Clock 1:32
#define TRISBinit 	b'11101111'	; all ports input bar PB4	
#define PORTBinit 	b'00000000'	; BIO  all LOW 
#define TRISCinit 	b'11000111'	; all ports input bar PC3,4,5	
#define PORTCinit 	b'00000000'	; CIO  all LOW 
#define ADCON0init 	b'01111001'	; all digital but AN2 ,intosc,RB2,GO_NOT_DONE,enable


;****************************************************************************************
  
	cblock	_MINRAM			; start of variables
	 ;shdwTRISB,
	 Reslt:3,Count
	endc  

	init_			; reasonable initiation of special function registers 

	goto	main


#define STACK		_MAXRAM

	goto loop

vtable
	addwf	PCL,F
	dt	PORTC,b'00100000'	;LED4 0
	dt	PORTC,b'00010000'	;LED3 1
	dt	PORTC,b'00001000'	;LED2 2
	dt	PORTB,b'00010000'	;LED1 3

	dt	PORTC,b'00000001'	;LED5 4
	dt	PORTC,b'00000010'	;LED6 5
	dt	PORTC,b'00000100'	;LED7 6
	dt	PORTB,b'00100000'	;LED8 7	

del1sec	
	delay .1000000
	retlw	0
main
	vardelay	Reslt,.2500000
	eq_	ADCON0,=, 	b'11110101',lit8	; all analog,intosc,RB1,GO_NOT_DONE,enable
;	eq_	ADCON0,=, 	b'11110001',lit8	; all analog,intosc,RB0,GO_NOT_DONE,enable
;	eq_	ADCON0,=, 	b'11111001',lit8	; all analog,intosc,RB2,GO_NOT_DONE,enable
loop

	
	bsf	ADCON0,GO_NOT_DONE
	if_	ADCON0,GO_NOT_DONE,is_on,1
      goto	$-1


	eq_		Reslt+1,=,ADRES,byte	
	eq_		Reslt+2,=,0,lit8
	do_		Reslt+1,=,Reslt+1,*,.9,lit16

	eq_		Count,=,.10,lit8

blink
    exec_vardelay Reslt	

		#define INDEX	0

	movlw	INDEX*2
	call	vtable
	movwf	FSR
	movlw	INDEX*2+1
	call	vtable
	xorwf	INDF,F
	decfsz	Count,F
	 goto	blink
	goto loop
 end